/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumUtil.class);
    private final Map<Long, QuorumPeer.QuorumServer> peersView = new HashMap<Long, QuorumPeer.QuorumServer>();
    private final Map<Integer, PeerStruct> peers = new HashMap<Integer, PeerStruct>();
    public final int N;
    public final int ALL;
    private String hostPort;
    private int tickTime;
    private int initLimit;
    private int syncLimit;
    private int electionAlg;

    public QuorumUtil(int n) throws RuntimeException {
        try {
            PeerStruct ps;
            ClientBase.setupTestEnv();
            JMXEnv.setUp();
            this.N = n;
            this.ALL = 2 * this.N + 1;
            this.tickTime = 2000;
            this.initLimit = 3;
            this.syncLimit = 3;
            this.electionAlg = 3;
            this.hostPort = "";
            int i = 1;
            while (i <= this.ALL) {
                ps = new PeerStruct();
                ps.id = i;
                ps.dataDir = ClientBase.createTmpDir();
                ps.clientPort = PortAssignment.unique();
                this.peers.put(i, ps);
                this.peersView.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress("127.0.0.1", ps.clientPort + 1000), new InetSocketAddress("127.0.0.1", PortAssignment.unique() + 1000), QuorumPeer.LearnerType.PARTICIPANT));
                this.hostPort = String.valueOf(this.hostPort) + "127.0.0.1:" + ps.clientPort + (i == this.ALL ? "" : ",");
                ++i;
            }
            i = 1;
            while (i <= this.ALL) {
                ps = this.peers.get(i);
                LOG.info("Creating QuorumPeer " + i + "; public port " + ps.clientPort);
                ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
                Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PeerStruct getPeer(int id) {
        return this.peers.get(id);
    }

    public void startAll() throws IOException {
        this.shutdownAll();
        int i = 1;
        while (i <= this.ALL) {
            this.start(i);
            LOG.info("Started QuorumPeer " + i);
            ++i;
        }
        LOG.info("Checking ports " + this.hostPort);
        String[] stringArray = this.hostPort.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String hp = stringArray[n2];
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(String.valueOf(hp) + " is accepting client connections");
            ++n2;
        }
        try {
            JMXEnv.dump();
            LinkedHashSet<String> ensureNames = new LinkedHashSet<String>();
            int i2 = 1;
            while (i2 <= this.ALL) {
                ensureNames.add("InMemoryDataTree");
                ++i2;
            }
            i2 = 1;
            while (i2 <= this.ALL) {
                ensureNames.add("name0=ReplicatedServer_id" + i2 + ",name1=replica." + i2 + ",name2=");
                ++i2;
            }
            i2 = 1;
            while (i2 <= this.ALL) {
                int j = 1;
                while (j <= this.ALL) {
                    ensureNames.add("name0=ReplicatedServer_id" + i2 + ",name1=replica." + j);
                    ++j;
                }
                ++i2;
            }
            i2 = 1;
            while (i2 <= this.ALL) {
                ensureNames.add("name0=ReplicatedServer_id" + i2);
                ++i2;
            }
            JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
        }
        catch (IOException e) {
            LOG.warn("IOException during JMXEnv operation", (Throwable)e);
        }
    }

    public void startQuorum() throws IOException {
        this.shutdownAll();
        int i = 1;
        while (i <= this.N + 1) {
            this.start(i);
            ++i;
        }
        i = 1;
        while (i <= this.N + 1) {
            Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)i).clientPort, ClientBase.CONNECTION_TIMEOUT));
            ++i;
        }
    }

    public void start(int id) throws IOException {
        PeerStruct ps = this.getPeer(id);
        LOG.info("Creating QuorumPeer " + ps.id + "; public port " + ps.clientPort);
        ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
        Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
        ps.peer.start();
    }

    public void restart(int id) throws IOException {
        this.start(id);
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)id).clientPort, ClientBase.CONNECTION_TIMEOUT));
    }

    public void startThenShutdown(int id) throws IOException {
        PeerStruct ps = this.getPeer(id);
        LOG.info("Creating QuorumPeer " + ps.id + "; public port " + ps.clientPort);
        ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
        Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
        ps.peer.start();
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)id).clientPort, ClientBase.CONNECTION_TIMEOUT));
        this.shutdown(id);
    }

    public void shutdownAll() {
        int i = 1;
        while (i <= this.ALL) {
            this.shutdown(i);
            ++i;
        }
        String[] stringArray = this.hostPort.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String hp = stringArray[n2];
            Assert.assertTrue((String)"Waiting for server down", (boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(String.valueOf(hp) + " is no longer accepting client connections");
            ++n2;
        }
    }

    public void shutdown(int id) {
        QuorumPeer qp = this.getPeer((int)id).peer;
        try {
            LOG.info("Shutting down quorum peer " + qp.getName());
            qp.shutdown();
            Election e = qp.getElectionAlg();
            if (e != null) {
                LOG.info("Shutting down leader election " + qp.getName());
                e.shutdown();
            } else {
                LOG.info("No election available to shutdown " + qp.getName());
            }
            LOG.info("Waiting for " + qp.getName() + " to exit thread");
            qp.join(30000L);
            if (qp.isAlive()) {
                Assert.fail((String)("QP failed to shutdown in 30 seconds: " + qp.getName()));
            }
        }
        catch (InterruptedException e) {
            LOG.debug("QP interrupted: " + qp.getName(), (Throwable)e);
        }
    }

    public String getConnString() {
        return this.hostPort;
    }

    public void tearDown() throws Exception {
        LOG.info("TearDown started");
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            LOG.info("fdcount after test is: " + unixos.getOpenFileDescriptorCount());
        }
        this.shutdownAll();
        JMXEnv.tearDown();
    }

    public class PeerStruct {
        public int id;
        public QuorumPeer peer;
        public File dataDir;
        public int clientPort;
    }
}

