/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayOutputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ReadOnlyModeTest
extends ZKTestCase {
    private static int CONNECTION_TIMEOUT = QuorumBase.CONNECTION_TIMEOUT;
    private QuorumUtil qu = new QuorumUtil(1);

    @Before
    public void setUp() throws Exception {
        System.setProperty("readonlymode.enabled", "true");
        this.qu.startQuorum();
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("readonlymode.enabled", "false");
        this.qu.tearDown();
    }

    @Test
    public void testReadOnlyClient() throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String data = "Data to be read in RO mode";
        String node = "/tnode";
        zk.create("/tnode", "Data to be read in RO mode".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        watcher.reset();
        this.qu.shutdown(2);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String remoteData = new String(zk.getData("/tnode", false, null));
        Assert.assertEquals((String)"Data to be read in RO mode", (String)remoteData);
        try {
            zk.setData("/tnode", "no way".getBytes(), -1);
            Assert.fail((String)"Write operation has succeeded during RO mode");
        }
        catch (KeeperException.NotReadOnlyException notReadOnlyException) {
            // empty catch block
        }
        watcher.reset();
        this.qu.start(2);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.qu.getPeer((int)2).clientPort, CONNECTION_TIMEOUT));
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        zk.setData("/tnode", "We're in the quorum now".getBytes(), -1);
        zk.close();
    }

    @Test
    public void testConnectionEvents() throws Exception {
        final ArrayList states = new ArrayList();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, new Watcher(){

            public void process(WatchedEvent event) {
                states.add(event.getState());
            }
        }, true);
        boolean success = false;
        int i = 0;
        while (i < 30) {
            try {
                zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                success = true;
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                Thread.sleep(1000L);
                ++i;
            }
        }
        Assert.assertTrue((String)"Did not succeed in connecting in 30s", (boolean)success);
        this.qu.shutdown(2);
        long start = System.currentTimeMillis();
        while (zk.getState() != ZooKeeper.States.CONNECTEDREADONLY) {
            Thread.sleep(200L);
            Assert.assertTrue((String)"Can't connect to the server", (System.currentTimeMillis() - start < 30000L ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"ConnectedReadOnly event wasn't received", (states.get(2) == Watcher.Event.KeeperState.ConnectedReadOnly ? 1 : 0) != 0);
        zk.close();
    }

    @Test
    public void testSessionEstablishment() throws Exception {
        this.qu.shutdown(2);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        Assert.assertSame((String)"should be in r/o mode", (Object)ZooKeeper.States.CONNECTEDREADONLY, (Object)zk.getState());
        long fakeId = zk.getSessionId();
        watcher.reset();
        this.qu.start(2);
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.qu.getPeer((int)2).clientPort, CONNECTION_TIMEOUT));
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertFalse((String)"fake session and real session have same id", (zk.getSessionId() == fakeId ? 1 : 0) != 0);
        zk.close();
    }

    @Test
    public void testSeekForRwServer() throws Exception {
        String line;
        Layout layout = Logger.getRootLogger().getAppender("CONSOLE").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setImmediateFlush(true);
        appender.setThreshold((Priority)Level.INFO);
        Logger zlogger = Logger.getLogger((String)"org.apache.zookeeper");
        zlogger.addAppender((Appender)appender);
        try {
            this.qu.shutdown(2);
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            ZooKeeper zk = new ZooKeeper(this.qu.getConnString(), CONNECTION_TIMEOUT, (Watcher)watcher, true);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            this.qu.getPeer((int)1).peer.suspend();
            watcher.reset();
            this.qu.start(2);
            this.qu.start(3);
            ClientBase.waitForServerUp(this.qu.getConnString(), 2000L);
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            zk.create("/test", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.qu.getPeer((int)1).peer.resume();
        }
        finally {
            zlogger.removeAppender((Appender)appender);
        }
        os.close();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        Pattern p = Pattern.compile(".*Majority server found.*");
        boolean found = false;
        while ((line = r.readLine()) != null) {
            if (!p.matcher(line).matches()) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Majority server wasn't found while connected to r/o server", (boolean)found);
    }
}

