/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthTest
extends ClientBase {
    private AtomicInteger authFailed = new AtomicInteger(0);

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        try {
            File tmpDir = SaslAuthTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super\"\n       password=\"test\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        File tmpDir = ClientBase.createTmpDir();
        File saslConfFile = new File(tmpDir, "jaas.conf");
        FileWriter fwriter = new FileWriter(saslConfFile);
        fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super\"\n       password=\"test\";\n};\n");
        fwriter.close();
        System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    @Test
    public void testAuth() throws Exception {
        Thread.sleep(1000L);
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testValidSaslIds() throws Exception {
        TestableZooKeeper zk = this.createClient();
        Thread.sleep(1000L);
        ArrayList<String> validIds = new ArrayList<String>();
        validIds.add("user");
        validIds.add("service/host.name.com");
        validIds.add("user@KERB.REALM");
        validIds.add("service/host.name.com@KERB.REALM");
        int i = 0;
        for (String validId : validIds) {
            ArrayList<ACL> aclList = new ArrayList<ACL>();
            ACL acl = new ACL(0, new Id("sasl", validId));
            aclList.add(acl);
            zk.create("/valid" + i, null, aclList, CreateMode.PERSISTENT);
            ++i;
        }
    }

    @Test
    public void testInvalidSaslIds() throws Exception {
        TestableZooKeeper zk = this.createClient();
        Thread.sleep(1000L);
        ArrayList<String> invalidIds = new ArrayList<String>();
        invalidIds.add("user@KERB.REALM/server.com");
        invalidIds.add("user@KERB.REALM1@KERB.REALM2");
        int i = 0;
        for (String invalidId : invalidIds) {
            ArrayList<ACL> aclList = new ArrayList<ACL>();
            try {
                try {
                    ACL acl = new ACL(0, new Id("sasl", invalidId));
                    aclList.add(acl);
                    zk.create("/invalid" + i, null, aclList, CreateMode.PERSISTENT);
                    Assert.fail((String)"SASLAuthenticationProvider.isValid() failed to catch invalid Id.");
                }
                catch (KeeperException.InvalidACLException invalidACLException) {
                    ++i;
                    continue;
                }
            }
            catch (Throwable throwable) {
                ++i;
                throw throwable;
            }
            ++i;
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                SaslAuthTest.this.authFailed.incrementAndGet();
            } else {
                super.process(event);
            }
        }
    }
}

