/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class SledgeHammer
extends Thread
implements Watcher {
    ZooKeeper zk;
    int count;
    int readsPerWrite;

    public SledgeHammer(String hosts, int count, int readsPerWrite) throws IOException {
        this.zk = new ZooKeeper(hosts, 10000, (Watcher)this);
        this.count = count;
        this.readsPerWrite = readsPerWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Stat stat = new Stat();
            String path = this.zk.create("/hammers/hammer-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            byte[] tag = (String.valueOf(path) + " was here!").getBytes();
            SledgeHammer sledgeHammer = this;
            synchronized (sledgeHammer) {
                String startPath = "/hammers/start";
                System.out.println("Waiting for " + startPath);
                while (this.zk.exists(startPath, true) == null) {
                    this.wait();
                }
                System.out.println("Running");
            }
            int i = 0;
            while (i < this.count) {
                try {
                    System.out.print(String.valueOf(i) + "\r");
                    List childs = this.zk.getChildren("/hammers", false);
                    Collections.shuffle(childs);
                    for (String s : childs) {
                        if (!s.startsWith("hammer-")) continue;
                        s = "/hammers/" + s;
                        this.zk.setData(s, tag, -1);
                        int j = 0;
                        while (j < this.readsPerWrite) {
                            this.zk.getData(s, false, stat);
                            ++j;
                        }
                        break;
                    }
                }
                catch (KeeperException.ConnectionLossException childs) {
                }
                catch (KeeperException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            System.out.println();
            this.zk.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws NumberFormatException, IOException {
        if (args.length != 3) {
            System.err.println("USAGE: SledgeHammer zookeeper_server reps reads_per_rep");
            System.exit(3);
        }
        SledgeHammer h = new SledgeHammer(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]));
        h.start();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        SledgeHammer sledgeHammer = this;
        synchronized (sledgeHammer) {
            this.notifyAll();
        }
    }
}

