/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.provider;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import javax.sql.DataSource;
import org.eclipse.gemini.jpa.AnchorClassUtil;
import org.eclipse.gemini.jpa.FragmentUtil;
import org.eclipse.gemini.jpa.GeminiProperties;
import org.eclipse.gemini.jpa.GeminiServicesUtil;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.eclipse.gemini.jpa.PersistenceBundleExtender;
import org.eclipse.gemini.jpa.PlainDriverDataSource;
import org.eclipse.gemini.jpa.classloader.BundleProxyClassLoader;
import org.eclipse.gemini.jpa.classloader.CompositeClassLoader;
import org.eclipse.gemini.jpa.provider.GeminiOSGiInitializer;
import org.eclipse.gemini.jpa.provider.OSGiArchiveFactoryImpl;
import org.eclipse.gemini.jpa.provider.OSGiJpaProvider;
import org.eclipse.gemini.jpa.provider.PersistenceProvider;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.jpa.ArchiveFactory;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;

public class EclipseLinkOSGiProvider
implements BundleActivator,
OSGiJpaProvider,
javax.persistence.spi.PersistenceProvider {
    public static final String PROVIDER_CLASS_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    public static final int MAX_EVENT_COLLISION_TRIES = 3;
    BundleContext ctx;
    PersistenceBundleExtender extender;
    GeminiServicesUtil servicesUtil;
    AnchorClassUtil anchorUtil;
    javax.persistence.spi.PersistenceProvider eclipseLinkProvider;
    Map<String, PUnitInfo> pUnitsByName;
    private FileWriter eclipseLinkLog;

    public void start(BundleContext context) throws Exception {
        GeminiUtil.debug("EclipseLinkProvider starting...");
        this.ctx = context;
        this.pUnitsByName = Collections.synchronizedMap(new HashMap());
        this.extender = new PersistenceBundleExtender(this);
        this.anchorUtil = new AnchorClassUtil(GeminiProperties.generateAnchorClasses());
        this.servicesUtil = new GeminiServicesUtil(this, this.anchorUtil);
        this.openEclipseLinkLoggingFile();
        this.eclipseLinkProvider = new PersistenceProvider();
        PersistenceUnitProcessor.setArchiveFactory((ArchiveFactory)new OSGiArchiveFactoryImpl());
        this.servicesUtil.registerProviderService();
        this.extender.startListening();
        this.extender.lookForExistingBundles();
        GeminiUtil.debug("EclipseLinkProvider started");
    }

    public void stop(BundleContext context) throws Exception {
        GeminiUtil.debug("EclipseLinkProvider stopping...");
        this.extender.stopListening();
        this.servicesUtil.unregisterProviderService();
        ArrayList<PUnitInfo> pUnits = new ArrayList<PUnitInfo>();
        pUnits.addAll(this.pUnitsByName.values());
        this.unregisterPersistenceUnits(pUnits);
        this.pUnitsByName = null;
        Map<Bundle, List<PUnitInfo>> pUnitInfos = this.extender.clearAllPUnitInfos();
        for (Map.Entry<Bundle, List<PUnitInfo>> entry : pUnitInfos.entrySet()) {
            this.unassignPersistenceUnitsInBundle(entry.getKey(), (Collection<PUnitInfo>)entry.getValue());
        }
        this.closeEclipseLinkLoggingFile();
        GeminiUtil.debug("EclipseLinkProvider stopped");
    }

    @Override
    public String getProviderClassName() {
        return PROVIDER_CLASS_NAME;
    }

    @Override
    public javax.persistence.spi.PersistenceProvider getProviderInstance() {
        return this;
    }

    @Override
    public Bundle getBundle() {
        return this.ctx.getBundle();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.ctx;
    }

    @Override
    public void assignPersistenceUnitsInBundle(Bundle b, Collection<PUnitInfo> pUnits) {
        GeminiUtil.debug("EclipseLinkProvider assignPersistenceUnitsInBundle: ", (Object)b);
        if (GeminiProperties.generateFragments()) {
            new FragmentUtil(this.ctx.getBundle()).generateAndInstallFragment(b, pUnits, this.anchorUtil);
        }
        ClassLoader compositeLoader = this.compositeLoader(this.getBundleContext(), b);
        GeminiOSGiInitializer initializer = new GeminiOSGiInitializer();
        initializer.initializeFromBundle(this.getBundleContext(), b, compositeLoader, pUnits);
    }

    @Override
    public void registerPersistenceUnits(Collection<PUnitInfo> pUnits) {
        GeminiUtil.debug("EclipseLinkProvider registerPersistenceUnits: ", pUnits);
        if (pUnits == null) {
            return;
        }
        for (PUnitInfo info : pUnits) {
            String pUnitName = info.getUnitName();
            int attempts = 0;
            while (this.pUnitsByName.containsKey(pUnitName) && attempts < 3) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                ++attempts;
            }
            if (this.pUnitsByName.containsKey(pUnitName)) {
                GeminiUtil.warning("EclipseLinkProvider forcing unregister of persistence unit: " + info.getUnitName());
                ArrayList<PUnitInfo> units = new ArrayList<PUnitInfo>();
                units.add(info);
                this.unregisterPersistenceUnits(units);
            }
            this.pUnitsByName.put(pUnitName, info);
            this.servicesUtil.registerEMFServices(info);
        }
    }

    @Override
    public void unregisterPersistenceUnits(Collection<PUnitInfo> pUnits) {
        GeminiUtil.debug("EclipseLinkProvider unregisterPersistenceUnits: ", pUnits);
        if (pUnits == null) {
            return;
        }
        for (PUnitInfo info : pUnits) {
            this.servicesUtil.unregisterEMFServices(info);
            this.pUnitsByName.remove(info.getUnitName());
        }
    }

    @Override
    public void unassignPersistenceUnitsInBundle(Bundle b, Collection<PUnitInfo> pUnits) {
        GeminiUtil.debug("EclipseLinkProvider unassignPersistenceUnitsInBundle: ", (Object)b.getSymbolicName());
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map properties) {
        GeminiUtil.debug("EclipseLinkProvider createEMF invoked for p-unit: ", (Object)emName);
        GeminiUtil.debug("Properties map: ", (Object)properties);
        PUnitInfo pUnitInfo = this.pUnitsByName.get(emName);
        if (pUnitInfo == null) {
            GeminiUtil.fatalError("createEntityManagerFactory() called on provider, but provider has not registered the p-unit " + emName, null);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(properties);
        props.put("eclipselink.classloader", this.compositeLoader(pUnitInfo));
        props.put("javax.persistence.nonJtaDataSource", this.acquireDataSource(pUnitInfo, properties));
        props.put("eclipselink.persistencexml", this.fullDescriptorPath(pUnitInfo));
        props.put("org.eclipse.gemini.jpa.bundle", pUnitInfo.getBundle());
        EntityManagerFactory emf = this.eclipseLinkProvider.createEntityManagerFactory(emName, props);
        return emf;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        String pUnitName = info.getPersistenceUnitName();
        GeminiUtil.warning("Container JPA not currently supported for p-unit ", pUnitName);
        PUnitInfo pUnitInfo = this.pUnitsByName.get(pUnitName);
        if (pUnitInfo == null) {
            GeminiUtil.fatalError("createContainerEntityManagerFactory() called on provider, but provider has not registered the p-unit " + pUnitName, null);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(properties);
        props.put("eclipselink.classloader", this.compositeLoader(pUnitInfo));
        props.put("javax.persistence.nonJtaDataSource", this.acquireDataSource(pUnitInfo, properties));
        props.put("eclipselink.persistencexml", this.fullDescriptorPath(pUnitInfo));
        props.put("org.eclipse.gemini.jpa.bundle", pUnitInfo.getBundle());
        return this.eclipseLinkProvider.createContainerEntityManagerFactory(info, props);
    }

    public ProviderUtil getProviderUtil() {
        GeminiUtil.debug("EclipseLinkProvider getProviderUtil invoked");
        return this.eclipseLinkProvider.getProviderUtil();
    }

    protected ClassLoader compositeLoader(PUnitInfo pUnitInfo) {
        return this.compositeLoader(this.getBundleContext(), pUnitInfo.getBundle());
    }

    protected ClassLoader compositeLoader(BundleContext providerCtx, Bundle pUnitBundle) {
        BundleProxyClassLoader pUnitLoader = new BundleProxyClassLoader(pUnitBundle);
        GeminiUtil.debugClassLoader("PUnit bundle proxy loader created: ", pUnitLoader);
        BundleProxyClassLoader providerLoader = new BundleProxyClassLoader(providerCtx.getBundle());
        GeminiUtil.debugClassLoader("Provider bundle proxy loader created: ", providerLoader);
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        loaders.add(pUnitLoader);
        loaders.add(providerLoader);
        CompositeClassLoader compositeLoader = new CompositeClassLoader(loaders);
        GeminiUtil.debugClassLoader("Composite loader created: ", compositeLoader);
        return compositeLoader;
    }

    protected DataSource acquireDataSource(PUnitInfo pUnitInfo, Map<?, ?> properties) {
        ServiceReference dsfRef;
        Object ds = properties.get("javax.persistence.nonJtaDataSource");
        if (ds instanceof DataSource) {
            return (DataSource)ds;
        }
        if (ds instanceof String) {
            if (((String)ds).length() > 0) {
                return new DataSourceImpl((String)ds, null, null, null);
            }
            return null;
        }
        GeminiUtil.warning("invalid_datasource_property_value for p-unit ", pUnitInfo.getUnitName());
        Driver driver = null;
        String driverName = (String)properties.get(GeminiUtil.JPA_JDBC_DRIVER_PROPERTY);
        if (driverName == null && (driverName = pUnitInfo.getDriverClassName()) == null) {
            GeminiUtil.fatalError("No driver was specified", null);
        }
        if ((dsfRef = pUnitInfo.getDsfService()) != null && driverName.equals(pUnitInfo.getDriverClassName())) {
            GeminiUtil.debug("Using existing DSF service ref from punit ", (Object)pUnitInfo.getUnitName());
            DataSourceFactory dsf = (DataSourceFactory)this.getBundleContext().getService(dsfRef);
            try {
                driver = dsf.createDriver(null);
            }
            catch (SQLException sqlEx) {
                GeminiUtil.fatalError("Could not create data source for " + driverName, sqlEx);
            }
        }
        if (driver == null) {
            GeminiUtil.debug("Trying dynamic lookup of DSF for ", driverName, " for p-unit ", pUnitInfo.getUnitName());
            String filter = "(osgi.jdbc.driver.class=" + driverName + ")";
            ServiceReference[] dsfRefs = null;
            try {
                dsfRefs = pUnitInfo.getBundle().getBundleContext().getServiceReferences(DataSourceFactory.class.getName(), filter);
            }
            catch (InvalidSyntaxException isEx) {
                GeminiUtil.fatalError("Bad filter syntax (likely because of missing driver class name)", isEx);
            }
            if (dsfRefs != null) {
                DataSourceFactory dsf = (DataSourceFactory)this.getBundleContext().getService(dsfRefs[0]);
                try {
                    driver = dsf.createDriver(null);
                }
                catch (SQLException sqlEx) {
                    GeminiUtil.fatalError("Could not create data source for " + driverName, sqlEx);
                }
            }
        }
        if (driver == null) {
            GeminiUtil.debug("Trying to load driver ", driverName, " locally from p-unit bundle ", pUnitInfo.getUnitName());
            try {
                Class driverClass = pUnitInfo.getBundle().loadClass(driverName);
                driver = (Driver)driverClass.newInstance();
                GeminiUtil.debug("JDBC driver ", driverName, " loaded locally from p-unit bundle ", pUnitInfo.getUnitName());
            }
            catch (Exception ex) {
                GeminiUtil.fatalError("Could not create data source for " + driverName, ex);
            }
        }
        Properties props = this.getJdbcProperties(pUnitInfo, properties);
        return new PlainDriverDataSource(driver, props);
    }

    protected String fullDescriptorPath(PUnitInfo pUnitInfo) {
        return pUnitInfo.getDescriptorInfo().fullDescriptorPath();
    }

    protected Properties getJdbcProperties(PUnitInfo pUnitInfo, Map<?, ?> properties) {
        String pw;
        String user;
        Properties props = new Properties();
        GeminiUtil.debug("EclipseLinkProvider - getJDBCProperties");
        GeminiUtil.debug("  fromMap: ", properties);
        GeminiUtil.debug("  fromDescriptor: ", (Object)pUnitInfo);
        String url = (String)properties.get(GeminiUtil.JPA_JDBC_URL_PROPERTY);
        if (url == null) {
            url = pUnitInfo.getDriverUrl();
        }
        if (url != null) {
            props.put("url", url);
        }
        if ((user = (String)properties.get(GeminiUtil.JPA_JDBC_USER_PROPERTY)) == null) {
            user = pUnitInfo.getDriverUser();
        }
        if (user != null) {
            props.put("user", user);
        }
        if ((pw = (String)properties.get(GeminiUtil.JPA_JDBC_PASSWORD_PROPERTY)) == null) {
            pw = pUnitInfo.getDriverPassword();
        }
        if (pw != null) {
            props.put("password", pw);
        }
        GeminiUtil.debug("EclipseLinkProvider - getJDBCProperties - returning: ", (Object)props);
        return props;
    }

    public void openEclipseLinkLoggingFile() {
        String loggingFile = System.getProperty("eclipselink.logging.file");
        try {
            if (loggingFile != null) {
                this.eclipseLinkLog = new FileWriter(loggingFile);
                AbstractSessionLog.getLog().setWriter((Writer)this.eclipseLinkLog);
            }
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", loggingFile, (Object)e);
        }
    }

    public void closeEclipseLinkLoggingFile() {
        AbstractSessionLog.setLog((SessionLog)new DefaultSessionLog());
        try {
            if (this.eclipseLinkLog != null) {
                this.eclipseLinkLog.close();
            }
        }
        catch (IOException iOException) {}
    }
}

