/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class AdminUiUtil {
    private static final int DEFAULT_SPACE = 10;

    public static GridData createFillData() {
        return new GridData(4, 4, true, true);
    }

    public static FillLayout createFillLayout(boolean setMargin) {
        FillLayout result = new FillLayout();
        if (setMargin) {
            result.marginWidth = 10;
            result.marginHeight = 10;
        }
        return result;
    }

    public static GridLayout createGridLayout(int numColumns, boolean makeColsEqualWidth, boolean setTopMargin, boolean setVertSpacing) {
        GridLayout result = new GridLayout(numColumns, makeColsEqualWidth);
        result.marginWidth = 10;
        result.marginHeight = 0;
        result.marginBottom = 10;
        result.horizontalSpacing = 10;
        if (setTopMargin) {
            result.marginTop = 10;
        }
        if (setVertSpacing) {
            result.verticalSpacing = 10;
        }
        return result;
    }

    public static GridLayout createGridLayoutWithoutMargin(int numColumns, boolean makeColsEqualWidth) {
        GridLayout result = new GridLayout(numColumns, makeColsEqualWidth);
        result.marginHeight = 0;
        result.marginWidth = 0;
        return result;
    }

    public static void createHeading(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setData("org.eclipse.rwt.themeVariant", (Object)"heading");
        GridData labelLayoutData = new GridData();
        labelLayoutData.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)labelLayoutData);
    }

    public static GridData createHorzFillData() {
        return new GridData(4, 128, true, false);
    }

    public static GridData createHorzFillData(int horizontalSpan) {
        GridData gd = AdminUiUtil.createHorzFillData();
        gd.horizontalSpan = horizontalSpan;
        return gd;
    }

    public static GridLayout createMainLayout(int numColumns) {
        GridLayout result = new GridLayout(numColumns, true);
        result.marginWidth = 0;
        result.marginHeight = 0;
        result.marginTop = 0;
        result.verticalSpacing = 0;
        result.horizontalSpacing = 60;
        return result;
    }

    public static GridLayout createMainLayout(int numColumns, int horzSpacing) {
        GridLayout result = new GridLayout(numColumns, true);
        result.marginWidth = 0;
        result.marginHeight = 0;
        result.marginTop = 0;
        result.verticalSpacing = 0;
        result.horizontalSpacing = horzSpacing;
        return result;
    }

    public static RowLayout createRowLayout(int type, boolean setMargin) {
        RowLayout result = new RowLayout(type);
        result.marginTop = 0;
        result.marginLeft = 0;
        result.marginHeight = 0;
        if (setMargin) {
            result.marginBottom = 10;
            result.marginWidth = 10;
        } else {
            result.marginBottom = 0;
            result.marginWidth = 0;
        }
        return result;
    }

    private AdminUiUtil() {
    }
}

