/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.tests.internal;

import java.util.UUID;
import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.preferences.IRuntimeContextPreferences;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesBlackBoxTests {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesBlackBoxTests.class);
    private IServiceProxy<IRuntimeContextRegistry> contextRegistryProxy;
    private ContextRegistryImpl contextRegistry;

    private GyrexContextHandle assertContextDefined(IPath path) {
        ContextDefinition definition = new ContextDefinition(path);
        definition.setName("Test Context");
        this.contextRegistry.saveDefinition(definition);
        Assert.assertNotNull((String)"context definition must exists after create", (Object)this.contextRegistry.get(path));
        GyrexContextHandle context = this.contextRegistry.get(path);
        Assert.assertNotNull((String)"context handle must exists", (Object)context);
        Assert.assertNotNull((String)"context handle must map to real context", (Object)context.get());
        return context;
    }

    @Before
    public void setUp() throws Exception {
        this.contextRegistry = ContextActivator.getInstance().getContextRegistryImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.contextRegistry = null;
    }

    @Test
    public void testPreferencesScenario001() throws Exception {
        GyrexContextHandle rootContext = this.contextRegistry.get((IPath)Path.ROOT);
        Assert.assertNotNull((String)("nmissing context " + Path.ROOT), (Object)rootContext);
        IRuntimeContextPreferences rootPrefs = rootContext.getPreferences();
        Assert.assertNotNull((String)("no preferences for context " + rootContext), (Object)rootPrefs);
        GyrexContextHandle parentContext = this.assertContextDefined((IPath)new Path("/parent"));
        IRuntimeContextPreferences parentPrefs = parentContext.getPreferences();
        GyrexContextHandle childContext = this.assertContextDefined((IPath)new Path("/parent/child/child"));
        IRuntimeContextPreferences childPrefs = childContext.getPreferences();
        String key = "testStringConf" + UUID.randomUUID().toString();
        String value = "avalue" + System.currentTimeMillis();
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode("org.eclipse.gyrex.context.tests");
        LOG.trace("Setting default for key {} in node {}", (Object)key, (Object)defaultNode.node("org.eclipse.gyrex.context.tests").absolutePath());
        defaultNode.put(key, value);
        Assert.assertEquals((String)"root context default preference lookup failed", (String)value, (String)rootPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"parent context default preference lookup failed", (String)value, (String)parentPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"child context default preference lookup failed", (String)value, (String)childPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        rootPrefs.put("org.eclipse.gyrex.context.tests", key, "root-value", false);
        rootPrefs.flush("org.eclipse.gyrex.context.tests");
        rootPrefs.sync("org.eclipse.gyrex.context.tests");
        Assert.assertEquals((String)"root context preference storing failed", (String)"root-value", (String)rootPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"parent context stored preference lookup failed", (String)"root-value", (String)parentPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"child context stored preference lookup failed", (String)"root-value", (String)childPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        parentPrefs.put("org.eclipse.gyrex.context.tests", key, "parent-value", false);
        parentPrefs.flush("org.eclipse.gyrex.context.tests");
        parentPrefs.sync("org.eclipse.gyrex.context.tests");
        Assert.assertEquals((String)"root context stored preference failed", (String)"root-value", (String)rootPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"parent context stored preference lookup failed", (String)"parent-value", (String)parentPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"child context stored preference lookup failed", (String)"parent-value", (String)childPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        childPrefs.put("org.eclipse.gyrex.context.tests", key, "child-value", false);
        childPrefs.flush("org.eclipse.gyrex.context.tests");
        childPrefs.sync("org.eclipse.gyrex.context.tests");
        Assert.assertEquals((String)"root context stored preference failed", (String)"root-value", (String)rootPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"parent context stored preference lookup failed", (String)"parent-value", (String)parentPrefs.get("org.eclipse.gyrex.context.tests", key, null));
        Assert.assertEquals((String)"child context stored preference lookup failed", (String)"child-value", (String)childPrefs.get("org.eclipse.gyrex.context.tests", key, null));
    }
}

