/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.admin;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.internal.admin.X500PrincipalHelper;

public class CertificateDefinition
implements ICertificate {
    static final DateFormat TO_STRING_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String id;
    private byte[] keystoreBytes;
    private char[] keyPassword;
    private char[] keystorePassword;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInfo() {
        try {
            StrBuilder certInfo = new StrBuilder();
            KeyStore ks = this.getKeyStore();
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!certInfo.isEmpty()) {
                    certInfo.append(", ");
                }
                if (ks.isKeyEntry(alias)) {
                    Certificate[] chain = ks.getCertificateChain(alias);
                    if (chain == null) {
                        Certificate certificate = ks.getCertificate(alias);
                        chain = new Certificate[]{certificate};
                    }
                    int i = 0;
                    while (i < chain.length) {
                        Certificate certificate;
                        if (i > 0) {
                            certInfo.append(" ");
                        }
                        if ((certificate = chain[i]) instanceof X509Certificate) {
                            X509Certificate x509 = (X509Certificate)certificate;
                            X500PrincipalHelper helper = new X500PrincipalHelper(x509.getSubjectX500Principal());
                            certInfo.append(helper.getCN());
                            certInfo.append(", valid till ").append(TO_STRING_FORMAT.format(x509.getNotAfter()));
                        } else {
                            certInfo.append("INVALID");
                        }
                        ++i;
                    }
                    continue;
                }
                certInfo.append("IGNORED");
            }
            return StringUtils.trim((String)certInfo.toString());
        }
        catch (Exception e) {
            return ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
    }

    @Override
    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public KeyStore getKeyStore() {
        if (this.keystoreBytes == null) {
            throw new IllegalStateException("keystore not available");
        }
        try {
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(new ByteArrayInputStream(this.keystoreBytes), this.keystorePassword);
            return keystore;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading keystore. " + e.getMessage(), e);
        }
    }

    public void setId(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id");
        }
        this.id = id;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setKeystoreBytes(byte[] keystoreBytes) {
        this.keystoreBytes = keystoreBytes;
    }

    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("id", (Object)this.id);
        builder.append("keystoreBytes", (Object)(this.keystoreBytes != null ? "(available)" : null));
        builder.append("keystorePassword", (Object)(this.keystorePassword != null ? "(set)" : null));
        builder.append("keyPassword", (Object)(this.keyPassword != null ? "(set)" : null));
        return builder.toString();
    }
}

