/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.model.common.provider;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.model.common.IModelManager;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public abstract class BaseModelManager<T extends Repository>
extends PlatformObject
implements IModelManager {
    private final IRuntimeContext context;
    private final T repository;
    private volatile boolean closed;
    private final MetricSet metrics;
    private volatile ServiceRegistration metricsRegistration;

    protected BaseModelManager(IRuntimeContext context, T repository, MetricSet metrics) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("repository must not be null");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("metrics must not be null");
        }
        this.context = context;
        this.repository = repository;
        this.metrics = metrics;
        this.registerMetrics();
    }

    public final void close() {
        this.closed = true;
        try {
            this.doClose();
        }
        finally {
            this.metricsRegistration.unregister();
            this.metricsRegistration = null;
        }
    }

    protected void doClose() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        Object contextAdapter = this.getContext().getAdapter(adapter);
        if (contextAdapter != null) {
            return contextAdapter;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public final IRuntimeContext getContext() {
        return this.context;
    }

    protected final MetricSet getMetrics() {
        return this.metrics;
    }

    protected final T getRepository() {
        return this.repository;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    private void registerMetrics() throws IllegalArgumentException, IllegalStateException {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext bundleContext2 = bundleContext = bundle != null ? bundle.getBundleContext() : null;
        if (bundleContext == null) {
            throw new IllegalStateException("Unable to determin bundle context for class '" + this.getClass().getName() + "'. Please ensure that this class was loaded by a bundle which is either STARTING, ACTIVE or STOPPING.");
        }
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", this.getClass().getName());
        ((Dictionary)properties).put("service.description", "Metrics for model manager implementation '" + this.getClass().getName() + "'.");
        ((Dictionary)properties).put("gyrex.repository.id", this.getRepository().getRepositoryId());
        if (StringUtils.isNotBlank((String)this.getRepository().getDescription())) {
            ((Dictionary)properties).put("gyrex.repository.description", this.getRepository().getDescription());
        }
        ((Dictionary)properties).put("gyrex.context.path", this.getContext().getContextPath().toString());
        this.metricsRegistration = bundleContext.registerService(MetricSet.class.getName(), (Object)this.metrics, properties);
    }
}

