/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DateConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExpressionBuilderVisitor
implements EclipseLinkExpressionVisitor {
    private ChildrenExpressionVisitor childrenExpressionVisitor;
    private EmptyCollectionComparisonExpressionVisitor emptyCollectionComparisonExpressionVisitor;
    private InExpressionBuilder inExpressionBuilder;
    private JoinVisitor joinVisitor;
    private Comparator<Class<?>> numericTypeComparator;
    private PathResolver pathResolver;
    private final JPQLQueryContext queryContext;
    private org.eclipse.persistence.expressions.Expression queryExpression;
    private final Class<?>[] type;
    private boolean typeExpression;
    private WhenClauseExpressionVisitor whenClauseExpressionVisitor;

    ExpressionBuilderVisitor(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
        this.type = new Class[1];
    }

    private void appendJoinVariables(Expression expression, ReportQuery subquery) {
        this.queryExpression = null;
        for (String variableName : this.collectOuterIdentificationVariables()) {
            org.eclipse.persistence.expressions.Expression innerExpression = this.queryContext.getQueryExpression(variableName);
            org.eclipse.persistence.expressions.Expression outerExpression = this.queryContext.getParent().getQueryExpressionImp(variableName);
            org.eclipse.persistence.expressions.Expression equalExpression = innerExpression.equal(outerExpression);
            this.queryExpression = this.queryExpression == null ? equalExpression : this.queryExpression.and(equalExpression);
        }
        if (this.queryExpression != null) {
            org.eclipse.persistence.expressions.Expression whereClause = subquery.getSelectionCriteria();
            whereClause = whereClause != null ? whereClause.and(this.queryExpression) : this.queryExpression;
            subquery.setSelectionCriteria(whereClause);
        }
    }

    org.eclipse.persistence.expressions.Expression buildExpression(Expression expression, Class<?>[] type) {
        Class<?> oldType = this.type[0];
        boolean oldTypeExpression = this.typeExpression;
        org.eclipse.persistence.expressions.Expression oldQueryExpression = this.queryExpression;
        try {
            this.type[0] = null;
            this.typeExpression = false;
            this.queryExpression = null;
            expression.accept((ExpressionVisitor)this);
            type[0] = this.type[0];
            org.eclipse.persistence.expressions.Expression expression2 = this.queryExpression;
            return expression2;
        }
        finally {
            this.type[0] = oldType;
            this.typeExpression = oldTypeExpression;
            this.queryExpression = oldQueryExpression;
        }
    }

    org.eclipse.persistence.expressions.Expression buildGroupByExpression(CollectionValuedPathExpression expression) {
        PathResolver resolver = this.pathResolver();
        try {
            resolver.length = expression.pathSize() - 1;
            resolver.nullAllowed = false;
            resolver.localExpression = null;
            resolver.checkMappingType = false;
            expression.accept((ExpressionVisitor)resolver);
            org.eclipse.persistence.expressions.Expression expression2 = resolver.localExpression;
            return expression2;
        }
        finally {
            resolver.length = -1;
            resolver.nullAllowed = false;
            resolver.checkMappingType = false;
            resolver.localExpression = null;
            resolver.descriptor = null;
            this.type[0] = null;
            this.queryExpression = null;
            this.typeExpression = false;
        }
    }

    org.eclipse.persistence.expressions.Expression buildModifiedPathExpression(StateFieldPathExpression expression) {
        PathResolver resolver = this.pathResolver();
        try {
            resolver.length = expression.pathSize();
            resolver.nullAllowed = false;
            resolver.localExpression = null;
            resolver.checkMappingType = true;
            expression.accept((ExpressionVisitor)resolver);
            org.eclipse.persistence.expressions.Expression expression2 = resolver.localExpression;
            return expression2;
        }
        finally {
            resolver.length = -1;
            resolver.nullAllowed = false;
            resolver.checkMappingType = false;
            resolver.localExpression = null;
            resolver.descriptor = null;
            this.type[0] = null;
            this.queryExpression = null;
            this.typeExpression = false;
        }
    }

    private ReportQuery buildSubquery(SimpleSelectStatement expression) {
        ReportQuery subquery = new ReportQuery();
        this.queryContext.newSubQueryContext((Expression)expression, subquery);
        try {
            this.queryContext.populateReportQuery((AbstractSelectStatement)expression, subquery, this.type);
            this.appendJoinVariables((Expression)expression, subquery);
            ReportQuery reportQuery = subquery;
            return reportQuery;
        }
        finally {
            this.queryContext.disposeSubqueryContext();
        }
    }

    private List<Expression> children(Expression expression) {
        ChildrenExpressionVisitor visitor = this.childrenExpressionVisitor();
        try {
            expression.accept((ExpressionVisitor)visitor);
            LinkedList<Expression> linkedList = new LinkedList<Expression>(visitor.expressions);
            return linkedList;
        }
        finally {
            visitor.expressions.clear();
        }
    }

    private ChildrenExpressionVisitor childrenExpressionVisitor() {
        if (this.childrenExpressionVisitor == null) {
            this.childrenExpressionVisitor = new ChildrenExpressionVisitor();
        }
        return this.childrenExpressionVisitor;
    }

    private Set<String> collectOuterIdentificationVariables() {
        HashSet<String> variableNames = new HashSet<String>(this.queryContext.getUsedIdentificationVariables());
        for (Declaration declaration : this.queryContext.getDeclarations()) {
            variableNames.remove(declaration.getVariableName());
        }
        return variableNames;
    }

    private EmptyCollectionComparisonExpressionVisitor emptyCollectionComparisonExpressionVisitor() {
        if (this.emptyCollectionComparisonExpressionVisitor == null) {
            this.emptyCollectionComparisonExpressionVisitor = new EmptyCollectionComparisonExpressionVisitor();
        }
        return this.emptyCollectionComparisonExpressionVisitor;
    }

    private InExpressionBuilder inExpressionBuilder() {
        if (this.inExpressionBuilder == null) {
            this.inExpressionBuilder = new InExpressionBuilder();
        }
        return this.inExpressionBuilder;
    }

    private JoinVisitor joinVisitor() {
        if (this.joinVisitor == null) {
            this.joinVisitor = new JoinVisitor();
        }
        return this.joinVisitor;
    }

    private Comparator<Class<?>> numericTypeComparator() {
        if (this.numericTypeComparator == null) {
            this.numericTypeComparator = new NumericTypeComparator();
        }
        return this.numericTypeComparator;
    }

    private PathResolver pathResolver() {
        if (this.pathResolver == null) {
            this.pathResolver = new PathResolver();
        }
        return this.pathResolver;
    }

    public void visit(AbsExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = ExpressionMath.abs((org.eclipse.persistence.expressions.Expression)this.queryExpression);
    }

    public void visit(AbstractSchemaName expression) {
        ClassDescriptor descriptor = this.queryContext.getDescriptor(expression.getText());
        this.type[0] = descriptor.getJavaClass();
        this.queryExpression = new ExpressionBuilder(this.type[0]);
    }

    public void visit(AdditionExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.add((org.eclipse.persistence.expressions.Expression)leftExpression, (Object)rightExpression);
        Collections.sort(types, this.numericTypeComparator());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(AllOrAnyExpression expression) {
        ReportQuery subquery = this.buildSubquery((SimpleSelectStatement)expression.getExpression());
        String identifier = expression.getIdentifier();
        this.queryExpression = this.queryContext.getBaseExpression();
        if (identifier == "ALL") {
            this.queryExpression = this.queryExpression.all(subquery);
        } else if (identifier == "SOME") {
            this.queryExpression = this.queryExpression.some(subquery);
        } else if (identifier == "ANY") {
            this.queryExpression = this.queryExpression.any(subquery);
        }
    }

    public void visit(AndExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        this.queryExpression = leftExpression.and(rightExpression);
        this.type[0] = Boolean.class;
    }

    public void visit(ArithmeticFactor expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression arithmeticFactor = this.queryExpression;
        this.queryExpression = new ConstantExpression((Object)0, (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder());
        this.queryExpression = ExpressionMath.subtract((org.eclipse.persistence.expressions.Expression)this.queryExpression, (Object)arithmeticFactor);
    }

    public void visit(AvgFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.average();
        this.type[0] = Double.class;
    }

    public void visit(BadExpression expression) {
    }

    public void visit(BetweenExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression resultExpression = this.queryExpression;
        expression.getLowerBoundExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression lowerBoundExpression = this.queryExpression;
        expression.getUpperBoundExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression upperBoundExpression = this.queryExpression;
        this.queryExpression = expression.hasNot() ? resultExpression.notBetween(lowerBoundExpression, upperBoundExpression) : resultExpression.between(lowerBoundExpression, upperBoundExpression);
        this.type[0] = Boolean.class;
    }

    public void visit(CaseExpression expression) {
        org.eclipse.persistence.expressions.Expression caseOperandExpression = null;
        if (expression.hasCaseOperand()) {
            expression.getCaseOperand().accept((ExpressionVisitor)this);
            caseOperandExpression = this.queryExpression;
        }
        WhenClauseExpressionVisitor visitor = this.whenClauseExpressionVisitor();
        try {
            expression.getWhenClauses().accept((ExpressionVisitor)visitor);
            expression.getElseExpression().accept((ExpressionVisitor)this);
            org.eclipse.persistence.expressions.Expression elseExpression = this.queryExpression;
            visitor.types.add(this.type[0]);
            if (caseOperandExpression != null) {
                this.queryExpression = caseOperandExpression.caseStatement(visitor.whenClauses, (Object)elseExpression);
            } else {
                this.queryExpression = this.queryContext.getBaseExpression();
                this.queryExpression = this.queryExpression.caseStatement(visitor.whenClauses, (Object)elseExpression);
            }
            this.type[0] = this.queryContext.typeResolver().compareCollectionEquivalentTypes(visitor.types);
        }
        finally {
            visitor.dispose();
        }
    }

    public void visit(CoalesceExpression expression) {
        ArrayList<org.eclipse.persistence.expressions.Expression> expressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
        LinkedList types = new LinkedList();
        for (Expression child : expression.getExpression().children()) {
            child.accept((ExpressionVisitor)this);
            expressions.add(this.queryExpression);
            types.add(this.type[0]);
        }
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.coalesce(expressions);
        this.type[0] = this.queryContext.typeResolver().compareCollectionEquivalentTypes(types);
    }

    public void visit(CollectionExpression expression) {
    }

    public void visit(CollectionMemberDeclaration expression) {
        expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
    }

    public void visit(CollectionMemberExpression expression) {
        expression.getEntityExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression entityExpression = this.queryExpression;
        if (expression.hasNot()) {
            CollectionValuedPathExpression pathExpression = (CollectionValuedPathExpression)expression.getCollectionValuedPathExpression();
            String variableName = this.queryContext.literal(expression.getCollectionValuedPathExpression(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
            org.eclipse.persistence.expressions.Expression parentExpression = this.queryContext.getQueryExpression(variableName);
            variableName = pathExpression.getPath(pathExpression.pathSize() - 1);
            this.queryExpression = new ExpressionBuilder().equal(entityExpression);
            this.queryExpression = parentExpression.noneOf(variableName, this.queryExpression);
        } else {
            expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
            this.queryExpression = this.queryExpression.equal(entityExpression);
        }
    }

    public void visit(CollectionValuedPathExpression expression) {
        this.visitPathExpression((AbstractPathExpression)expression, false);
    }

    public void visit(ComparisonExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        this.typeExpression = false;
        String comparaison = expression.getComparisonOperator();
        if (comparaison == "=") {
            this.queryExpression = leftExpression.equal(rightExpression);
        } else if (comparaison == "<>") {
            this.queryExpression = leftExpression.notEqual(rightExpression);
        } else if (comparaison == "<") {
            this.queryExpression = leftExpression.lessThan(rightExpression);
        } else if (comparaison == "<=") {
            this.queryExpression = leftExpression.lessThanEqual(rightExpression);
        } else if (comparaison == ">") {
            this.queryExpression = leftExpression.greaterThan(rightExpression);
        } else if (comparaison == ">=") {
            this.queryExpression = leftExpression.greaterThanEqual(rightExpression);
        }
        this.type[0] = Boolean.class;
    }

    public void visit(ConcatExpression expression) {
        List<Expression> expressions = this.children(expression.getExpression());
        org.eclipse.persistence.expressions.Expression newExpression = null;
        for (Expression child : expressions) {
            child.accept((ExpressionVisitor)this);
            newExpression = newExpression == null ? this.queryExpression : newExpression.concat((Object)this.queryExpression);
        }
        this.queryExpression = newExpression;
        this.type[0] = Boolean.class;
    }

    public void visit(ConstructorExpression expression) {
    }

    public void visit(CountFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.count();
        this.type[0] = Long.class;
    }

    public void visit(DateTime expression) {
        if (expression.isJDBCDate()) {
            this.queryExpression = this.queryContext.getBaseExpression();
            this.queryExpression = new DateConstantExpression((Object)expression.getText(), this.queryExpression);
            String text = expression.getText();
            this.type[0] = text.startsWith("{d") ? Date.class : (text.startsWith("{ts") ? Timestamp.class : (text.startsWith("{t") ? Time.class : Object.class));
        } else {
            this.queryExpression = this.queryContext.getBaseExpression();
            if (expression.isCurrentDate()) {
                this.queryExpression = this.queryExpression.currentDateDate();
                this.type[0] = Date.class;
            } else if (expression.isCurrentTime()) {
                this.queryExpression = this.queryExpression.currentTime();
                this.type[0] = Time.class;
            } else {
                this.queryExpression = this.queryExpression.currentTimeStamp();
                this.type[0] = Timestamp.class;
            }
        }
    }

    public void visit(DeleteClause expression) {
    }

    public void visit(DeleteStatement expression) {
    }

    public void visit(DivisionExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.divide((org.eclipse.persistence.expressions.Expression)leftExpression, (Object)rightExpression);
        Collections.sort(types, this.numericTypeComparator());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(EmptyCollectionComparisonExpression expression) {
        String name = this.queryContext.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        expression.getExpression().accept((ExpressionVisitor)this.emptyCollectionComparisonExpressionVisitor());
        this.queryExpression = expression.hasNot() ? this.queryExpression.notEmpty(name) : this.queryExpression.isEmpty(name);
        this.type[0] = Boolean.class;
    }

    public void visit(EntityTypeLiteral expression) {
        ClassDescriptor descriptor = this.queryContext.getDescriptor(expression.getEntityTypeName());
        this.type[0] = descriptor.getJavaClass();
        this.queryExpression = new ConstantExpression(this.type[0], this.queryContext.getBaseExpression());
    }

    public void visit(EntryExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        MapEntryExpression entryExpression = new MapEntryExpression(this.queryExpression);
        entryExpression.returnMapEntry();
        this.queryExpression = entryExpression;
        this.type[0] = Map.Entry.class;
    }

    public void visit(ExistsExpression expression) {
        ReportQuery subquery = this.buildSubquery((SimpleSelectStatement)expression.getExpression());
        for (ReportItem item : subquery.getItems()) {
            org.eclipse.persistence.expressions.Expression expr = item.getAttributeExpression();
            subquery.addNonFetchJoinedAttribute(expr);
        }
        subquery.clearItems();
        ConstantExpression one = new ConstantExpression((Object)1, (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder());
        subquery.addItem("one", (org.eclipse.persistence.expressions.Expression)one);
        subquery.dontUseDistinct();
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = expression.hasNot() ? this.queryExpression.notExists(subquery) : this.queryExpression.exists(subquery);
        this.type[0] = Boolean.class;
    }

    public void visit(FromClause expression) {
    }

    public void visit(FuncExpression expression) {
        List<Expression> expressions = this.children(expression.getExpression());
        String functionName = expression.getUnquotedFunctionName();
        if (expressions.isEmpty()) {
            this.queryExpression = this.queryContext.getBaseExpression();
            this.queryExpression = this.queryExpression.getFunction(functionName);
        } else {
            ArrayList<org.eclipse.persistence.expressions.Expression> queryExpressions = new ArrayList<org.eclipse.persistence.expressions.Expression>(expressions.size());
            for (Expression child : expressions) {
                child.accept((ExpressionVisitor)this);
                queryExpressions.add(this.queryExpression);
            }
            this.queryExpression = (org.eclipse.persistence.expressions.Expression)queryExpressions.remove(0);
            this.queryExpression = this.queryExpression.getFunctionWithArguments(functionName, queryExpressions);
        }
        this.type[0] = Object.class;
    }

    public void visit(GroupByClause expression) {
    }

    public void visit(HavingClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    public void visit(IdentificationVariable expression) {
        StateFieldPathExpression stateFieldPathExpression;
        if (expression.isVirtual() && (stateFieldPathExpression = expression.getStateFieldPathExpression()) != null) {
            stateFieldPathExpression.accept((ExpressionVisitor)this);
            return;
        }
        if (this.typeExpression) {
            this.typeExpression = false;
            ClassDescriptor descriptor = this.queryContext.getDescriptor(expression.getText());
            this.type[0] = descriptor.getJavaClass();
            this.queryExpression = new ConstantExpression(this.type[0], this.queryContext.getBaseExpression());
        } else {
            String variableName = expression.getVariableName();
            if (this.queryContext.isResultVariable(variableName)) {
                this.queryExpression = this.queryContext.getQueryExpression(variableName);
            } else {
                Declaration declaration;
                ClassDescriptor descriptor;
                if (!expression.isVirtual() && (descriptor = this.queryContext.getDescriptor(expression.getText())) != null) {
                    this.type[0] = descriptor.getJavaClass();
                    this.queryExpression = new ConstantExpression(this.type[0], this.queryContext.getBaseExpression());
                    return;
                }
                this.queryExpression = this.queryContext.findQueryExpression(variableName);
                if (this.queryExpression == null) {
                    declaration = this.queryContext.findDeclaration(variableName);
                    if (declaration != null) {
                        declaration.getBaseExpression().accept((ExpressionVisitor)this);
                        this.queryContext.addUsedIdentificationVariable(variableName);
                        this.queryContext.addQueryExpression(variableName, this.queryExpression);
                    }
                } else {
                    declaration = this.queryContext.findDeclaration(variableName);
                    if (declaration.isRange()) {
                        this.type[0] = declaration.getDescriptor().getJavaClass();
                    }
                }
            }
        }
    }

    public void visit(IdentificationVariableDeclaration expression) {
    }

    public void visit(IndexExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.index();
        this.type[0] = Integer.class;
    }

    public void visit(InExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression stateFieldPathExpression = this.queryExpression;
        this.visitInExpression(expression, stateFieldPathExpression);
        this.type[0] = Boolean.class;
    }

    public void visit(InputParameter expression) {
        String parameterName = expression.getParameter();
        Class<?> type = this.queryContext.getParameterType(expression);
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.getParameter(parameterName.substring(1), type);
        this.queryContext.addInputParameter(parameterName, type);
    }

    public void visit(Join expression) {
        expression.accept((ExpressionVisitor)this.joinVisitor());
    }

    public void visit(JoinFetch expression) {
        expression.accept((ExpressionVisitor)this.joinVisitor());
    }

    public void visit(JPQLExpression expression) {
    }

    public void visit(KeyExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = new MapEntryExpression(this.queryExpression);
    }

    public void visit(KeywordExpression expression) {
        Boolean value;
        String keyword = expression.getText();
        if (keyword == "NULL") {
            value = null;
            this.type[0] = Object.class;
        } else if (keyword == "TRUE") {
            value = Boolean.TRUE;
            this.type[0] = Boolean.class;
        } else {
            value = Boolean.FALSE;
            this.type[0] = Boolean.class;
        }
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = new ConstantExpression((Object)value, this.queryExpression);
    }

    public void visit(LengthExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.length();
        this.type[0] = Integer.class;
    }

    public void visit(LikeExpression expression) {
        expression.getStringExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression firstExpression = this.queryExpression;
        expression.getPatternValue().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression patternValue = this.queryExpression;
        if (expression.hasEscapeCharacter()) {
            expression.getEscapeCharacter().accept((ExpressionVisitor)this);
            this.queryExpression = firstExpression.like(patternValue, this.queryExpression);
        } else {
            this.queryExpression = firstExpression.like(patternValue);
        }
        if (expression.hasNot()) {
            this.queryExpression = this.queryExpression.not();
        }
        this.type[0] = Boolean.class;
    }

    public void visit(LocateExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression findExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression findInExpression = this.queryExpression;
        expression.getThirdExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression startPositionExpression = this.queryExpression;
        this.queryExpression = startPositionExpression != null ? findInExpression.locate((Object)findExpression, (Object)startPositionExpression) : findInExpression.locate((Object)findExpression);
        this.type[0] = Integer.class;
    }

    public void visit(LowerExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.toLowerCase();
        this.type[0] = String.class;
    }

    public void visit(MaxFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.maximum();
    }

    public void visit(MinFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.minimum();
    }

    public void visit(ModExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        this.queryExpression = ExpressionMath.mod((org.eclipse.persistence.expressions.Expression)leftExpression, (Object)rightExpression);
        this.type[0] = Integer.class;
    }

    public void visit(MultiplicationExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.multiply((org.eclipse.persistence.expressions.Expression)leftExpression, (Object)rightExpression);
        Collections.sort(types, this.numericTypeComparator());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(NotExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.not();
        this.type[0] = Boolean.class;
    }

    public void visit(NullComparisonExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = expression.hasNot() ? this.queryExpression.notNull() : this.queryExpression.isNull();
        this.type[0] = Boolean.class;
    }

    public void visit(NullExpression expression) {
        this.queryExpression = null;
        this.type[0] = null;
    }

    public void visit(NullIfExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression firstExpression = this.queryExpression;
        Class<?> actualType = this.type[0];
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression secondExpression = this.queryExpression;
        this.queryExpression = firstExpression.nullIf((Object)secondExpression);
        this.type[0] = actualType;
    }

    public void visit(NumericLiteral expression) {
        this.type[0] = this.queryContext.getType((Expression)expression);
        Number number = (Number)this.queryContext.newInstance(this.type[0], String.class, expression.getText());
        this.queryExpression = new ConstantExpression((Object)number, this.queryContext.getBaseExpression());
    }

    public void visit(ObjectExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(OrderByClause expression) {
    }

    public void visit(OrderByItem expression) {
    }

    public void visit(OrExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        this.queryExpression = leftExpression.or(rightExpression);
        this.type[0] = Boolean.class;
    }

    public void visit(RangeVariableDeclaration expression) {
        expression.getAbstractSchemaName().accept((ExpressionVisitor)this);
    }

    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getResultVariable();
        String variableName = identificationVariable.getVariableName();
        this.queryContext.addQueryExpression(variableName, this.queryExpression);
    }

    public void visit(SelectClause expression) {
    }

    public void visit(SelectStatement expression) {
    }

    public void visit(SimpleFromClause expression) {
    }

    public void visit(SimpleSelectClause expression) {
    }

    public void visit(SimpleSelectStatement expression) {
        ReportQuery subquery = this.buildSubquery(expression);
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = this.queryExpression.subQuery(subquery);
    }

    public void visit(SizeExpression expression) {
        CollectionValuedPathExpression pathExpression = (CollectionValuedPathExpression)expression.getExpression();
        pathExpression.accept((ExpressionVisitor)this);
        String name = pathExpression.getPath(pathExpression.pathSize() - 1);
        this.queryExpression = this.queryExpression.size(name);
        this.type[0] = Integer.class;
    }

    public void visit(SqrtExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = ExpressionMath.sqrt((org.eclipse.persistence.expressions.Expression)this.queryExpression);
        this.type[0] = Double.class;
    }

    public void visit(StateFieldPathExpression expression) {
        this.visitPathExpression((AbstractPathExpression)expression, false);
    }

    public void visit(StringLiteral expression) {
        this.queryExpression = this.queryContext.getBaseExpression();
        this.queryExpression = new ConstantExpression((Object)expression.getUnquotedText(), this.queryExpression);
        this.type[0] = String.class;
    }

    public void visit(SubExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SubstringExpression expression) {
        expression.getFirstExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression firstExpression = this.queryExpression;
        expression.getSecondExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression secondExpression = this.queryExpression;
        expression.getThirdExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression thirdExpression = this.queryExpression;
        this.queryExpression = thirdExpression != null ? firstExpression.substring((Object)secondExpression, (Object)thirdExpression) : firstExpression.substring((Object)secondExpression);
        this.type[0] = String.class;
    }

    public void visit(SubtractionExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression leftExpression = this.queryExpression;
        types.add(this.type[0]);
        expression.getRightExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression rightExpression = this.queryExpression;
        types.add(this.type[0]);
        this.queryExpression = ExpressionMath.subtract((org.eclipse.persistence.expressions.Expression)leftExpression, (Object)rightExpression);
        Collections.sort(types, this.numericTypeComparator());
        this.type[0] = (Class)types.get(0);
    }

    public void visit(SumFunction expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        if (expression.hasDistinct()) {
            this.queryExpression = this.queryExpression.distinct();
        }
        this.queryExpression = this.queryExpression.sum();
        this.type[0] = this.queryContext.typeResolver().convertSumFunctionType(this.type[0]);
    }

    public void visit(TreatExpression expression) {
        expression.accept((ExpressionVisitor)this.joinVisitor());
    }

    public void visit(TrimExpression expression) {
        expression.getTrimCharacter().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression trimCharacter = this.queryExpression;
        expression.getExpression().accept((ExpressionVisitor)this);
        org.eclipse.persistence.expressions.Expression stringExpression = this.queryExpression;
        switch (expression.getSpecification()) {
            case LEADING: {
                if (trimCharacter != null) {
                    this.queryExpression = stringExpression.leftTrim((Object)trimCharacter);
                    break;
                }
                this.queryExpression = stringExpression.leftTrim();
                break;
            }
            case TRAILING: {
                if (trimCharacter != null) {
                    this.queryExpression = stringExpression.rightTrim((Object)trimCharacter);
                    break;
                }
                this.queryExpression = stringExpression.rightTrim();
                break;
            }
            default: {
                this.queryExpression = trimCharacter != null ? stringExpression.trim((Object)trimCharacter) : stringExpression.trim();
            }
        }
        this.type[0] = String.class;
    }

    public void visit(TypeExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.type();
        this.typeExpression = true;
    }

    public void visit(UnknownExpression expression) {
        this.queryExpression = null;
    }

    public void visit(UpdateClause expression) {
    }

    public void visit(UpdateItem expression) {
    }

    public void visit(UpdateStatement expression) {
    }

    public void visit(UpperExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        this.queryExpression = this.queryExpression.toUpperCase();
        this.type[0] = String.class;
    }

    public void visit(ValueExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(WhenClause expression) {
    }

    public void visit(WhereClause expression) {
        expression.getConditionalExpression().accept((ExpressionVisitor)this);
    }

    private void visitInExpression(InExpression expression, org.eclipse.persistence.expressions.Expression stateFieldPathExpression) {
        InExpressionBuilder visitor = this.inExpressionBuilder();
        try {
            visitor.hasNot = expression.hasNot();
            visitor.singleInputParameter = !expression.hasLeftParenthesis();
            visitor.stateFieldPathExpression = stateFieldPathExpression;
            expression.getInItems().accept((ExpressionVisitor)visitor);
        }
        finally {
            visitor.hasNot = false;
            visitor.singleInputParameter = false;
            visitor.stateFieldPathExpression = null;
        }
    }

    private void visitPathExpression(AbstractPathExpression expression, boolean nullAllowed) {
        PathResolver resolver = this.pathResolver();
        int oldLength = resolver.length;
        boolean oldNullAllowed = resolver.nullAllowed;
        org.eclipse.persistence.expressions.Expression oldLocalExpression = resolver.localExpression;
        boolean oldCheckMappingType = resolver.checkMappingType;
        ClassDescriptor oldDescriptor = resolver.descriptor;
        try {
            resolver.length = expression.pathSize();
            resolver.nullAllowed = nullAllowed;
            resolver.checkMappingType = false;
            resolver.localExpression = null;
            resolver.descriptor = null;
            expression.accept((ExpressionVisitor)resolver);
            this.queryExpression = resolver.localExpression;
        }
        finally {
            resolver.length = oldLength;
            resolver.nullAllowed = oldNullAllowed;
            resolver.localExpression = oldLocalExpression;
            resolver.checkMappingType = oldCheckMappingType;
            resolver.descriptor = oldDescriptor;
        }
    }

    private WhenClauseExpressionVisitor whenClauseExpressionVisitor() {
        if (this.whenClauseExpressionVisitor == null) {
            this.whenClauseExpressionVisitor = new WhenClauseExpressionVisitor();
        }
        return this.whenClauseExpressionVisitor;
    }

    private class ChildrenExpressionVisitor
    extends AnonymousExpressionVisitor {
        List<Expression> expressions = new ArrayList<Expression>();

        ChildrenExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            for (Expression child : expression.children()) {
                this.expressions.add(child);
            }
        }

        public void visit(NullExpression expression) {
        }

        protected void visit(Expression expression) {
            this.expressions.add(expression);
        }
    }

    private class EmptyCollectionComparisonExpressionVisitor
    extends AbstractExpressionVisitor {
        private EmptyCollectionComparisonExpressionVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            int index = 0;
            int count = expression.pathSize();
            while (index < count) {
                if (index == 0) {
                    expression.getIdentificationVariable().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
                } else {
                    if (index + 1 >= count) break;
                    ExpressionBuilderVisitor.this.queryExpression.get(expression.getPath(index));
                }
                ++index;
            }
        }
    }

    private class InExpressionBuilder
    extends AnonymousExpressionVisitor {
        private boolean hasNot;
        private boolean singleInputParameter;
        private org.eclipse.persistence.expressions.Expression stateFieldPathExpression;
        private ExpressionVisitor visitor = new InItemExpressionVisitor();

        InExpressionBuilder() {
        }

        public void visit(CollectionExpression expression) {
            ArrayList<org.eclipse.persistence.expressions.Expression> expressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
            for (Expression child : expression.children()) {
                child.accept(this.visitor);
                expressions.add(ExpressionBuilderVisitor.this.queryExpression);
            }
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(expressions);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(expressions);
            }
        }

        public void visit(InputParameter expression) {
            if (this.singleInputParameter) {
                expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
                if (this.hasNot) {
                    ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(ExpressionBuilderVisitor.this.queryExpression);
                } else {
                    ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(ExpressionBuilderVisitor.this.queryExpression);
                }
            } else {
                this.visit((Expression)expression);
            }
        }

        protected void visit(Expression expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            ArrayList<org.eclipse.persistence.expressions.Expression> expressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
            expressions.add(ExpressionBuilderVisitor.this.queryExpression);
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(expressions);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(expressions);
            }
        }

        public void visit(SimpleSelectStatement expression) {
            ReportQuery subquery = ExpressionBuilderVisitor.this.buildSubquery(expression);
            if (this.hasNot) {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.notIn(subquery);
            } else {
                ExpressionBuilderVisitor.this.queryExpression = this.stateFieldPathExpression.in(subquery);
            }
        }

        private class InItemExpressionVisitor
        extends AnonymousExpressionVisitor {
            private InItemExpressionVisitor() {
            }

            public void visit(IdentificationVariable expression) {
                ClassDescriptor descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(expression.getVariableName());
                ExpressionBuilderVisitor.this.queryExpression = ExpressionBuilderVisitor.this.queryContext.getBaseExpression();
                ExpressionBuilderVisitor.this.queryExpression = (org.eclipse.persistence.expressions.Expression)new ConstantExpression((Object)descriptor.getJavaClass(), ExpressionBuilderVisitor.this.queryExpression);
            }

            protected void visit(Expression expression) {
                expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            }
        }
    }

    private class JoinVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private boolean nullAllowed;

        private JoinVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            ExpressionBuilderVisitor.this.visitPathExpression((AbstractPathExpression)expression, this.nullAllowed);
        }

        public void visit(Join expression) {
            try {
                this.nullAllowed = expression.isLeftJoin();
                expression.getJoinAssociationPath().accept((ExpressionVisitor)this);
            }
            finally {
                this.nullAllowed = false;
            }
        }

        public void visit(JoinFetch expression) {
            try {
                this.nullAllowed = expression.isLeftJoinFetch();
                expression.getJoinAssociationPath().accept((ExpressionVisitor)this);
            }
            finally {
                this.nullAllowed = false;
            }
        }

        public void visit(TreatExpression expression) {
            expression.getCollectionValuedPathExpression().accept((ExpressionVisitor)this);
            EntityTypeLiteral entityTypeLiteral = (EntityTypeLiteral)expression.getEntityType();
            ClassDescriptor entityType = ExpressionBuilderVisitor.this.queryContext.getDescriptor(entityTypeLiteral.getEntityTypeName());
            ExpressionBuilderVisitor.this.queryExpression = ExpressionBuilderVisitor.this.queryExpression.as(entityType.getJavaClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumericTypeComparator
    implements Comparator<Class<?>> {
        private NumericTypeComparator() {
        }

        @Override
        public int compare(Class<?> type1, Class<?> type2) {
            if (type1 == type2) {
                return 0;
            }
            if (type1 == Object.class) {
                return -1;
            }
            if (type2 == Object.class) {
                return 1;
            }
            if (type1 == Double.TYPE || type1 == Double.class) {
                return -1;
            }
            if (type2 == Double.TYPE || type2 == Double.class) {
                return 1;
            }
            if (type1 == Float.TYPE || type1 == Float.class) {
                return -1;
            }
            if (type2 == Float.TYPE || type2 == Float.class) {
                return 1;
            }
            if (type1 == BigDecimal.class) {
                return -1;
            }
            if (type2 == BigDecimal.class) {
                return 1;
            }
            if (type1 == BigInteger.class) {
                return -1;
            }
            if (type2 == BigInteger.class) {
                return 1;
            }
            if (type1 == Long.TYPE || type1 == Long.class) {
                return -1;
            }
            if (type2 == Long.TYPE || type2 == Long.class) {
                return 1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathResolver
    extends AbstractEclipseLinkExpressionVisitor {
        boolean checkMappingType;
        private ClassDescriptor descriptor;
        int length;
        org.eclipse.persistence.expressions.Expression localExpression;
        boolean nullAllowed;

        private PathResolver() {
        }

        private Enum<?> retrieveEnumConstant(Class<?> type, String constant) {
            ?[] constants = type.getEnumConstants();
            int index = constants.length;
            while (--index >= 0) {
                Enum enumConstant = (Enum)constants[index];
                if (!constant.equals(enumConstant.name())) continue;
                return enumConstant;
            }
            return null;
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.visitPathExpression((AbstractPathExpression)expression);
        }

        public void visit(EntryExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            String variableName = identificationVariable.getVariableName();
            Declaration declaration = ExpressionBuilderVisitor.this.queryContext.findDeclaration(variableName);
            declaration.getBaseExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = ExpressionBuilderVisitor.this.queryExpression;
            MapEntryExpression entryExpression = new MapEntryExpression(this.localExpression);
            entryExpression.returnMapEntry();
            this.localExpression = entryExpression;
        }

        public void visit(IdentificationVariable expression) {
            expression.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = ExpressionBuilderVisitor.this.queryExpression;
            if (this.localExpression != null) {
                Declaration declaration = ExpressionBuilderVisitor.this.queryContext.findDeclaration(expression.getVariableName());
                this.descriptor = declaration.getDescriptor();
            }
        }

        public void visit(KeyExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            identificationVariable.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = new MapEntryExpression(ExpressionBuilderVisitor.this.queryExpression);
            this.descriptor = ExpressionBuilderVisitor.this.queryContext.resolveDescriptor((Expression)expression);
        }

        public void visit(StateFieldPathExpression expression) {
            this.visitPathExpression((AbstractPathExpression)expression);
        }

        public void visit(ValueExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            identificationVariable.accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            this.localExpression = ExpressionBuilderVisitor.this.queryExpression;
            Declaration declaration = ExpressionBuilderVisitor.this.queryContext.findDeclaration(identificationVariable.getVariableName());
            this.descriptor = declaration.getDescriptor();
        }

        private void visitPathExpression(AbstractPathExpression expression) {
            Class<?> enumType;
            String fullPath = expression.toParsedText();
            expression.getIdentificationVariable().accept((ExpressionVisitor)this);
            if (this.localExpression == null && (enumType = ExpressionBuilderVisitor.this.queryContext.getEnumType(fullPath)) != null) {
                ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = enumType;
                String path = expression.getPath(expression.pathSize() - 1);
                Enum<?> enumConstant = this.retrieveEnumConstant(enumType, path);
                this.localExpression = new ConstantExpression(enumConstant, (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder());
                return;
            }
            int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
            int count = this.length;
            while (index < count) {
                String path = expression.getPath(index);
                DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForAttributeName(path);
                boolean last = index + 1 == count;
                boolean collectionMapping = false;
                if (mapping != null) {
                    if (ExpressionBuilderVisitor.this.type != null) {
                        ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = ExpressionBuilderVisitor.this.queryContext.resolveMappingType(mapping);
                    }
                    collectionMapping = mapping.isCollectionMapping();
                    if (!last) {
                        this.descriptor = mapping.getReferenceDescriptor();
                    } else if (this.checkMappingType) {
                        this.nullAllowed = mapping.isForeignReferenceMapping();
                    }
                } else {
                    QueryKey queryKey = this.descriptor.getQueryKeyNamed(path);
                    if (queryKey == null) break;
                    if (ExpressionBuilderVisitor.this.type != null) {
                        ((ExpressionBuilderVisitor)ExpressionBuilderVisitor.this).type[0] = ExpressionBuilderVisitor.this.queryContext.resolveQueryKeyType(queryKey);
                    }
                    collectionMapping = queryKey.isCollectionQueryKey();
                    if (!last && queryKey.isForeignReferenceQueryKey()) {
                        ForeignReferenceQueryKey referenceQueryKey = (ForeignReferenceQueryKey)queryKey;
                        this.descriptor = ExpressionBuilderVisitor.this.queryContext.getDescriptor(referenceQueryKey.getReferenceClass());
                    }
                }
                this.localExpression = collectionMapping ? (last && this.nullAllowed ? this.localExpression.anyOfAllowingNone(path) : this.localExpression.anyOf(path)) : (last && this.nullAllowed ? this.localExpression.getAllowingNull(path) : this.localExpression.get(path));
                ++index;
            }
        }
    }

    private class WhenClauseExpressionVisitor
    extends AbstractExpressionVisitor {
        final List<Class<?>> types = new LinkedList();
        Map<org.eclipse.persistence.expressions.Expression, org.eclipse.persistence.expressions.Expression> whenClauses = new LinkedHashMap<org.eclipse.persistence.expressions.Expression, org.eclipse.persistence.expressions.Expression>();

        WhenClauseExpressionVisitor() {
        }

        void dispose() {
            this.types.clear();
            this.whenClauses.clear();
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(WhenClause expression) {
            expression.getWhenExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            org.eclipse.persistence.expressions.Expression whenExpression = ExpressionBuilderVisitor.this.queryExpression;
            this.types.add(ExpressionBuilderVisitor.this.type[0]);
            expression.getThenExpression().accept((ExpressionVisitor)ExpressionBuilderVisitor.this);
            org.eclipse.persistence.expressions.Expression thenExpression = ExpressionBuilderVisitor.this.queryExpression;
            this.whenClauses.put(whenExpression, thenExpression);
        }
    }
}

