/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.internal.jpa.jpql.ExpressionBuilderVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ParameterTypeVisitor;
import org.eclipse.persistence.internal.jpa.jpql.RangeDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.ReportQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.TypeResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.EclipseLinkLiteralVisitor;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JPQLQueryContext {
    private JPQLQueryContext currentContext = this;
    private Expression currentQuery;
    private DeclarationResolver declarationResolver;
    private ExpressionBuilderVisitor expressionBuilder;
    private Map<String, org.eclipse.persistence.expressions.Expression> expressions;
    private Map<String, Class<?>> inputParameters;
    private JPQLExpression jpqlExpression;
    private String jpqlQuery;
    private EclipseLinkLiteralVisitor literalVisitor;
    private ParameterTypeVisitor parameterTypeVisitor;
    private JPQLQueryContext parent;
    private DatabaseQuery query;
    private ReportQueryVisitor reportQueryVisitor;
    private AbstractSession session;
    private TypeResolver typeResolver;
    private Map<String, Class<?>> types;
    private Set<String> usedIdentificationVariables;
    private static final Class<?>[] EMPTY_TYPE = new Class[1];

    JPQLQueryContext() {
    }

    private JPQLQueryContext(JPQLQueryContext parent, Expression currentQuery, ReportQuery query) {
        this();
        this.query = query;
        this.parent = parent;
        this.currentQuery = currentQuery;
    }

    void addInputParameter(String parameterName, Class<?> type) {
        if (this.parent != null) {
            this.parent.addInputParameter(parameterName, type);
        }
        if (this.inputParameters == null) {
            this.inputParameters = new HashMap();
        }
        this.inputParameters.put(parameterName, type);
    }

    void addQueryExpression(String variableName, org.eclipse.persistence.expressions.Expression expression) {
        this.currentContext.addQueryExpressionImp(variableName, expression);
    }

    void addQueryExpressionImp(String variableName, org.eclipse.persistence.expressions.Expression expression) {
        if (this.expressions == null) {
            this.expressions = new HashMap<String, org.eclipse.persistence.expressions.Expression>();
        }
        this.expressions.put(variableName, expression);
    }

    void addRangeVariableDeclaration(String entityName, String variableName) {
        RangeDeclaration declaration = this.getDeclarationResolverImp().addRangeVariableDeclaration(entityName, variableName);
        declaration.getQueryExpression();
    }

    void addUsedIdentificationVariable(String variableName) {
        this.currentContext.addUsedIdentificationVariableImp(variableName);
    }

    void addUsedIdentificationVariableImp(String variableName) {
        if (this.usedIdentificationVariables == null) {
            this.usedIdentificationVariables = new HashSet<String>();
        }
        this.usedIdentificationVariables.add(variableName);
    }

    private Class<?> attemptLoadType(String typeName) {
        block5: {
            try {
                if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block5;
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(typeName, true, this.getClassLoader()));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getClassForName((String)typeName, (boolean)true, (ClassLoader)this.getClassLoader());
    }

    org.eclipse.persistence.expressions.Expression buildExpression(Expression expression) {
        return this.expressionBuilder().buildExpression(expression, EMPTY_TYPE);
    }

    org.eclipse.persistence.expressions.Expression buildExpression(Expression expression, Class<?>[] type) {
        return this.expressionBuilder().buildExpression(expression, type);
    }

    org.eclipse.persistence.expressions.Expression buildGroupByExpression(CollectionValuedPathExpression expression) {
        return this.expressionBuilder().buildGroupByExpression(expression);
    }

    org.eclipse.persistence.expressions.Expression buildModifiedPathExpression(StateFieldPathExpression expression) {
        return this.expressionBuilder().buildModifiedPathExpression(expression);
    }

    void cache(AbstractSession session, DatabaseQuery query, JPQLExpression jpqlExpression, String jpqlQuery) {
        this.query = query;
        this.session = session;
        this.jpqlQuery = jpqlQuery;
        this.currentQuery = jpqlExpression;
        this.jpqlExpression = jpqlExpression;
    }

    void dispose() {
        this.query = null;
        this.session = null;
        this.jpqlQuery = null;
        this.currentQuery = null;
        this.jpqlExpression = null;
        this.currentContext = this;
        if (this.types != null) {
            this.types.clear();
        }
        if (this.expressions != null) {
            this.expressions.clear();
        }
        if (this.inputParameters != null) {
            this.inputParameters.clear();
        }
        if (this.declarationResolver != null) {
            this.declarationResolver.dispose();
        }
        if (this.usedIdentificationVariables != null) {
            this.usedIdentificationVariables.clear();
        }
    }

    void disposeSubqueryContext() {
        this.currentContext = this.currentContext.parent;
    }

    private ExpressionBuilderVisitor expressionBuilder() {
        if (this.parent != null) {
            return this.parent.expressionBuilder();
        }
        if (this.expressionBuilder == null) {
            this.expressionBuilder = new ExpressionBuilderVisitor(this);
        }
        return this.expressionBuilder;
    }

    Declaration findDeclaration(String variableName) {
        return this.currentContext.findDeclarationImp(variableName);
    }

    Declaration findDeclarationImp(String variableName) {
        Declaration declaration = this.getDeclarationResolverImp().getDeclaration(variableName);
        if (declaration == null && this.parent != null) {
            declaration = this.parent.findDeclarationImp(variableName);
        }
        return declaration;
    }

    org.eclipse.persistence.expressions.Expression findQueryExpression(String variableName) {
        return this.currentContext.findQueryExpressionImp(variableName);
    }

    org.eclipse.persistence.expressions.Expression findQueryExpressionImp(String variableName) {
        org.eclipse.persistence.expressions.Expression expression = this.getQueryExpressionImp(variableName);
        if (expression == null && this.parent != null) {
            expression = this.parent.findQueryExpressionImp(variableName);
        }
        return expression;
    }

    org.eclipse.persistence.expressions.Expression getBaseExpression() {
        return this.getDeclarationResolver().getFirstDeclaration().getQueryExpression();
    }

    private ClassLoader getClassLoader() {
        return this.getSession().getDatasourcePlatform().getConversionManager().getLoader();
    }

    <T> Constructor<T> getConstructor(Class<?> type, Class<?>[] parameterTypes) {
        block5: {
            try {
                if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block5;
                try {
                    return (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(type, (Class[])parameterTypes, true));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getConstructorFor(type, (Class[])parameterTypes, (boolean)true);
    }

    JPQLQueryContext getCurrentContext() {
        return this.currentContext;
    }

    Expression getCurrentQuery() {
        return this.currentContext.currentQuery;
    }

    <T extends DatabaseQuery> T getDatabaseQuery() {
        return (T)this.currentContext.query;
    }

    Declaration getDeclaration(String variableName) {
        return this.getDeclarationResolver().getDeclaration(variableName);
    }

    DeclarationResolver getDeclarationResolver() {
        return this.currentContext.getDeclarationResolverImp();
    }

    DeclarationResolver getDeclarationResolverImp() {
        if (this.declarationResolver == null) {
            DeclarationResolver parentResolver = this.parent == null ? null : this.parent.getDeclarationResolverImp();
            this.declarationResolver = new DeclarationResolver(this, parentResolver);
        }
        this.declarationResolver.populate(this.currentQuery);
        return this.declarationResolver;
    }

    Collection<Declaration> getDeclarations() {
        return this.getDeclarationResolver().getDeclarations();
    }

    ClassDescriptor getDescriptor(Class<?> type) {
        return this.getSession().getClassDescriptor(type);
    }

    ClassDescriptor getDescriptor(String abstractSchemaName) {
        return this.getSession().getDescriptorForAlias(abstractSchemaName);
    }

    Class<?> getEnumType(String enumTypeName) {
        int lastDotIndex = enumTypeName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return null;
        }
        String typeName = enumTypeName.substring(0, lastDotIndex);
        Class<?> type = this.getType(typeName);
        return type != null && type.isEnum() ? type : null;
    }

    Declaration getFirstDeclaration() {
        return this.currentContext.getFirstDeclarationImp();
    }

    Declaration getFirstDeclarationImp() {
        return this.getDeclarationResolverImp().getFirstDeclaration();
    }

    Collection<JoinFetch> getJoinFetches(String variableName) {
        return this.getDeclarationResolver().getJoinFetches(variableName);
    }

    JPQLExpression getJPQLExpression() {
        return this.parent != null ? this.parent.getJPQLExpression() : this.jpqlExpression;
    }

    String getJPQLQuery() {
        return this.parent != null ? this.parent.getJPQLQuery() : this.jpqlQuery;
    }

    Class<?> getParameterType(InputParameter inputParameter) {
        ParameterTypeVisitor resolver = this.parameterTypeVisitor();
        try {
            inputParameter.accept((ExpressionVisitor)resolver);
            Class<?> clazz = resolver.getType();
            return clazz;
        }
        finally {
            resolver.dispose();
        }
    }

    JPQLQueryContext getParent() {
        return this.currentContext.parent;
    }

    org.eclipse.persistence.expressions.Expression getQueryExpression(String variableName) {
        return this.currentContext.getQueryExpressionImp(variableName);
    }

    org.eclipse.persistence.expressions.Expression getQueryExpressionImp(String variableName) {
        return this.expressions == null ? null : this.expressions.get(variableName);
    }

    AbstractSession getSession() {
        return this.parent != null ? this.parent.getSession() : this.session;
    }

    Class<?> getType(Expression expression) {
        return this.typeResolver().resolve(expression);
    }

    Class<?> getType(String typeName) {
        return this.loadTypeImp(typeName);
    }

    private Map<String, Class<?>> getTypes() {
        Map<String, Class<?>> map;
        if (this.parent != null) {
            map = this.parent.getTypes();
        } else if (this.types == null) {
            this.types = new HashMap();
            map = this.types;
        } else {
            map = this.types;
        }
        return map;
    }

    Set<String> getUsedIdentificationVariables() {
        return this.currentContext.getUsedIdentificationVariablesImp();
    }

    Set<String> getUsedIdentificationVariablesImp() {
        if (this.usedIdentificationVariables == null) {
            return Collections.emptySet();
        }
        return this.usedIdentificationVariables;
    }

    Set<Map.Entry<String, Class<?>>> inputParameters() {
        if (this.inputParameters == null) {
            return Collections.emptySet();
        }
        return this.inputParameters.entrySet();
    }

    boolean isIdentificationVariableUsed(String variableName) {
        return this.currentContext.isIdentificationVariableUsedImp(variableName);
    }

    private boolean isIdentificationVariableUsedImp(String variableName) {
        boolean result;
        boolean bl = result = this.usedIdentificationVariables != null && this.usedIdentificationVariables.contains(variableName);
        if (!result && this.parent != null) {
            result = this.parent.isIdentificationVariableUsedImp(variableName);
        }
        return result;
    }

    boolean isRangeIdentificationVariable(String variableName) {
        return this.getDeclarationResolverImp().isRangeIdentificationVariable(variableName);
    }

    boolean isResultVariable(String variableName) {
        return this.getDeclarationResolverImp().isResultVariable(variableName);
    }

    String literal(Expression expression, LiteralType type) {
        LiteralVisitor visitor = this.literalVisitor();
        try {
            visitor.setType(type);
            expression.accept((ExpressionVisitor)visitor);
            if (visitor.literal != "" && (type == LiteralType.IDENTIFICATION_VARIABLE || type == LiteralType.RESULT_VARIABLE || type == LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE)) {
                String string = visitor.literal.toUpperCase().intern();
                return string;
            }
            String string = visitor.literal;
            return string;
        }
        finally {
            visitor.literal = "";
        }
    }

    private LiteralVisitor literalVisitor() {
        if (this.parent != null) {
            return this.parent.literalVisitor();
        }
        if (this.literalVisitor == null) {
            this.literalVisitor = new EclipseLinkLiteralVisitor();
        }
        return this.literalVisitor;
    }

    private Class<?> loadInnerType(String typeName) {
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(typeName.substring(0, index));
        sb.append("$");
        sb.append(typeName.substring(index + 1, typeName.length()));
        typeName = sb.toString();
        return this.loadTypeImp(typeName);
    }

    private Class<?> loadTypeImp(String typeName) {
        Map<String, Class<?>> types = this.getTypes();
        Class<?> type = types.get(typeName);
        if (type != null) {
            return type;
        }
        Class<?> javaType = this.attemptLoadType(typeName);
        if (javaType != null) {
            types.put(javaType.getName(), javaType);
            return javaType;
        }
        return this.loadInnerType(typeName);
    }

    <T> T newInstance(Class<?> type, Class<?> parameterType, Object parameter) {
        return this.newInstance(type, new Class[]{parameterType}, new Object[]{parameter});
    }

    <T> T newInstance(Class<?> type, Class<?>[] parameterTypes, Object[] parameters) {
        Constructor<T> constructor = this.getConstructor(type, parameterTypes);
        if (constructor != null) {
            return this.newInstance(constructor, parameters);
        }
        return null;
    }

    <T> T newInstance(Constructor<T> constructor, Object[] parameters) {
        block7: {
            if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block7;
            try {
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, parameters));
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
        try {
            return (T)PrivilegedAccessHelper.invokeConstructor(constructor, (Object[])parameters);
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    void newSubQueryContext(Expression currentQuery, ReportQuery query) {
        this.currentContext = new JPQLQueryContext(this.currentContext, currentQuery, query);
    }

    private ParameterTypeVisitor parameterTypeVisitor() {
        if (this.parent != null) {
            return this.parent.parameterTypeVisitor();
        }
        if (this.parameterTypeVisitor == null) {
            this.parameterTypeVisitor = new ParameterTypeVisitor(this);
        }
        return this.parameterTypeVisitor;
    }

    void populateReportQuery(AbstractSelectStatement expression, ReportQuery query) {
        this.populateReportQuery(expression, query, EMPTY_TYPE);
    }

    void populateReportQuery(AbstractSelectStatement expression, ReportQuery query, Class<?>[] type) {
        ReportQueryVisitor visitor = this.reportQueryVisitor();
        try {
            visitor.type = type;
            visitor.query = query;
            expression.accept((ExpressionVisitor)visitor);
        }
        finally {
            visitor.type = null;
            visitor.query = null;
        }
    }

    private ReportQueryVisitor reportQueryVisitor() {
        if (this.parent != null) {
            return this.parent.reportQueryVisitor();
        }
        if (this.reportQueryVisitor == null) {
            this.reportQueryVisitor = new ReportQueryVisitor(this);
        }
        return this.reportQueryVisitor;
    }

    ClassDescriptor resolveDescriptor(Expression expression) {
        return this.typeResolver().resolveDescriptor(expression);
    }

    DatabaseMapping resolveMapping(Expression expression) {
        return this.typeResolver().resolveMapping(expression);
    }

    Class<?> resolveMappingType(DatabaseMapping mapping) {
        return this.typeResolver().resolveMappingType(mapping);
    }

    Class<?> resolveQueryKeyType(QueryKey queryKey) {
        return this.typeResolver().resolveQueryKeyType(queryKey);
    }

    void setDatabasQuery(DatabaseQuery query) {
        this.query = query;
    }

    TypeResolver typeResolver() {
        if (this.parent != null) {
            return this.parent.typeResolver();
        }
        if (this.typeResolver == null) {
            this.typeResolver = new TypeResolver(this);
        }
        return this.typeResolver;
    }
}

