/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql.spi;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.jpql.spi.AbstractMapping;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaTypeDeclaration;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaQueryKey
extends AbstractMapping {
    private final QueryKey queryKey;
    private ITypeDeclaration typeDeclaration;

    JavaQueryKey(IManagedType parent, QueryKey queryKey) {
        super(parent);
        this.queryKey = queryKey;
    }

    private IType buildType() {
        Class<?> type = this.getPropertyType();
        if (type != null) {
            return this.getTypeRepository().getType(type);
        }
        return this.getTypeRepository().getTypeHelper().objectType();
    }

    private ITypeDeclaration buildTypeDeclaration() {
        if (this.queryKey.isForeignReferenceQueryKey()) {
            return new JavaTypeDeclaration(this.getTypeRepository(), this.buildType(), this.getPropertyType(), false);
        }
        return new JavaTypeDeclaration(this.getTypeRepository(), this.buildType(), null, false);
    }

    @Override
    int calculateMappingType() {
        if (this.queryKey.isDirectQueryKey()) {
            return 1;
        }
        if (this.queryKey.isDirectCollectionQueryKey()) {
            return 2;
        }
        if (this.queryKey.isManyToManyQueryKey()) {
            return 6;
        }
        if (this.queryKey.isOneToManyQueryKey()) {
            return 8;
        }
        if (this.queryKey.isOneToOneQueryKey()) {
            return 9;
        }
        return 10;
    }

    public int compareTo(IMapping mapping) {
        return this.getName().compareTo(mapping.getName());
    }

    public String getName() {
        return this.queryKey.getName();
    }

    private Class<?> getPropertyType() {
        if (this.queryKey.isForeignReferenceQueryKey()) {
            ForeignReferenceQueryKey foreignReferenceQueryKey = (ForeignReferenceQueryKey)this.queryKey;
            return foreignReferenceQueryKey.getReferenceClass();
        }
        DirectQueryKey key = (DirectQueryKey)this.queryKey;
        return key.getField().getType();
    }

    public IType getType() {
        return this.getTypeDeclaration().getType();
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return false;
    }

    public boolean isCollection() {
        return this.queryKey.isCollectionQueryKey();
    }

    public boolean isProperty() {
        return this.queryKey.isDirectQueryKey();
    }

    public boolean isRelationship() {
        return this.queryKey.isForeignReferenceQueryKey();
    }
}

