/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.RecordConverter;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.w3c.dom.Element;

public class EISPlatform
extends DatasourcePlatform {
    protected boolean isIndexedRecordSupported;
    protected boolean isMappedRecordSupported;
    protected boolean isDOMRecordSupported;
    protected boolean shouldConvertDataToStrings;
    protected boolean supportsLocalTransactions;
    protected boolean requiresAutoCommit;
    protected RecordConverter recordConverter;
    protected Method domMethod;
    protected XMLConversionManager xmlConversionManager;

    public EISPlatform() {
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(false);
        this.setShouldConvertDataToStrings(false);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(false);
    }

    public RecordConverter getRecordConverter() {
        return this.recordConverter;
    }

    public void setRecordConverter(RecordConverter recordConverter) {
        this.recordConverter = recordConverter;
    }

    public boolean requiresAutoCommit() {
        return this.requiresAutoCommit;
    }

    public void setRequiresAutoCommit(boolean requiresAutoCommit) {
        this.requiresAutoCommit = requiresAutoCommit;
    }

    public boolean supportsLocalTransactions() {
        return this.supportsLocalTransactions;
    }

    public void setSupportsLocalTransactions(boolean supportsLocalTransactions) {
        this.supportsLocalTransactions = supportsLocalTransactions;
    }

    public boolean isIndexedRecordSupported() {
        return this.isIndexedRecordSupported;
    }

    public void setIsIndexedRecordSupported(boolean isIndexedRecordSupported) {
        this.isIndexedRecordSupported = isIndexedRecordSupported;
    }

    public boolean isMappedRecordSupported() {
        return this.isMappedRecordSupported;
    }

    public void setIsMappedRecordSupported(boolean isMappedRecordSupported) {
        this.isMappedRecordSupported = isMappedRecordSupported;
    }

    public boolean isDOMRecordSupported() {
        return this.isDOMRecordSupported;
    }

    public void setIsDOMRecordSupported(boolean isDOMRecordSupported) {
        this.isDOMRecordSupported = isDOMRecordSupported;
    }

    public boolean shouldConvertDataToStrings() {
        return this.shouldConvertDataToStrings;
    }

    public void setShouldConvertDataToStrings(boolean shouldConvertDataToStrings) {
        this.shouldConvertDataToStrings = shouldConvertDataToStrings;
    }

    public InteractionSpec buildInteractionSpec(EISInteraction interaction) {
        return interaction.getInteractionSpec();
    }

    public Record createInputRecord(EISInteraction interaction, EISAccessor accessor) {
        Record input = interaction.createInputRecord(accessor);
        if (this.getRecordConverter() != null) {
            input = this.getRecordConverter().converterToAdapterRecord(input);
        }
        return input;
    }

    public Record createOutputRecord(EISInteraction interaction, AbstractRecord translationRow, EISAccessor accessor) {
        return null;
    }

    public AbstractRecord buildRow(Record record, EISInteraction interaction, EISAccessor accessor) {
        Record output = record;
        if (this.getRecordConverter() != null) {
            output = this.getRecordConverter().converterFromAdapterRecord(output);
        }
        return interaction.buildRow(output, accessor);
    }

    public Vector buildRows(Record record, EISInteraction interaction, EISAccessor accessor) {
        Record output = record;
        if (this.getRecordConverter() != null) {
            output = this.getRecordConverter().converterFromAdapterRecord(output);
        }
        return interaction.buildRows(output, accessor);
    }

    public Record createDOMRecord(String recordName, EISAccessor accessor) {
        try {
            return accessor.getRecordFactory().createMappedRecord(recordName);
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public AbstractRecord createDatabaseRowFromDOMRecord(Record record, EISInteraction call, EISAccessor accessor) {
        return new EISDOMRecord(record);
    }

    public Object getValueFromRecord(String key, MappedRecord record, EISAccessor accessor) {
        return record.get((Object)key);
    }

    public void setDOMInRecord(Element dom, Record record, EISInteraction call, EISAccessor accessor) {
        block10: {
            if (this.domMethod == null) {
                Class[] argumentTypes = new Class[]{Element.class};
                try {
                    this.domMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetMethod(record.getClass(), "setDom", argumentTypes, false)) : PrivilegedAccessHelper.getMethod(record.getClass(), "setDom", argumentTypes, false);
                }
                catch (Exception exception) {
                    try {
                        this.domMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetMethod(record.getClass(), "setDOM", argumentTypes, false)) : PrivilegedAccessHelper.getMethod(record.getClass(), "setDOM", argumentTypes, false);
                    }
                    catch (Exception cantFind) {
                        throw new EISException(cantFind);
                    }
                }
            }
            try {
                Object[] arguments = new Object[]{dom};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(this.domMethod, record, arguments));
                        break block10;
                    }
                    catch (PrivilegedActionException ex) {
                        throw (Exception)ex.getCause();
                    }
                }
                PrivilegedAccessHelper.invokeMethod(this.domMethod, record, arguments);
            }
            catch (Exception error) {
                throw new EISException(error);
            }
        }
    }

    public void setValueInRecord(String key, Object value, MappedRecord record, EISAccessor accessor) {
        Object recordValue = value;
        if (this.shouldConvertDataToStrings() && !(value instanceof Record) && !(value instanceof Collection)) {
            recordValue = this.getConversionManager().convertObject(value, ClassConstants.STRING);
        }
        record.put((Object)key, recordValue);
    }

    public void appendParameter(Call call, Writer writer, Object parameter) {
        if (parameter instanceof Vector) {
            Vector records = (Vector)parameter;
            int index = 0;
            while (index < records.size()) {
                this.appendParameter(call, writer, records.elementAt(index));
                ++index;
            }
        } else if (parameter instanceof DOMRecord) {
            String xml = ((DOMRecord)parameter).transformToXML();
            int start = xml.indexOf(62);
            xml = xml.substring(start + 1, xml.length());
            try {
                writer.write(xml);
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        } else {
            super.appendParameter(call, writer, parameter);
        }
    }

    public ConversionManager getConversionManager() {
        if (this.isDOMRecordSupported()) {
            if (this.xmlConversionManager == null) {
                this.xmlConversionManager = (XMLConversionManager)XMLConversionManager.getDefaultXMLManager().clone();
            }
            return this.xmlConversionManager;
        }
        return super.getConversionManager();
    }

    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        throw QueryException.noCallOrInteractionSpecified();
    }
}

