/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class QNameInheritancePolicy
extends InheritancePolicy {
    private NamespaceResolver namespaceResolver;

    public QNameInheritancePolicy() {
    }

    public QNameInheritancePolicy(ClassDescriptor desc) {
        super(desc);
    }

    protected void updateTables() {
        Vector<DatabaseTable> childTables = this.getDescriptor().getTables();
        Vector<DatabaseTable> parentTables = this.getParentDescriptor().getTables();
        Vector uniqueTables = Helper.concatenateUniqueVectors(childTables, parentTables);
        this.getDescriptor().setTables(uniqueTables);
        if (childTables.isEmpty()) {
            this.getDescriptor().setInternalDefaultTable();
        } else {
            this.getDescriptor().setInternalDefaultTable((DatabaseTable)uniqueTables.get(uniqueTables.indexOf(childTables.get(0))));
        }
    }

    public void initialize(AbstractSession session) {
        super.initialize(session);
        if (!this.shouldUseClassNameAsIndicator()) {
            for (Map.Entry entry : new HashMap(this.getClassIndicatorMapping()).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    XPathQName qname;
                    String indicatorValue = (String)key;
                    int index = indicatorValue.indexOf(58);
                    if (index != -1 && this.namespaceResolver != null) {
                        String prefix = indicatorValue.substring(0, index);
                        String localPart = indicatorValue.substring(index + 1);
                        String uri = this.namespaceResolver.resolveNamespacePrefix(prefix);
                        qname = new XPathQName(uri, localPart, true);
                    } else {
                        qname = this.namespaceResolver != null ? new XPathQName(this.namespaceResolver.getDefaultNamespaceURI(), indicatorValue, true) : new XPathQName(indicatorValue, true);
                    }
                    this.getClassIndicatorMapping().put(qname, entry.getValue());
                    continue;
                }
                if (!(key instanceof QName)) continue;
                XPathQName xpathQName = new XPathQName((QName)key, true);
                this.getClassIndicatorMapping().put(xpathQName, entry.getValue());
            }
        }
        if (this.getClassIndicatorField() != null) {
            XMLField classIndicatorXMLField;
            try {
                classIndicatorXMLField = (XMLField)this.getClassIndicatorField();
            }
            catch (ClassCastException classCastException) {
                classIndicatorXMLField = new XMLField(this.getClassIndicatorField().getName());
                this.setClassIndicatorField(classIndicatorXMLField);
            }
            XPathFragment frag = classIndicatorXMLField.getLastXPathFragment();
            if (frag != null && frag.hasNamespace() && frag.getPrefix() != null && this.namespaceResolver != null) {
                String uri = this.namespaceResolver.resolveNamespacePrefix(frag.getPrefix());
                classIndicatorXMLField.getLastXPathFragment().setNamespaceURI(uri);
            }
        }
    }

    public Class classFromRow(AbstractRecord rowFromDatabase, AbstractSession session) throws DescriptorException {
        Class concreteClass;
        ((XMLRecord)rowFromDatabase).setSession(session);
        boolean namespaceAware = ((XMLRecord)rowFromDatabase).isNamespaceAware();
        if (this.hasClassExtractor() || this.shouldUseClassNameAsIndicator()) {
            return super.classFromRow(rowFromDatabase, session);
        }
        Object indicator = rowFromDatabase.get(this.getClassIndicatorField());
        if (indicator == AbstractRecord.noEntry) {
            return null;
        }
        if (indicator == null) {
            return null;
        }
        if (indicator instanceof String) {
            String indicatorValue = (String)indicator;
            int index = indicatorValue.indexOf(((XMLRecord)rowFromDatabase).getNamespaceSeparator());
            if (index == -1) {
                if (namespaceAware) {
                    String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(null);
                    if (uri == null) {
                        concreteClass = (Class)this.classIndicatorMapping.get(new XPathQName(((XMLRecord)rowFromDatabase).getNamespaceResolver().getDefaultNamespaceURI(), indicatorValue, namespaceAware));
                    } else {
                        XPathQName qname = new XPathQName(uri, indicatorValue, namespaceAware);
                        concreteClass = (Class)this.classIndicatorMapping.get(qname);
                    }
                } else {
                    XPathQName qname = new XPathQName(indicatorValue, namespaceAware);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                }
            } else {
                String prefix = indicatorValue.substring(0, index);
                String localPart = indicatorValue.substring(index + 1);
                String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(prefix);
                if (uri != null) {
                    XPathQName qname = new XPathQName(uri, localPart, namespaceAware);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                } else {
                    concreteClass = (Class)this.classIndicatorMapping.get(indicatorValue);
                }
            }
        } else {
            concreteClass = (Class)this.classIndicatorMapping.get(indicator);
        }
        if (concreteClass == null) {
            throw DescriptorException.missingClassForIndicatorFieldValue(indicator, this.getDescriptor());
        }
        return concreteClass;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public void setClassIndicatorFieldName(String fieldName) {
        if (fieldName == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new XMLField(fieldName));
        }
    }

    public void addClassIndicatorFieldToRow(AbstractRecord databaseRow) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField field = this.getClassIndicatorField();
        Object value = this.getClassIndicatorValue();
        boolean namespaceAware = ((XMLRecord)databaseRow).isNamespaceAware();
        if (!namespaceAware && value instanceof String) {
            int colonIndex = ((String)value).indexOf(58);
            if (colonIndex > -1) {
                value = ((String)value).substring(colonIndex + 1);
            }
        } else if (namespaceAware && value instanceof String && ((XMLRecord)databaseRow).getNamespaceSeparator() != ':') {
            value = ((String)value).replace(':', ((XMLRecord)databaseRow).getNamespaceSeparator());
        }
        databaseRow.put(field, value);
    }
}

