/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.AnyMappingContentHandler;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLAnyCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private XMLAnyCollectionMapping xmlAnyCollectionMapping;
    private int index = -1;

    public XMLAnyCollectionMappingNodeValue(XMLAnyCollectionMapping xmlAnyCollectionMapping) {
        this.xmlAnyCollectionMapping = xmlAnyCollectionMapping;
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment == null;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlAnyCollectionMapping.isReadOnly()) {
            return false;
        }
        ContainerPolicy cp = this.xmlAnyCollectionMapping.getContainerPolicy();
        Object collection = this.xmlAnyCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (iterator == null) return false;
        if (!cp.hasNext(iterator)) return false;
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            if (this.xmlAnyCollectionMapping.getConverter() != null) {
                objectValue = this.xmlAnyCollectionMapping.getConverter().convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller());
            }
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        block6: {
            try {
                QName qname;
                Object collection = unmarshalRecord.getContainerInstance(this);
                this.startElementProcessText(unmarshalRecord, collection);
                XMLContext xmlContext = unmarshalRecord.getUnmarshaller().getXMLContext();
                XMLDescriptor workingDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlAnyCollectionMapping, this.xmlAnyCollectionMapping.getKeepAsElementPolicy());
                if (workingDescriptor == null && (workingDescriptor = xmlContext.getDescriptor(qname = new QName(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName()))) != null && workingDescriptor.isWrapper()) {
                    workingDescriptor = null;
                }
                UnmarshalKeepAsElementPolicy policy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
                if (workingDescriptor == null && policy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || policy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                    this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                    break block6;
                }
                if (workingDescriptor != null) {
                    this.processChild(xPathFragment, unmarshalRecord, atts, workingDescriptor, this.xmlAnyCollectionMapping);
                    break block6;
                }
                AnyMappingContentHandler handler = new AnyMappingContentHandler(unmarshalRecord, this.xmlAnyCollectionMapping.usesXMLRoot());
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
                }
                handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(handler);
                xmlReader.setLexicalHandler(handler);
                return true;
            }
            catch (SAXException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        UnmarshalRecord childRecord = unmarshalRecord.getChildRecord();
        if (childRecord != null) {
            if (!this.xmlAnyCollectionMapping.usesXMLRoot()) {
                Object objectValue = childRecord.getCurrentObject();
                if (this.xmlAnyCollectionMapping.getConverter() != null) {
                    objectValue = this.xmlAnyCollectionMapping.getConverter().convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
                }
                unmarshalRecord.addAttributeValue(this, objectValue);
            } else {
                Object childObject = childRecord.getCurrentObject();
                XMLDescriptor workingDescriptor = childRecord.getDescriptor();
                if (workingDescriptor != null) {
                    String prefix = xPathFragment.getPrefix();
                    if (prefix == null && xPathFragment.getNamespaceURI() != null) {
                        prefix = unmarshalRecord.resolveNamespaceUri(xPathFragment.getNamespaceURI());
                    }
                    childObject = workingDescriptor.wrapObjectInXMLRoot(childObject, xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), prefix, false, unmarshalRecord.isNamespaceAware());
                    if (this.xmlAnyCollectionMapping.getConverter() != null) {
                        childObject = this.xmlAnyCollectionMapping.getConverter().convertDataValueToObjectValue(childObject, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
                    }
                    unmarshalRecord.addAttributeValue(this, childObject);
                }
            }
            unmarshalRecord.setChildRecord(null);
        } else {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
            if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && builder.getNodes().size() > 1) {
                this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlAnyCollectionMapping, this.xmlAnyCollectionMapping.getConverter(), unmarshalRecord, true, null);
            } else if (this.xmlAnyCollectionMapping.isMixedContent()) {
                this.endElementProcessText(unmarshalRecord, this.xmlAnyCollectionMapping.getConverter(), xPathFragment, null);
            } else {
                unmarshalRecord.resetStringBuffer();
            }
        }
    }

    private void startElementProcessText(UnmarshalRecord unmarshalRecord, Object collection) {
        String value = unmarshalRecord.getCharacters().toString();
        unmarshalRecord.resetStringBuffer();
        if (value.length() > 0 && this.xmlAnyCollectionMapping.isMixedContent()) {
            unmarshalRecord.addAttributeValue(this, value);
        }
    }

    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        if (!this.xmlAnyCollectionMapping.usesXMLRoot() || xPathFragment.getLocalName() == null) {
            unmarshalRecord.addAttributeValue(this, value);
        } else {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setNamespaceURI(xPathFragment.getNamespaceURI());
            xmlRoot.setSchemaType(unmarshalRecord.getTypeQName());
            xmlRoot.setLocalName(xPathFragment.getLocalName());
            xmlRoot.setObject(value);
            unmarshalRecord.addAttributeValue(this, xmlRoot);
        }
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlAnyCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlAnyCollectionMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    private Namespace setupFragment(XMLRoot originalValue, XPathFragment xmlRootFragment, MarshalRecord marshalRecord) {
        Namespace generatedNamespace = null;
        String xpath = originalValue.getLocalName();
        if (originalValue.getNamespaceURI() != null) {
            xmlRootFragment.setNamespaceURI(originalValue.getNamespaceURI());
            String prefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(originalValue.getNamespaceURI());
            if (prefix == null || prefix.length() == 0) {
                prefix = marshalRecord.getNamespaceResolver().generatePrefix();
                generatedNamespace = new Namespace(prefix, xmlRootFragment.getNamespaceURI());
            }
            xpath = String.valueOf(prefix) + ':' + xpath;
        }
        xmlRootFragment.setXPath(xpath);
        return generatedNamespace;
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (value == null) {
            return false;
        }
        boolean wasXMLRoot = false;
        XPathFragment xmlRootFragment = null;
        Object originalValue = value;
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        if (this.xmlAnyCollectionMapping.usesXMLRoot() && value instanceof XMLRoot) {
            xmlRootFragment = new XPathFragment();
            xmlRootFragment.setNamespaceAware(marshalRecord.isNamespaceAware());
            wasXMLRoot = true;
            value = ((XMLRoot)value).getObject();
            if (value == null) {
                return false;
            }
        }
        UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
        if (value instanceof String) {
            this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, value, session, namespaceResolver);
        } else if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
        } else {
            Namespace generatedNamespace;
            AbstractSession childSession;
            try {
                childSession = marshaller.getXMLContext().getSession(value);
            }
            catch (XMLMarshalException xMLMarshalException) {
                this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, value, session, namespaceResolver);
                return true;
            }
            XMLDescriptor descriptor = (XMLDescriptor)childSession.getDescriptor(value);
            TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
            ArrayList<Namespace> extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session);
            if (wasXMLRoot && (generatedNamespace = this.setupFragment((XMLRoot)originalValue, xmlRootFragment, marshalRecord)) != null) {
                if (extraNamespaces == null) {
                    extraNamespaces = new ArrayList<Namespace>();
                }
                extraNamespaces.add(generatedNamespace);
            }
            String defaultRootElementString = descriptor.getDefaultRootElement();
            if (!wasXMLRoot && defaultRootElementString == null) {
                AbstractSessionLog.getLog().log(6, "marshal_warning_null_document_root_element", new Object[]{Helper.getShortClassName(this.getClass()), descriptor});
            } else {
                XPathFragment rootFragment;
                marshalRecord.beforeContainmentMarshal(value);
                if (xmlRootFragment != null) {
                    rootFragment = xmlRootFragment;
                } else {
                    rootFragment = new XPathFragment(defaultRootElementString);
                    if (rootFragment.getNamespaceURI() == null) {
                        String uri = descriptor.getNonNullNamespaceResolver().resolveNamespacePrefix(rootFragment.getPrefix());
                        rootFragment.setNamespaceURI(uri);
                    }
                }
                if (!wasXMLRoot) {
                    marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
                }
                this.getXPathNode().startElement(marshalRecord, rootFragment, object, childSession, marshalRecord.getNamespaceResolver(), objectBuilder, value);
                this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
                objectBuilder.addXsiTypeAndClassIndicatorIfRequired(marshalRecord, descriptor, descriptor, (XMLField)this.xmlAnyCollectionMapping.getField(), originalValue, value, wasXMLRoot, false);
                objectBuilder.buildRow(marshalRecord, value, session, marshaller, null, DatabaseMapping.WriteType.UNDEFINED);
                marshalRecord.afterContainmentMarshal(object, value);
                objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
                marshalRecord.endElement(rootFragment, namespaceResolver);
            }
        }
        return true;
    }

    private void marshalSimpleValue(XPathFragment xmlRootFragment, MarshalRecord marshalRecord, Object originalValue, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (xmlRootFragment != null) {
            QName qname = ((XMLRoot)originalValue).getSchemaType();
            value = marshalRecord.getValueToWrite(qname, value, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager());
            Namespace generatedNamespace = this.setupFragment((XMLRoot)originalValue, xmlRootFragment, marshalRecord);
            this.getXPathNode().startElement(marshalRecord, xmlRootFragment, object, session, namespaceResolver, null, null);
            if (generatedNamespace != null) {
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", generatedNamespace.getPrefix(), "xmlns:" + generatedNamespace.getPrefix(), generatedNamespace.getNamespaceURI());
            }
            this.updateNamespaces(qname, marshalRecord, null);
        }
        marshalRecord.characters((String)value);
        if (xmlRootFragment != null) {
            marshalRecord.endElement(xmlRootFragment, namespaceResolver);
        }
    }

    public XMLAnyCollectionMapping getMapping() {
        return this.xmlAnyCollectionMapping;
    }

    public boolean isWhitespaceAware() {
        return this.xmlAnyCollectionMapping.isMixedContent() && this.xmlAnyCollectionMapping.isWhitespacePreservedForMixedContent();
    }

    public boolean isAnyMappingNodeValue() {
        return true;
    }

    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public boolean isMixedContentNodeValue() {
        return this.xmlAnyCollectionMapping.isMixedContent();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

