/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import javax.xml.stream.XMLStreamReader;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class XMLStreamReaderReader
extends XMLReaderAdapter {
    private int depth = 0;
    private UnmarshalNamespaceContext unmarshalNamespaceContext = new UnmarshalNamespaceContext();
    private XMLStreamReaderAttributes indexedAttributeList = new XMLStreamReaderAttributes();
    private boolean qNameAware;
    private StreamReaderLocator locator;

    public XMLStreamReaderReader() {
    }

    public XMLStreamReaderReader(XMLUnmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    public void setContentHandler(ContentHandler handler) {
        super.setContentHandler(handler);
        Class<?> handlerClass = handler.getClass();
        if (handlerClass == UnmarshalRecord.class) {
            ((UnmarshalRecord)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = false;
        } else if (handlerClass == SAXUnmarshallerHandler.class) {
            ((SAXUnmarshallerHandler)handler).setUnmarshalNamespaceResolver(this.unmarshalNamespaceContext);
            this.qNameAware = true;
        } else {
            this.qNameAware = true;
        }
    }

    public void parse(InputSource input) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (input instanceof XMLStreamReaderInputSource) {
            XMLStreamReader xmlStreamReader = ((XMLStreamReaderInputSource)input).getXmlStreamReader();
            this.unmarshalNamespaceContext.setXmlStreamReader(xmlStreamReader);
            this.indexedAttributeList.setXmlStreamReader(xmlStreamReader);
            this.parse(xmlStreamReader);
        }
    }

    private void parse(XMLStreamReader xmlStreamReader) throws SAXException {
        this.locator = new StreamReaderLocator(xmlStreamReader);
        try {
            this.contentHandler.startDocument();
            this.parseEvent(xmlStreamReader, xmlStreamReader.getEventType());
            while (this.depth > 0) {
                int eventType = xmlStreamReader.next();
                this.parseEvent(xmlStreamReader, eventType);
            }
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void parseEvent(XMLStreamReader xmlStreamReader, int eventType) throws SAXException {
        switch (eventType) {
            case 1: {
                this.contentHandler.setDocumentLocator(this.locator);
                ++this.depth;
                String localName = xmlStreamReader.getLocalName();
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        this.contentHandler.startElement(namespaceURI, localName, localName, this.indexedAttributeList.reset());
                        break;
                    }
                    this.contentHandler.startElement(namespaceURI, localName, String.valueOf(prefix) + ':' + localName, this.indexedAttributeList.reset());
                    break;
                }
                this.contentHandler.startElement(namespaceURI, localName, null, this.indexedAttributeList.reset());
                break;
            }
            case 2: {
                --this.depth;
                String localName = xmlStreamReader.getLocalName();
                String namespaceURI = xmlStreamReader.getNamespaceURI();
                if ("".equals(namespaceURI)) {
                    namespaceURI = null;
                }
                if (this.qNameAware) {
                    String prefix = xmlStreamReader.getPrefix();
                    if (prefix == null || prefix.length() == 0) {
                        this.contentHandler.endElement(namespaceURI, localName, localName);
                        break;
                    }
                    this.contentHandler.endElement(namespaceURI, localName, String.valueOf(prefix) + ':' + localName);
                    break;
                }
                this.contentHandler.endElement(namespaceURI, localName, null);
                break;
            }
            case 3: {
                this.contentHandler.processingInstruction(xmlStreamReader.getPITarget(), xmlStreamReader.getPIData());
                break;
            }
            case 4: {
                this.parseCharactersEvent(xmlStreamReader);
                break;
            }
            case 5: {
                if (this.lexicalHandler == null) break;
                this.lexicalHandler.comment(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 6: {
                this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                xmlStreamReader.getText().toCharArray();
                if (this.lexicalHandler == null) {
                    this.parseCharactersEvent(xmlStreamReader);
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.parseCharactersEvent(xmlStreamReader);
                this.lexicalHandler.endCDATA();
            }
        }
    }

    protected void parseCharactersEvent(XMLStreamReader xmlStreamReader) throws SAXException {
        this.contentHandler.characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
    }

    private class StreamReaderLocator
    implements Locator2 {
        private XMLStreamReader reader;

        public StreamReaderLocator(XMLStreamReader r) {
            this.reader = r;
        }

        public String getPublicId() {
            return this.reader.getLocation().getPublicId();
        }

        public String getSystemId() {
            return this.reader.getLocation().getSystemId();
        }

        public int getLineNumber() {
            return this.reader.getLocation().getLineNumber();
        }

        public int getColumnNumber() {
            return this.reader.getLocation().getColumnNumber();
        }

        public String getXMLVersion() {
            return null;
        }

        public String getEncoding() {
            return null;
        }
    }

    private static class XMLStreamReaderAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private XMLStreamReader xmlStreamReader;

        private XMLStreamReaderAttributes() {
        }

        public void setXmlStreamReader(XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = xmlStreamReader;
        }

        protected XMLReaderAdapter.Attribute[] attributes() {
            if (this.attributes == null) {
                int attributeCount;
                int namespaceCount = this.xmlStreamReader.getNamespaceCount();
                if (namespaceCount + (attributeCount = this.xmlStreamReader.getAttributeCount()) == 0) {
                    this.attributes = NO_ATTRIBUTES;
                } else {
                    String localName;
                    String uri;
                    this.attributes = new XMLReaderAdapter.Attribute[attributeCount + namespaceCount];
                    int x = 0;
                    while (x < namespaceCount) {
                        String qName;
                        uri = "http://www.w3.org/2000/xmlns/";
                        localName = this.xmlStreamReader.getNamespacePrefix(x);
                        if (localName == null || localName.length() == 0) {
                            localName = "xmlns";
                            qName = "xmlns";
                        } else {
                            qName = "xmlns:" + localName;
                        }
                        String value = this.xmlStreamReader.getNamespaceURI(x);
                        this.attributes[x] = new XMLReaderAdapter.Attribute(uri, localName, qName, value);
                        ++x;
                    }
                    x = 0;
                    while (x < attributeCount) {
                        uri = this.xmlStreamReader.getAttributeNamespace(x);
                        localName = this.xmlStreamReader.getAttributeLocalName(x);
                        String prefix = this.xmlStreamReader.getAttributePrefix(x);
                        String qName = prefix == null || prefix.length() == 0 ? localName : String.valueOf(prefix) + ':' + localName;
                        String value = this.xmlStreamReader.getAttributeValue(x);
                        this.attributes[x + namespaceCount] = new XMLReaderAdapter.Attribute(uri, localName, qName, value);
                        ++x;
                    }
                }
            }
            return this.attributes;
        }

        public String getValue(String uri, String localName) {
            return this.xmlStreamReader.getAttributeValue(uri, localName);
        }
    }
}

