/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi.equinox;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.osgi.equinox.EquinoxWeaver;
import org.eclipse.persistence.jpa.equinox.weaving.IWeaver;
import org.eclipse.persistence.jpa.osgi.Activator;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class EquinoxInitializer
extends JPAInitializer {
    public EquinoxInitializer(ClassLoader bundleClassloader, Map m) {
        this.initializationClassloader = bundleClassloader;
    }

    public void checkWeaving(Map properties) {
        String weaving = EntityManagerFactoryProvider.getConfigPropertyAsString((String)"eclipselink.weaving", (Map)properties, null);
        if (weaving == null) {
            weaving = "false";
            properties.put("eclipselink.weaving", weaving);
        }
        if (weaving != null && (weaving.equalsIgnoreCase("false") || weaving.equalsIgnoreCase("static"))) {
            this.shouldCreateInternalLoader = false;
        }
    }

    protected ClassLoader createTempLoader(Collection classNames) {
        return this.initializationClassloader;
    }

    protected ClassLoader createTempLoader(Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
        return this.initializationClassloader;
    }

    public void registerTransformer(ClassTransformer transformer, PersistenceUnitInfo persistenceUnitInfo, Map properties) {
        if (transformer != null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", (Object)persistenceUnitInfo.getPersistenceUnitName());
            EquinoxWeaver weavingService = new EquinoxWeaver(transformer);
            Activator.getContext().registerService(IWeaver.class.getName(), (Object)weavingService, new Hashtable());
            AbstractSessionLog.getLog().log(2, "Registering Weaving Service");
        } else {
            AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
        }
    }
}

