/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model;

import org.eclipse.persistence.jpa.jpql.model.AbstractActualJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.model.IJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.model.query.EclipseLinkStateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.FuncExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.TreatExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;

public final class EclipseLinkActualJPQLQueryFormatter
extends AbstractActualJPQLQueryFormatter
implements EclipseLinkStateObjectVisitor {
    public EclipseLinkActualJPQLQueryFormatter(boolean exactMatch) {
        super(exactMatch);
    }

    public EclipseLinkActualJPQLQueryFormatter(boolean exactMatch, IJPQLQueryFormatter.IdentifierStyle style) {
        super(exactMatch, style);
    }

    public void visit(FuncExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            FuncExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "FUNC", "FUNC");
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            } else if (this.exactMatch && expression.hasSpaceAfterIdentifier()) {
                this.writer.append(" ");
            }
            if (stateObject.hasFunctionName()) {
                this.writer.append(stateObject.getQuotedFunctionName());
                if (this.shouldOutput(expression) || expression.hasComma()) {
                    this.writer.append(",");
                }
                if (this.shouldOutput(expression) || expression.hasSpaceAFterComma()) {
                    this.writer.append(" ");
                }
            }
            this.toStringChildren(stateObject, true);
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    public void visit(TreatExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            TreatExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "TREAT", "TREAT");
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            }
            stateObject.getJoinAssociationPathStateObject().accept(this);
            if (this.shouldOutput(expression) || expression.hasSpaceAfterCollectionValuedPathExpression()) {
                this.writer.append(" ");
            }
            if (stateObject.hasAs()) {
                this.appendIdentifier(expression != null ? expression.getActualAsIdentifier() : "AS", "AS");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterAs()) {
                    this.writer.append(" ");
                }
            }
            this.writer.append(stateObject.getEntityTypeName());
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }
}

