/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FuncExpression
extends AbstractSingleEncapsulatedExpression {
    private String functionName;
    private boolean hasComma;
    private boolean hasSpaceAFterComma;

    public FuncExpression(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<StringExpression> children) {
        if (this.functionName != null) {
            children.add(this.buildStringExpression(this.functionName));
        }
        if (this.hasComma) {
            children.add(this.buildStringExpression(','));
        }
        if (this.hasSpaceAFterComma) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    @Override
    public String encapsulatedExpressionBNF() {
        return "func_item";
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("func_expression");
    }

    public String getUnquotedFunctionName() {
        return ExpressionTools.unquote(this.functionName);
    }

    public boolean hasComma() {
        return this.hasComma;
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasFunctionName() || this.hasComma || super.hasEncapsulatedExpression();
    }

    public boolean hasFunctionName() {
        return ExpressionTools.stringIsNotEmpty(this.functionName);
    }

    public boolean hasSpaceAFterComma() {
        return this.hasSpaceAFterComma;
    }

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWith('\'')) {
            this.functionName = ExpressionTools.parseLiteral(wordParser);
            wordParser.moveForward(this.functionName);
            wordParser.skipLeadingWhitespace();
        } else {
            this.functionName = "";
        }
        this.hasComma = wordParser.startsWith(',');
        if (this.hasComma) {
            wordParser.moveForward(1);
        }
        this.hasSpaceAFterComma = wordParser.skipLeadingWhitespace() > 0;
        super.parseEncapsulatedExpression(wordParser, tolerant);
    }

    @Override
    protected String parseIdentifier(WordParser wordParser) {
        return "FUNC";
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.functionName != null) {
            writer.append(this.functionName);
        }
        if (this.hasComma) {
            writer.append(',');
        }
        if (this.hasSpaceAFterComma) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, actual);
    }
}

