/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NotExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasSpaceAfterNot;
    private String identifier;
    private JPQLQueryBNF queryBNF;

    public NotExpression(AbstractExpression parent, JPQLQueryBNF queryBNF) {
        super(parent, "NOT");
        this.queryBNF = queryBNF;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("NOT"));
        if (this.hasSpaceAfterNot) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.expression != null) {
            children.add(this.expression);
        }
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.queryBNF;
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasSpaceAfterNot() {
        return this.hasSpaceAfterNot;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("NOT");
        this.hasSpaceAfterNot = wordParser.skipLeadingWhitespace() > 0;
        this.expression = this.parse(wordParser, this.getQueryBNF(), tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasSpaceAfterNot) {
            writer.append(' ');
        }
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
        }
    }
}

