/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderByClause
extends AbstractExpression {
    private boolean hasSpaceAfterOrderBy;
    private String identifier;
    private AbstractExpression orderByItems;

    public OrderByClause(AbstractExpression parent) {
        super(parent, "ORDER BY");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getOrderByItems().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getOrderByItems());
    }

    @Override
    protected void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("ORDER BY"));
        if (this.hasSpaceAfterOrderBy) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.orderByItems != null) {
            children.add(this.orderByItems);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getOrderByItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, spaces, commas, true);
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    public Expression getOrderByItems() {
        if (this.orderByItems == null) {
            this.orderByItems = this.buildNullExpression();
        }
        return this.orderByItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("orderby_clause");
    }

    public boolean hasOrderByItems() {
        return this.orderByItems != null && !this.orderByItems.isNull();
    }

    public boolean hasSpaceAfterOrderBy() {
        return this.hasSpaceAfterOrderBy;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("ORDER BY");
        this.hasSpaceAfterOrderBy = wordParser.skipLeadingWhitespace() > 0;
        this.orderByItems = this.parse(wordParser, this.getQueryBNF("orderby_item"), tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : "ORDER BY");
        if (this.hasSpaceAfterOrderBy) {
            writer.append(' ');
        }
        if (this.orderByItems != null) {
            this.orderByItems.toParsedText(writer, actual);
        }
    }
}

