/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi.java;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaEntity;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaType;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaTypeRepository;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaManagedTypeProvider
implements IManagedTypeProvider {
    private Collection<IEmbeddable> embeddables;
    private Collection<IEntity> entities;
    private Map<String, IManagedType> managedTypes;
    private Collection<IMappedSuperclass> mappedSuperclasses;
    private IMappingBuilder<Member> mappingBuilder;
    private JavaTypeRepository typeRepository;

    public JavaManagedTypeProvider(IMappingBuilder<Member> mappingBuilder) {
        this.initialize(mappingBuilder);
    }

    public IEmbeddable addEmbeddable(Class<?> type) {
        IEmbeddable embeddable = this.buildEmbeddable(type);
        this.embeddables.add(embeddable);
        this.managedTypes.put(type.getName(), embeddable);
        return embeddable;
    }

    public IEntity addEntity(Class<?> type) {
        IEntity entity = this.buildEntity(type);
        this.entities.add(entity);
        this.managedTypes.put(type.getName(), entity);
        return entity;
    }

    public IMappedSuperclass addMappedSuperclass(Class<?> type) {
        IMappedSuperclass mappedSuperclass = this.buildMappedSuperclass(type);
        this.mappedSuperclasses.add(mappedSuperclass);
        this.managedTypes.put(type.getName(), mappedSuperclass);
        return mappedSuperclass;
    }

    protected IEmbeddable buildEmbeddable(Class<?> type) {
        return new JavaEmbeddable(this, (JavaType)this.getTypeRepository().getType((Class)type), this.mappingBuilder);
    }

    protected IEntity buildEntity(Class<?> type) {
        return new JavaEntity(this, (JavaType)this.getTypeRepository().getType((Class)type), this.mappingBuilder);
    }

    protected IMappedSuperclass buildMappedSuperclass(Class<?> type) {
        return new JavaMappedSuperclass(this, (JavaType)this.getTypeRepository().getType((Class)type), this.mappingBuilder);
    }

    @Override
    public IterableIterator<IEntity> entities() {
        return new CloneIterator<IEntity>(this.entities);
    }

    @Override
    public IEmbeddable getEmbeddable(IType type) {
        return this.getManagedType(this.embeddables, type.getName());
    }

    @Override
    public IEmbeddable getEmbeddable(String typeName) {
        return this.getManagedType(this.embeddables, typeName);
    }

    @Override
    public IEntity getEntity(IType type) {
        return this.getEntity(type.getName());
    }

    @Override
    public IEntity getEntity(String typeName) {
        return this.getManagedType(this.entities, typeName);
    }

    @Override
    public IEntity getEntityNamed(String entityName) {
        for (IEntity entity : this.entities) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    protected <T extends IManagedType> T getManagedType(Collection<T> managedTypes, String typeName) {
        for (IManagedType managedType : managedTypes) {
            if (!managedType.getType().getName().equals(typeName)) continue;
            return (T)managedType;
        }
        return null;
    }

    @Override
    public IManagedType getManagedType(IType type) {
        return this.getManagedType(this.managedTypes.values(), type.getName());
    }

    @Override
    public IManagedType getManagedType(String typeName) {
        return this.managedTypes.get(typeName);
    }

    @Override
    public IMappedSuperclass getMappedSuperclass(IType type) {
        return this.getManagedType(this.mappedSuperclasses, type.getName());
    }

    @Override
    public IMappedSuperclass getMappedSuperclass(String typeName) {
        return this.getManagedType(this.mappedSuperclasses, typeName);
    }

    protected IMappingBuilder<Member> getMappingBuilder() {
        return this.mappingBuilder;
    }

    @Override
    public JavaTypeRepository getTypeRepository() {
        if (this.typeRepository == null) {
            this.typeRepository = new JavaTypeRepository(this.getClass().getClassLoader());
        }
        return this.typeRepository;
    }

    protected void initialize() {
    }

    private void initialize(IMappingBuilder<Member> mappingBuilder) {
        Assert.isNotNull(mappingBuilder, "The IMappingBuilder cannot be null");
        this.mappingBuilder = mappingBuilder;
        this.entities = new LinkedList<IEntity>();
        this.embeddables = new LinkedList<IEmbeddable>();
        this.managedTypes = new HashMap<String, IManagedType>();
        this.mappedSuperclasses = new LinkedList<IMappedSuperclass>();
        this.initialize();
    }

    @Override
    public IterableIterator<IManagedType> managedTypes() {
        return new CloneIterator<IManagedType>(this.managedTypes.values());
    }
}

