/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.spi.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaConstructor;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaTypeDeclaration;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaType
implements IType {
    private Collection<IConstructor> constructors;
    private String[] enumConstants;
    private Class<?> type;
    private ITypeDeclaration typeDeclaration;
    private String typeName;
    private ITypeRepository typeRepository;

    public JavaType(ITypeRepository typeRepository, Class<?> type) {
        this(typeRepository, type.getName());
        this.type = type;
    }

    public JavaType(ITypeRepository typeRepository, String typeName) {
        this.typeName = typeName;
        this.typeRepository = typeRepository;
    }

    protected IConstructor buildConstructor(Constructor<?> constructor) {
        return new JavaConstructor(this, constructor);
    }

    protected Collection<IConstructor> buildConstructors() {
        if (this.type == null) {
            return Collections.emptyList();
        }
        Constructor<?>[] javaConstructors = this.type.getDeclaredConstructors();
        ArrayList<IConstructor> constructors = new ArrayList<IConstructor>(javaConstructors.length);
        Constructor<?>[] constructorArray = javaConstructors;
        int n = javaConstructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> javaConstructor = constructorArray[n2];
            constructors.add(this.buildConstructor(javaConstructor));
            ++n2;
        }
        return constructors;
    }

    protected String[] buildEnumConstants() {
        if (this.type == null || !this.type.isEnum()) {
            return ExpressionTools.EMPTY_STRING_ARRAY;
        }
        ?[] enumConstants = this.type.getEnumConstants();
        String[] names = new String[enumConstants.length];
        int index = enumConstants.length;
        while (--index >= 0) {
            names[index] = ((Enum)enumConstants[index]).name();
        }
        return names;
    }

    @Override
    public IterableIterator<IConstructor> constructors() {
        if (this.constructors == null) {
            this.constructors = this.buildConstructors();
        }
        return new CloneIterator<IConstructor>(this.constructors);
    }

    @Override
    public boolean equals(IType type) {
        return this == type ? true : this.typeName.equals(type.getName());
    }

    public boolean equals(Object object) {
        return this == object || this.equals((IType)object);
    }

    @Override
    public String[] getEnumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = this.buildEnumConstants();
        }
        return this.enumConstants;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = new JavaTypeDeclaration(this.typeRepository, this, null, this.type != null ? this.type.isArray() : false);
        }
        return this.typeDeclaration;
    }

    protected ITypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.type == null ? false : this.type.isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    @Override
    public boolean isAssignableTo(IType type) {
        if (this.type == null) {
            return false;
        }
        Class<?> otherType = ((JavaType)type).type;
        if (otherType == null) {
            return false;
        }
        return otherType.isAssignableFrom(this.type);
    }

    @Override
    public boolean isEnum() {
        return this.type != null && this.type.isEnum();
    }

    @Override
    public boolean isResolvable() {
        return this.type != null;
    }

    public String toString() {
        return this.typeName;
    }
}

