/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class NamedNativeQueryMetadata
extends NamedQueryMetadata {
    private MetadataClass m_resultClass;
    private String m_resultClassName;
    private String m_resultSetMapping;

    public NamedNativeQueryMetadata() {
        super("<named-native-query>");
    }

    public NamedNativeQueryMetadata(MetadataAnnotation namedNativeQuery, MetadataAccessor accessor) {
        super(namedNativeQuery, accessor);
        this.m_resultClass = this.getMetadataClass((String)namedNativeQuery.getAttributeString("resultClass"));
        this.m_resultSetMapping = (String)namedNativeQuery.getAttributeString("resultSetMapping");
    }

    protected NamedNativeQueryMetadata(String javaClassName) {
        super(javaClassName);
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedNativeQueryMetadata) {
            NamedNativeQueryMetadata query = (NamedNativeQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_resultClass, query.getResultClass())) {
                return false;
            }
            return this.valuesMatch(this.m_resultSetMapping, query.getResultSetMapping());
        }
        return false;
    }

    public MetadataClass getResultClass() {
        return this.m_resultClass;
    }

    public String getResultClassName() {
        return this.m_resultClassName;
    }

    public String getResultSetMapping() {
        return this.m_resultSetMapping;
    }

    protected boolean hasResultSetMapping(AbstractSession session) {
        if (this.m_resultSetMapping != null && !this.m_resultSetMapping.equals("")) {
            if (session.getProject().hasSQLResultSetMapping(this.m_resultSetMapping)) {
                return true;
            }
            throw ValidationException.invalidSQLResultSetMapping((String)this.m_resultSetMapping, (String)this.getName(), (Object)this.getLocation());
        }
        return false;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_resultClass = this.initXMLClassName(this.m_resultClassName);
    }

    public void process(AbstractSession session, ClassLoader loader) {
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.m_resultClass.isVoid()) {
            if (this.hasResultSetMapping(session)) {
                session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.m_resultSetMapping, this.getQuery(), hints, loader, session));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.getQuery(), hints, loader, session));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(MetadataHelper.getClassForName(this.m_resultClass.getName(), loader), this.getQuery(), hints, loader, session));
        }
    }

    public void setResultClass(MetadataClass resultClass) {
        this.m_resultClass = resultClass;
    }

    public void setResultClassName(String resultClassName) {
        this.m_resultClassName = resultClassName;
    }

    protected void setResultSetMapping(String resultSetMapping) {
        this.m_resultSetMapping = resultSetMapping;
    }
}

