/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class NamedStoredFunctionQueryMetadata
extends NamedStoredProcedureQueryMetadata {
    private StoredProcedureParameterMetadata returnParameter;

    public NamedStoredFunctionQueryMetadata() {
        super("<named-stored-function-query>");
    }

    public NamedStoredFunctionQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        this.returnParameter = new StoredProcedureParameterMetadata((MetadataAnnotation)namedStoredProcedureQuery.getAttribute("returnParameter"), accessor);
        this.setProcedureName((String)namedStoredProcedureQuery.getAttribute("functionName"));
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedStoredFunctionQueryMetadata) {
            NamedStoredFunctionQueryMetadata query = (NamedStoredFunctionQueryMetadata)objectToCompare;
            return this.valuesMatch(this.returnParameter, query.getReturnParameter());
        }
        return false;
    }

    public StoredProcedureParameterMetadata getReturnParameter() {
        return this.returnParameter;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.returnParameter, accessibleObject);
    }

    public void process(AbstractSession session, ClassLoader loader) {
        StoredFunctionCall call = new StoredFunctionCall();
        boolean callByIndex = this.callByIndex();
        for (StoredProcedureParameterMetadata parameter : this.getParameters()) {
            parameter.process((StoredProcedureCall)call, callByIndex, false);
        }
        if (this.getReturnParameter() != null) {
            this.getReturnParameter().process((StoredProcedureCall)call, callByIndex, true);
        }
        call.setProcedureName(this.getProcedureName());
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.getResultClass().isVoid()) {
            if (this.hasResultSetMapping(session)) {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), (StoredProcedureCall)call, hints, loader, session));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery((StoredProcedureCall)call, hints, loader, session));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), loader), (StoredProcedureCall)call, hints, loader, session));
        }
    }

    public void setReturnParameter(StoredProcedureParameterMetadata returnParameter) {
        this.returnParameter = returnParameter;
    }
}

