/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.mongo;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoAdapterMetaData;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnection;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoJCAConnectionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoRecordFactory;

public class MongoConnectionFactory
implements ConnectionFactory {
    public Connection getConnection() throws ResourceException {
        return this.getConnection(new MongoJCAConnectionSpec());
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        MongoJCAConnectionSpec connectionSpec = (MongoJCAConnectionSpec)spec;
        DB db = null;
        try {
            ArrayList<ServerAddress> servers = new ArrayList<ServerAddress>();
            for (int index = 0; index < connectionSpec.getHosts().size(); ++index) {
                String host = connectionSpec.getHosts().get(index);
                int port = ServerAddress.defaultPort();
                if (connectionSpec.getPorts().size() > index) {
                    port = connectionSpec.getPorts().get(index);
                }
                ServerAddress server = new ServerAddress(host, port);
                servers.add(server);
            }
            Mongo mongo = null;
            mongo = servers.isEmpty() ? new Mongo() : new Mongo(servers);
            db = mongo.getDB(connectionSpec.getDB());
            if (connectionSpec.getUser() != null && connectionSpec.getUser().length() > 0) {
                db.authenticate(connectionSpec.getUser(), connectionSpec.getPassword());
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(exception.toString());
            resourceException.initCause((Throwable)exception);
            throw resourceException;
        }
        return new MongoConnection(db, connectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new MongoAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new MongoRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }
}

