/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.mongo;

import java.util.Properties;
import javax.resource.cci.Connection;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoConnectionFactory;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoJCAConnectionSpec;

public class MongoConnectionSpec
extends EISConnectionSpec {
    public static String HOST = "mongo.host";
    public static String PORT = "mongo.port";
    public static String DB = "mongo.db";

    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        this.setConnectionFactory(new MongoConnectionFactory());
        String host = (String)properties.get(HOST);
        if (host == null) {
            host = "localhost";
        }
        String port = (String)properties.get(PORT);
        String db = (String)properties.get(DB);
        if (this.getConnectionSpec() == null) {
            if (host.indexOf(44) == -1) {
                MongoJCAConnectionSpec spec = new MongoJCAConnectionSpec();
                this.setConnectionSpec(spec);
            } else {
                int endIndex;
                MongoJCAConnectionSpec spec = new MongoJCAConnectionSpec();
                int startIndex = 0;
                while (startIndex < host.length() - 1) {
                    endIndex = host.indexOf(44, startIndex);
                    if (endIndex == -1) {
                        endIndex = host.length();
                    }
                    String nextHost = host.substring(startIndex, endIndex);
                    spec.getHosts().add(nextHost);
                    startIndex = endIndex + 1;
                }
                while (startIndex < port.length() - 1) {
                    endIndex = port.indexOf(44, startIndex);
                    if (endIndex == -1) {
                        endIndex = port.length();
                    }
                    String nextPort = port.substring(startIndex, endIndex);
                    spec.getPorts().add(new Integer(nextPort));
                    startIndex = endIndex + 1;
                }
                spec.setDB(db);
                this.setConnectionSpec(spec);
            }
        }
        return super.connectToDataSource(accessor, properties);
    }
}

