/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.nosql.adapters.nosql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import oracle.kv.Key;
import oracle.kv.Operation;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLConnection;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLOperation;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleNoSQLInteraction
implements Interaction {
    protected OracleNoSQLConnection connection;

    public OracleNoSQLInteraction(OracleNoSQLConnection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws ResourceException {
        throw ValidationException.operationNotSupported((String)"execute(InteractionSpec, Record, Record)");
    }

    public Record execute(InteractionSpec spec, Record record) throws ResourceException {
        block16: {
            if (!(spec instanceof OracleNoSQLInteractionSpec)) {
                throw EISException.invalidInteractionSpecType();
            }
            if (!(record instanceof OracleNoSQLRecord)) {
                throw EISException.invalidRecordType();
            }
            OracleNoSQLInteractionSpec noSqlSpec = (OracleNoSQLInteractionSpec)spec;
            OracleNoSQLRecord input = (OracleNoSQLRecord)record;
            try {
                OracleNoSQLOperation operation = noSqlSpec.getOperation();
                if (operation == OracleNoSQLOperation.GET) {
                    OracleNoSQLRecord output = new OracleNoSQLRecord();
                    for (Map.Entry entry : input.entrySet()) {
                        Key key = Key.createKey((List)this.createMajorKey(entry.getKey()));
                        SortedMap values = this.connection.getStore().multiGet(key, null, null);
                        if (values == null || values.isEmpty()) continue;
                        if (values.size() == 1) {
                            byte[] bytes = ((ValueVersion)values.values().iterator().next()).getValue().toByteArray();
                            output.put(entry.getKey(), this.convertBytes(bytes));
                            continue;
                        }
                        OracleNoSQLRecord nestedRecord = new OracleNoSQLRecord();
                        for (Map.Entry nestedEntry : values.entrySet()) {
                            byte[] bytes = ((ValueVersion)nestedEntry.getValue()).getValue().toByteArray();
                            OracleNoSQLRecord currentNestedRecord = nestedRecord;
                            List minorPaths = ((Key)nestedEntry.getKey()).getMinorPath();
                            if (minorPaths.isEmpty()) {
                                output.put(entry.getKey(), this.convertBytes(bytes));
                                continue;
                            }
                            for (int index = 0; index < minorPaths.size() - 1; ++index) {
                                String path = (String)minorPaths.get(index);
                                Object nextNestedRecord = currentNestedRecord.get(path);
                                if (!(nextNestedRecord instanceof OracleNoSQLRecord)) {
                                    nextNestedRecord = new OracleNoSQLRecord();
                                    currentNestedRecord.put(path, nextNestedRecord);
                                }
                                currentNestedRecord = (OracleNoSQLRecord)nextNestedRecord;
                            }
                            currentNestedRecord.put(minorPaths.get(minorPaths.size() - 1), this.convertBytes(bytes));
                        }
                        output.put(entry.getKey(), nestedRecord);
                    }
                    if (output.isEmpty()) {
                        return null;
                    }
                    return output;
                }
                if (operation == OracleNoSQLOperation.PUT) {
                    ArrayList<Operation> operations = new ArrayList<Operation>();
                    for (Map.Entry entry : input.entrySet()) {
                        Object inputValue = entry.getValue();
                        List majorKeys = this.createMajorKey(entry.getKey());
                        ArrayList<String> minorKeys = new ArrayList<String>();
                        this.putValues(inputValue, majorKeys, minorKeys, operations);
                    }
                    this.connection.getStore().execute(operations);
                    break block16;
                }
                if (operation == OracleNoSQLOperation.DELETE) {
                    for (Map.Entry entry : input.entrySet()) {
                        Key key = Key.createKey((List)this.createMajorKey(entry.getKey()));
                        this.connection.getStore().multiDelete(key, null, null);
                    }
                    break block16;
                }
                throw new ResourceException("Invalid NoSQL operation:" + (Object)((Object)operation));
            }
            catch (Exception exception) {
                ResourceException resourceException = new ResourceException(exception.toString());
                resourceException.initCause((Throwable)exception);
                throw resourceException;
            }
        }
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }

    protected List createMajorKey(Object key) {
        ArrayList<String> majorKeys = null;
        if (key instanceof List) {
            majorKeys = (ArrayList<String>)key;
        } else {
            majorKeys = new ArrayList<String>();
            String keyString = key.toString();
            if (keyString.length() > 2 && keyString.charAt(0) == '[' && keyString.charAt(keyString.length() - 1) == ']') {
                int startIndex = 1;
                while (startIndex < keyString.length() - 1) {
                    int endIndex = keyString.indexOf(44, startIndex);
                    if (endIndex == -1) {
                        endIndex = keyString.length() - 1;
                    }
                    String nextKey = keyString.substring(startIndex, endIndex);
                    majorKeys.add(nextKey);
                    startIndex = endIndex + 1;
                }
            } else {
                majorKeys.add(keyString);
            }
        }
        return majorKeys;
    }

    protected void putValues(Object element, List<String> majorKeys, List<String> minorKeys, List<Operation> operations) {
        if (element instanceof Collection) {
            element = ((List)element).get(0);
            for (Map.Entry nestedEntry : ((OracleNoSQLRecord)element).entrySet()) {
                ArrayList<String> nestedMinorKeys = new ArrayList<String>(minorKeys);
                nestedMinorKeys.add(nestedEntry.getKey().toString());
                this.putValues(nestedEntry.getValue(), majorKeys, nestedMinorKeys, operations);
            }
        } else if (element instanceof OracleNoSQLRecord) {
            for (Map.Entry nestedEntry : ((OracleNoSQLRecord)element).entrySet()) {
                ArrayList<String> nestedMinorKeys = new ArrayList<String>(minorKeys);
                nestedMinorKeys.add(nestedEntry.getKey().toString());
                this.putValues(nestedEntry.getValue(), majorKeys, nestedMinorKeys, operations);
            }
        } else {
            Key key = Key.createKey(majorKeys, minorKeys);
            Value value = this.createValue(element);
            operations.add(this.connection.getStore().getOperationFactory().createPut(key, value));
        }
    }

    protected Value createValue(Object data) {
        if (data == null) {
            data = new byte[0];
        } else if (!(data instanceof byte[])) {
            if (!(data instanceof String)) {
                data = data.toString();
            }
            data = ((String)data).getBytes();
        }
        return Value.createValue((byte[])((byte[])data));
    }

    protected Object convertBytes(byte[] bytes) {
        if (bytes.length > 0 && bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length == 0) {
            return null;
        }
        return bytes;
    }
}

