/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.nosql;

import java.util.Properties;
import javax.resource.cci.Connection;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLConnectionFactory;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLJCAConnectionSpec;

public class OracleNoSQLConnectionSpec
extends EISConnectionSpec {
    public static String STORE = "nosql.store";
    public static String HOST = "nosql.host";

    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        this.setConnectionFactory(new OracleNoSQLConnectionFactory());
        String store = (String)properties.get(STORE);
        String host = (String)properties.get(HOST);
        if (this.getConnectionSpec() == null) {
            if (host.indexOf(44) == -1) {
                OracleNoSQLJCAConnectionSpec spec = new OracleNoSQLJCAConnectionSpec(store, host);
                this.setConnectionSpec(spec);
            } else {
                OracleNoSQLJCAConnectionSpec spec = new OracleNoSQLJCAConnectionSpec();
                spec.setStore(store);
                int startIndex = 0;
                while (startIndex < host.length() - 1) {
                    int endIndex = host.indexOf(44, startIndex);
                    if (endIndex == -1) {
                        endIndex = host.length();
                    }
                    String nextHost = host.substring(startIndex, endIndex);
                    spec.getHosts().add(nextHost);
                    startIndex = endIndex + 1;
                }
                this.setConnectionSpec(spec);
            }
        }
        return super.connectToDataSource(accessor, properties);
    }
}

