/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.nosql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.eis.interactions.XMLInteraction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLOperation;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLRecord;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.queries.Call;
import org.w3c.dom.Element;

public class OracleNoSQLPlatform
extends EISPlatform {
    public static String OPERATION = "nosql.operation";

    public OracleNoSQLPlatform() {
        this.setShouldConvertDataToStrings(true);
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(false);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
    }

    public InteractionSpec buildInteractionSpec(EISInteraction interaction) {
        InteractionSpec spec = interaction.getInteractionSpec();
        if (spec == null) {
            OracleNoSQLInteractionSpec noSqlSpec = new OracleNoSQLInteractionSpec();
            Object operation = interaction.getProperty(OPERATION);
            if (operation == null) {
                throw new EISException("'" + OPERATION + "' property must be set on the query's interation.");
            }
            if (operation instanceof String) {
                operation = OracleNoSQLOperation.valueOf((String)operation);
            }
            noSqlSpec.setOperation((OracleNoSQLOperation)((Object)operation));
            spec = noSqlSpec;
        }
        return spec;
    }

    public AbstractRecord buildRow(Record record, EISInteraction interaction, EISAccessor accessor) {
        Object value;
        if (record == null) {
            return null;
        }
        OracleNoSQLRecord output = (OracleNoSQLRecord)record;
        if (output.size() == 1 && interaction.getQuery().getDescriptor() != null && (value = output.values().iterator().next()) instanceof OracleNoSQLRecord) {
            this.convertRecordBytesToString((OracleNoSQLRecord)value);
            output = (OracleNoSQLRecord)value;
        }
        OracleNoSQLRecord result = output;
        if (this.getRecordConverter() != null) {
            result = this.getRecordConverter().converterFromAdapterRecord((Record)output);
        }
        return interaction.buildRow((Record)result, accessor);
    }

    public Vector buildRows(Record record, EISInteraction interaction, EISAccessor accessor) {
        if (record == null) {
            return new Vector(0);
        }
        OracleNoSQLRecord output = (OracleNoSQLRecord)record;
        if (output.size() == 1 && interaction.getQuery().getDescriptor() != null) {
            Object value = output.values().iterator().next();
            if (value instanceof OracleNoSQLRecord) {
                Vector<AbstractRecord> rows = new Vector<AbstractRecord>(1);
                this.convertRecordBytesToString((OracleNoSQLRecord)value);
                rows.add(interaction.buildRow((Record)((OracleNoSQLRecord)value), accessor));
                return rows;
            }
            if (value instanceof Collection) {
                Vector<AbstractRecord> rows = new Vector<AbstractRecord>(((Collection)value).size());
                for (Object nestedValue : (Collection)value) {
                    if (!(nestedValue instanceof OracleNoSQLRecord)) continue;
                    rows.add(interaction.buildRow((Record)((OracleNoSQLRecord)nestedValue), accessor));
                }
                return rows;
            }
        }
        return interaction.buildRows(record, accessor);
    }

    protected void convertRecordBytesToString(OracleNoSQLRecord record) {
        for (Map.Entry entry : record.entrySet()) {
            if (entry.getValue() instanceof byte[]) {
                entry.setValue(new String((byte[])entry.getValue()));
                continue;
            }
            if (!(entry.getValue() instanceof OracleNoSQLRecord)) continue;
            this.convertRecordBytesToString((OracleNoSQLRecord)entry.getValue());
        }
    }

    public Record createInputRecord(EISInteraction interaction, EISAccessor accessor) {
        if (interaction instanceof XMLInteraction) {
            return super.createInputRecord(interaction, accessor);
        }
        if (interaction instanceof MappedInteraction) {
            MappedRecord input = (MappedRecord)interaction.createInputRecord(accessor);
            ClassDescriptor descriptor = interaction.getQuery().getDescriptor();
            if (descriptor == null) {
                if (this.getRecordConverter() != null) {
                    return this.getRecordConverter().converterToAdapterRecord((Record)input);
                }
                return input;
            }
            Object key = this.createMajorKey(descriptor, (AbstractRecord)new EISMappedRecord((Map)input, accessor), interaction, accessor);
            OracleNoSQLRecord record = new OracleNoSQLRecord();
            record.put(key, input);
            if (this.getRecordConverter() != null) {
                return this.getRecordConverter().converterToAdapterRecord((Record)record);
            }
            return record;
        }
        return super.createInputRecord(interaction, accessor);
    }

    public void setDOMInRecord(Element dom, Record record, EISInteraction interaction, EISAccessor accessor) {
        OracleNoSQLRecord noSqlRecord = (OracleNoSQLRecord)record;
        DOMRecord domRecord = new DOMRecord(dom);
        domRecord.setSession(interaction.getQuery().getSession());
        ClassDescriptor descriptor = interaction.getQuery().getDescriptor();
        if (descriptor == null) {
            throw new EISException("XMLInteraction is only valid for object queries, use MappedIneraction for native queries: " + interaction);
        }
        Object key = this.createMajorKey(descriptor, (AbstractRecord)domRecord, interaction, accessor);
        noSqlRecord.put(key, domRecord.transformToXML().getBytes());
    }

    protected Object createMajorKey(ClassDescriptor descriptor, AbstractRecord record, EISInteraction interaction, EISAccessor accessor) {
        Object id = descriptor.getObjectBuilder().extractPrimaryKeyFromRow(record, interaction.getQuery().getSession());
        ArrayList<String> key = new ArrayList<String>(descriptor.getPrimaryKeyFields().size() + 1);
        if (((EISDescriptor)descriptor).getDataTypeName().length() > 0) {
            key.add(((EISDescriptor)descriptor).getDataTypeName());
        }
        if (id != null) {
            if (id instanceof CacheId) {
                Object[] idValues;
                for (Object idValue : idValues = ((CacheId)id).getPrimaryKey()) {
                    String idString = (String)accessor.getDatasourcePlatform().getConversionManager().convertObject(idValue, String.class);
                    key.add(idString);
                }
            } else {
                String idString = (String)accessor.getDatasourcePlatform().getConversionManager().convertObject(id, String.class);
                key.add(idString);
            }
        }
        return key;
    }

    public AbstractRecord createDatabaseRowFromDOMRecord(Record record, EISInteraction call, EISAccessor accessor) {
        if (record == null) {
            return null;
        }
        EISDOMRecord domRecord = null;
        OracleNoSQLRecord noSqlRecord = (OracleNoSQLRecord)record;
        if (noSqlRecord.size() == 0) {
            return null;
        }
        if (noSqlRecord.size() == 1) {
            domRecord = new EISDOMRecord();
            Object value = noSqlRecord.values().iterator().next();
            String xml = null;
            xml = value instanceof byte[] ? new String((byte[])value) : (String)value;
            if (xml != null) {
                domRecord.transformFromXML(xml);
            }
        } else {
            domRecord = new EISDOMRecord();
            for (Map.Entry entry : noSqlRecord.entrySet()) {
                String value = (String)entry.getValue();
                String xml = null;
                xml = value instanceof byte[] ? new String((byte[])value) : value;
                if (xml == null) continue;
                EISDOMRecord dom = new EISDOMRecord();
                dom.transformFromXML(xml);
                domRecord.put(entry.getKey(), (Object)dom);
            }
        }
        return domRecord;
    }

    public void initializeDefaultQueries(DescriptorQueryManager queryManager, AbstractSession session) {
        XMLInteraction call;
        boolean isXML = ((EISDescriptor)queryManager.getDescriptor()).isXMLFormat();
        if (!queryManager.hasInsertQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.PUT);
            queryManager.setInsertCall((Call)call);
        }
        if (!queryManager.hasUpdateQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.PUT);
            queryManager.setUpdateCall((Call)call);
        }
        if (!queryManager.hasReadObjectQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.GET);
            for (DatabaseField field : queryManager.getDescriptor().getPrimaryKeyFields()) {
                call.addArgument(field.getName());
            }
            queryManager.setReadObjectCall((Call)call);
        }
        if (!queryManager.hasReadAllQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.GET);
            queryManager.setReadAllCall((Call)call);
        }
        if (!queryManager.hasDeleteQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.DELETE);
            for (DatabaseField field : queryManager.getDescriptor().getPrimaryKeyFields()) {
                call.addArgument(field.getName());
            }
            queryManager.setDeleteCall((Call)call);
        }
    }
}

