/* Generated By:JJTree&JavaCC: Do not edit this line. DDLParser.java */
/*******************************************************************************
 * Copyright (c) 2011 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Mike Norman - June 10 2011, created DDL parser package
 ******************************************************************************/
package org.eclipse.persistence.tools.oracleddl.parser;

//javase imports
import java.io.InputStream;
import java.util.List;
import java.util.HashMap;
import java.util.Map;

//metadata imports
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.BlobType;
import org.eclipse.persistence.tools.oracleddl.metadata.CharType;
import org.eclipse.persistence.tools.oracleddl.metadata.ClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DecimalType;
import org.eclipse.persistence.tools.oracleddl.metadata.DoubleType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FloatType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.IntervalDayToSecond;
import org.eclipse.persistence.tools.oracleddl.metadata.IntervalYearToMonth;
import org.eclipse.persistence.tools.oracleddl.metadata.LongType;
import org.eclipse.persistence.tools.oracleddl.metadata.LongRawType;
import org.eclipse.persistence.tools.oracleddl.metadata.NCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.NClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.NVarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.RawType;
import org.eclipse.persistence.tools.oracleddl.metadata.RealType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.TimeStampType;
import org.eclipse.persistence.tools.oracleddl.metadata.URowIdType;
import org.eclipse.persistence.tools.oracleddl.metadata.UnresolvedSizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.UnresolvedType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BFILE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BINARY_INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BINARY_FLOAT_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BINARY_DOUBLE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BOOLEAN_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.DATE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.MLSLABEL_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.NATURAL_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.PLS_INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.POSITIVE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.ROWID_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIGN_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIMPLE_INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIMPLE_DOUBLE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIMPLE_FLOAT_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SMALLINT_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SYS_REFCURSOR_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.TIME_TYPE;

@SuppressWarnings("all")
public class DDLParser/*@bgen(jjtree)*/implements DDLParserTreeConstants, DDLParserConstants {/*@bgen(jjtree)*/
  protected JJTDDLParserState jjtree = new JJTDDLParserState();
    protected Map<String, DatabaseType> localTypes = new HashMap<String, DatabaseType>();

    protected DatabaseTypesRepository typesRepository = new DatabaseTypesRepository();

    public DDLParser() {
        super();
    }

    public void setTypesRepository(DatabaseTypesRepository typesRepository) {
        this.typesRepository = typesRepository;
    }
    public DatabaseTypesRepository getTypesRepository() {
        return typesRepository;
    }

// stripped-down version of PLSQL grammar: only parses package/top-level DDL specifications

// PLSQLPackage at 'top-level'
  final public PLSQLPackageType parsePLSQLPackage() throws ParseException {
 String schema = null;
 String packageName = null;
 PLSQLPackageType packageType = new PLSQLPackageType();
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OR:
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
      break;
    default:
      ;
    }
    jj_consume_token(K_PACKAGE);
    if (jj_2_1(2)) {
      schema = OracleObjectName();
      jj_consume_token(O_DOT);
    } else {
      ;
    }
    packageName = OracleObjectName();
          if (schema != null) {
            packageType.setSchema(schema);
          }
          packageType.setPackageName(packageName);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AUTHID:
      jj_consume_token(K_AUTHID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CURRENT_USER:
      case K_DEFINER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_CURRENT_USER:
          jj_consume_token(K_CURRENT_USER);
          break;
        case K_DEFINER:
          jj_consume_token(K_DEFINER);
          break;
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AS:
    case K_IS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_AS:
        jj_consume_token(K_AS);
        break;
      case K_IS:
        jj_consume_token(K_IS);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CURSOR:
      case K_FUNCTION:
      case K_PRAGMA:
      case K_PROCEDURE:
      case K_TYPE:
      case S_IDENTIFIER:
        ;
        break;
      default:
        break label_1;
      }
      packageDeclaration(packageType);
    }
    jj_consume_token(K_END);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
      OracleObjectName();
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
    jj_consume_token(0);
      typesRepository.setDatabaseType(packageName, packageType);
      {if (true) return packageType;}
    throw new Error("Missing return statement in function");
  }

// procedure at 'top-level'
  final public ProcedureType parseTopLevelProcedure() throws ParseException {
 ProcedureType procedureType = null;
 String schema = null;
 String procedureName = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OR:
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
      break;
    default:
      ;
    }
    jj_consume_token(K_PROCEDURE);
    if (jj_2_2(2)) {
      schema = OracleObjectName();
      jj_consume_token(O_DOT);
    } else {
      ;
    }
    procedureName = OracleObjectName();
           procedureType = new ProcedureType(procedureName);
              if (schema != null) {
                  procedureType.setSchema(schema);
              }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(procedureType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AS:
    case K_IS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_AS:
        jj_consume_token(K_AS);
        break;
      case K_IS:
        jj_consume_token(K_IS);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    skipToEnd();
      typesRepository.setDatabaseType(procedureName, procedureType);
      {if (true) return procedureType;}
    throw new Error("Missing return statement in function");
  }

// function at 'top-level'
  final public FunctionType parseTopLevelFunction() throws ParseException {
 FunctionType functionType = null;
 String schema = null;
 String functionName = null;
 ArgumentType returnType = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OR:
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
      break;
    default:
      ;
    }
    jj_consume_token(K_FUNCTION);
    if (jj_2_3(2)) {
      schema = OracleObjectName();
      jj_consume_token(O_DOT);
    } else {
      ;
    }
    functionName = OracleObjectName();
              functionType = new FunctionType(functionName);
          if (schema != null) {
              functionType.setSchema(schema);
          }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(functionType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    returnType = functionReturnSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AS:
    case K_IS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_AS:
        jj_consume_token(K_AS);
        break;
      case K_IS:
        jj_consume_token(K_IS);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    skipToEnd();
      functionType.setReturnArgument(returnType);
      typesRepository.setDatabaseType(functionName, functionType);
      {if (true) return functionType;}
    throw new Error("Missing return statement in function");
  }

// table at 'top-level'
  final public TableType parseTable() throws ParseException {
TableType tableType = null;
String schema = null;
String tableName = null;
Token iot = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_GLOBAL:
      jj_consume_token(K_GLOBAL);
      jj_consume_token(K_TEMPORARY);
      break;
    default:
      ;
    }
    jj_consume_token(K_TABLE);
    if (jj_2_4(2)) {
      schema = OracleObjectName();
      jj_consume_token(O_DOT);
    } else {
      ;
    }
    tableName = OracleObjectName();
            tableType = new TableType(tableName);
                    if (schema != null) {
                         tableType.setSchema(schema);
                    }
    jj_consume_token(O_OPENPAREN);
    columnDeclarations(tableType);
    jj_consume_token(O_CLOSEPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ORGANIZATION:
      jj_consume_token(K_ORGANIZATION);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_INDEX:
      iot = jj_consume_token(K_INDEX);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOCOMPRESS:
      jj_consume_token(K_NOCOMPRESS);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OVERFLOW:
      jj_consume_token(K_OVERFLOW);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ON:
      jj_consume_token(K_ON);
      jj_consume_token(K_COMMIT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_DELETE:
      case K_PRESERVE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_DELETE:
          jj_consume_token(K_DELETE);
          break;
        case K_PRESERVE:
          jj_consume_token(K_PRESERVE);
          break;
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        ;
      }
      jj_consume_token(K_ROWS);
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
    jj_consume_token(0);
         if (iot != null) {
             tableType.setIOT(true);
         }
         typesRepository.setDatabaseType(tableName, tableType);
         {if (true) return tableType;}
    throw new Error("Missing return statement in function");
  }

// type at 'top-level'
  final public CompositeDatabaseType parseType() throws ParseException {
 CompositeDatabaseType databaseType = null;
DatabaseType enclosedType = null;
 String schema = null;
 String typeName = null;
 Token vsize = null;
 boolean varray = false;
 boolean nestedTable = false;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OR:
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
      break;
    default:
      ;
    }
    jj_consume_token(K_TYPE);
    if (jj_2_5(2)) {
      schema = OracleObjectName();
      jj_consume_token(O_DOT);
    } else {
      ;
    }
    typeName = OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_FORCE:
      jj_consume_token(K_FORCE);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OID:
      jj_consume_token(K_OID);
      jj_consume_token(S_CHAR_LITERAL);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AUTHID:
      jj_consume_token(K_AUTHID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CURRENT_USER:
      case K_DEFINER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_CURRENT_USER:
          jj_consume_token(K_CURRENT_USER);
          break;
        case K_DEFINER:
          jj_consume_token(K_DEFINER);
          break;
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AS:
      jj_consume_token(K_AS);
      break;
    case K_IS:
      jj_consume_token(K_IS);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OBJECT:
    case K_TABLE:
    case K_VARRAY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_OBJECT:
        jj_consume_token(K_OBJECT);
        jj_consume_token(O_OPENPAREN);
                databaseType = new ObjectType(typeName);
                if (schema != null) {
                    ((ObjectType)databaseType).setSchema(schema);
                }
        columnDeclarations(databaseType);
        jj_consume_token(O_CLOSEPAREN);
        break;
      case K_VARRAY:
        jj_consume_token(K_VARRAY);
        jj_consume_token(O_OPENPAREN);
        vsize = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        jj_consume_token(K_OF);
                databaseType = new VArrayType(typeName);
                if (schema != null) {
                    ((VArrayType)databaseType).setSchema(schema);
                }
                if (vsize != null) {
                    Long size = Long.decode(vsize.image);
                    ((VArrayType)databaseType).setSize(size);
                }
        enclosedType = columnTypeSpec(databaseType);
        break;
      case K_TABLE:
        jj_consume_token(K_TABLE);
        jj_consume_token(K_OF);
                databaseType = new ObjectTableType(typeName);
                if (schema != null) {
                    ((ObjectTableType)databaseType).setSchema(schema);
                }
        enclosedType = columnTypeSpec(databaseType);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_FINAL:
    case K_INSTANTIABLE:
    case K_NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_NOT:
        jj_consume_token(K_NOT);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_FINAL:
        jj_consume_token(K_FINAL);
        break;
      case K_INSTANTIABLE:
        jj_consume_token(K_INSTANTIABLE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_SEMICOLON:
      jj_consume_token(O_SEMICOLON);
      break;
    default:
      ;
    }
    jj_consume_token(0);
        if (enclosedType != null) {
            ((CompositeDatabaseType)databaseType).addCompositeType(enclosedType);
        }
        typesRepository.setDatabaseType(typeName, databaseType);
        {if (true) return databaseType;}
    throw new Error("Missing return statement in function");
  }

  final public void columnDeclarations(CompositeDatabaseType enclosingType) throws ParseException {
    columnDeclaration(enclosingType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      columnDeclarations(enclosingType);
      break;
    default:
      ;
    }
  }

  final public void columnDeclaration(CompositeDatabaseType enclosingType) throws ParseException {
 String s = null;
 String pk = null;
 boolean notNull = false;
 DatabaseType columnType = null;
 FieldType column = null;
    if (jj_2_6(2)) {
      s = OracleObjectName();
           column = new FieldType(s);
           if (enclosingType != null) {
               enclosingType.addCompositeType(column);
           }
      columnType = columnTypeSpec(enclosingType);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_NOT:
        jj_consume_token(K_NOT);
        jj_consume_token(K_NULL);
        jj_consume_token(K_ENABLE);
                                                                                 notNull = true;
        break;
      default:
        ;
      }
    } else if (jj_2_7(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CONSTRAINT:
        jj_consume_token(K_CONSTRAINT);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
        OracleObjectName();
        break;
      default:
        ;
      }
      jj_consume_token(K_PRIMARY);
      jj_consume_token(K_KEY);
      jj_consume_token(O_OPENPAREN);
      pkList((TableType)enclosingType);
      jj_consume_token(O_CLOSEPAREN);
      jj_consume_token(K_ENABLE);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
      if (column != null) {
              column.setDataType(columnType);
              if (columnType instanceof UnresolvedType) {
                  ((UnresolvedType)columnType).setOwningType(column);
              }
              if (notNull) {
                  column.setNotNull();
              }
          }
  }

  final public DatabaseType columnTypeSpec(CompositeDatabaseType enclosingType) throws ParseException {
 String s = null;
 Token t = null;
 DatabaseType dt = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_BFILE:
    case K_BINARY_DOUBLE:
    case K_BINARY_FLOAT:
    case K_BINARY_INTEGER:
    case K_BLOB:
    case K_BOOLEAN:
    case K_CHAR:
    case K_CHARACTER:
    case K_CLOB:
    case K_DATE:
    case K_DEC:
    case K_DECIMAL:
    case K_DOUBLE:
    case K_FLOAT:
    case K_INT:
    case K_INTEGER:
    case K_INTERVAL:
    case K_LONG:
    case K_MLSLABEL:
    case K_NATIONAL:
    case K_NATURAL:
    case K_NCHAR:
    case K_NCLOB:
    case K_NUMBER:
    case K_NUMERIC:
    case K_NVARCHAR2:
    case K_NVARCHAR:
    case K_PLS_INTEGER:
    case K_POSITIVE:
    case K_RAW:
    case K_REAL:
    case K_ROWID:
    case K_SIGNTYPE:
    case K_SIMPLE_INTEGER:
    case K_SIMPLE_DOUBLE:
    case K_SIMPLE_FLOAT:
    case K_SMALLINT:
    case K_SYS_REFCURSOR:
    case K_TIME:
    case K_TIMESTAMP:
    case K_UROWID:
    case K_VARCHAR2:
    case K_VARCHAR:
      dt = datatype();
      break;
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
      s = columnSpec();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        t = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      if (s != null) {
          for (String typeName : localTypes.keySet()) {
              if (typeName.equals(s)) {
                  dt = localTypes.get(s);
                  break;
              }
          }
          if (dt == null) {
              if (t != null) {
                  Long size = Long.decode(t.image);
                  dt = new UnresolvedSizedType(s, size);
              }
              else {
                  dt = new UnresolvedType(s);
              }
              ((UnresolvedType)dt).setOwningType(enclosingType);
          }
      }
      {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public void pkList(TableType tableType) throws ParseException {
    pk(tableType);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_COMMA:
        ;
        break;
      default:
        break label_2;
      }
      jj_consume_token(O_COMMA);
      pk(tableType);
    }
  }

  final public void pk(TableType tableType) throws ParseException {
String s = null;
    s = OracleObjectName();
       List<FieldType> columns = tableType.getColumns();
       for (FieldType column : columns) {
            if (column.getFieldName().equals(s)) {
                column.setPk();
                break;
            }
       }
  }

  final public void packageDeclaration(PLSQLPackageType packageType) throws ParseException {
    if (jj_2_8(2)) {
      variableDeclaration(packageType);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_TYPE:
        typeDeclaration(packageType);
        break;
      case K_CURSOR:
        cursorDeclaration(packageType);
        break;
      case K_PROCEDURE:
        procedureSpec(packageType);
        break;
      case K_FUNCTION:
        functionSpec(packageType);
        break;
      case S_IDENTIFIER:
        exceptionDeclaration(packageType);
        break;
      case K_PRAGMA:
        pragmaDeclaration(packageType);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void variableDeclaration(PLSQLPackageType packageType) throws ParseException {
    jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_CONSTANT:
      jj_consume_token(K_CONSTANT);
      break;
    default:
      ;
    }
    typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
      jj_consume_token(K_NULL);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_DEFAULT:
    case O_ASSIGN:
      variableDefaultAssignment();
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
  }

  final public void variableDefaultAssignment() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
      jj_consume_token(O_ASSIGN);
      break;
    case K_DEFAULT:
      jj_consume_token(K_DEFAULT);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    skipToSemiColon();
  }

  final public DatabaseType datatype() throws ParseException {
 Token t = null;
 DatabaseType dt = null;
 Token precision = null;
 Long sl;
 Long pl;
 Token scale = null;
 Token withTimeZone = null;
 Token withLocalTimeZone = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_BINARY_INTEGER:
      jj_consume_token(K_BINARY_INTEGER);
                          {if (true) return BINARY_INTEGER_TYPE;}
      break;
    case K_BINARY_FLOAT:
      jj_consume_token(K_BINARY_FLOAT);
                          {if (true) return BINARY_FLOAT_TYPE;}
      break;
    case K_BINARY_DOUBLE:
      jj_consume_token(K_BINARY_DOUBLE);
                          {if (true) return BINARY_DOUBLE_TYPE;}
      break;
    case K_NATURAL:
      jj_consume_token(K_NATURAL);
                          {if (true) return NATURAL_TYPE;}
      break;
    case K_POSITIVE:
      jj_consume_token(K_POSITIVE);
                          {if (true) return POSITIVE_TYPE;}
      break;
    case K_SIGNTYPE:
      jj_consume_token(K_SIGNTYPE);
                          {if (true) return SIGN_TYPE;}
      break;
    case K_DEC:
    case K_DECIMAL:
    case K_NUMBER:
    case K_NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_NUMBER:
        t = jj_consume_token(K_NUMBER);
        break;
      case K_NUMERIC:
        t = jj_consume_token(K_NUMERIC);
        break;
      case K_DECIMAL:
        t = jj_consume_token(K_DECIMAL);
        break;
      case K_DEC:
        t = jj_consume_token(K_DEC);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_ASTERISK:
        case S_NUMBER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_ASTERISK:
            precision = jj_consume_token(O_ASTERISK);
            break;
          case S_NUMBER:
            precision = jj_consume_token(S_NUMBER);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_COMMA:
            ;
            break;
          default:
            break label_3;
          }
          jj_consume_token(O_COMMA);
          scale = jj_consume_token(S_NUMBER);
        }
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
            if (t.kind == K_NUMBER || t.kind == K_NUMERIC) {
                if (precision != null && precision.image.equals("*")) {
                    precision = null;
                }
                if (precision == null) {
                    if (scale != null && scale.image.equals("0")) {
                        dt = INTEGER_TYPE;
                    }
                    else {
                        dt = new NumericType();
                    }
                }
                    else {
                        pl = Long.decode(precision.image);
                        if (scale == null) {
                        dt = new NumericType(pl);
                    }
                    else {
                        sl = Long.decode(scale.image);
                        dt = new NumericType(pl, sl);
                        }
                    }
                //sometimes need to know difference between NUMERIC and NUMBER
                if (dt != INTEGER_TYPE && t.kind == K_NUMBER) {
                    ((NumericType)dt).setNumberSynonym(true);
                }
            }
            else  if (t.kind == K_DECIMAL || t.kind == K_DEC) {
                if (precision != null && precision.image.equals("*")) {
                    precision = null;
                }
                if (precision == null) {
                    dt = new DecimalType();
                }
                else {
                    pl = Long.decode(precision.image);
                    if (scale == null) {
                        dt = new DecimalType(pl);
                    }
                    else {
                        sl = Long.decode(scale.image);
                        dt = new DecimalType(pl, sl);
                    }
                }
            }
            {if (true) return dt;}
      break;
    case K_LONG:
      jj_consume_token(K_LONG);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_RAW:
        t = jj_consume_token(K_RAW);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
              if (t == null) {
              if (precision == null) {
                  dt = new LongType();
              }
              else {
                  pl = Long.decode(precision.image);
                  dt = new LongType(pl);
              }
              }
              else {
              if (precision == null) {
                  dt = new LongRawType();
              }
              else {
                  pl = Long.decode(precision.image);
                  dt = new LongRawType(pl);
              }
            }
            {if (true) return dt;}
      break;
    case K_RAW:
      jj_consume_token(K_RAW);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
            if (precision == null) {
                dt = new RawType();
            }
            else {
                pl = Long.decode(precision.image);
                dt = new RawType(pl);
            }
            {if (true) return dt;}
      break;
    case K_BOOLEAN:
      jj_consume_token(K_BOOLEAN);
                    {if (true) return BOOLEAN_TYPE;}
      break;
    case K_DATE:
      jj_consume_token(K_DATE);
                 {if (true) return DATE_TYPE;}
      break;
    default:
      if (jj_2_17(2)) {
        jj_consume_token(K_INTERVAL);
        jj_consume_token(K_DAY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
          jj_consume_token(O_OPENPAREN);
          precision = jj_consume_token(S_NUMBER);
          jj_consume_token(O_CLOSEPAREN);
          break;
        default:
          ;
        }
        jj_consume_token(K_TO);
        jj_consume_token(K_SECOND);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
          jj_consume_token(O_OPENPAREN);
          scale = jj_consume_token(S_NUMBER);
          jj_consume_token(O_CLOSEPAREN);
          break;
        default:
          ;
        }
                if (precision == null) {
                dt = new IntervalDayToSecond();
            }
            else {
                pl = Long.decode(precision.image);
                if (scale == null) {
                    dt = new IntervalDayToSecond(pl);
                }
                else {
                    sl = Long.decode(scale.image);
                    dt = new IntervalDayToSecond(pl, sl);
                }
            }
            {if (true) return dt;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_INTERVAL:
          jj_consume_token(K_INTERVAL);
          jj_consume_token(K_YEAR);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          jj_consume_token(K_TO);
          jj_consume_token(K_MONTH);
            if (precision == null) {
                dt = new IntervalYearToMonth();
            }
            else {
                pl = Long.decode(precision.image);
                dt = new IntervalYearToMonth(pl);
            }
            {if (true) return dt;}
          break;
        case K_TIME:
          jj_consume_token(K_TIME);
                 {if (true) return TIME_TYPE;}
          break;
        case K_TIMESTAMP:
          jj_consume_token(K_TIMESTAMP);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_WITH:
            jj_consume_token(K_WITH);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case K_LOCAL:
              withLocalTimeZone = jj_consume_token(K_LOCAL);
              break;
            default:
              ;
            }
            withTimeZone = jj_consume_token(K_TIME);
            jj_consume_token(K_ZONE);
            break;
          default:
            ;
          }
          if (precision == null) {
              dt = new TimeStampType();
          }
          else {
              pl = Long.decode(precision.image);
              dt = new TimeStampType(pl);
          }
          if (withLocalTimeZone !=  null) {
              ((TimeStampType)dt).setWithLocalTimeZone();
          }
          else if (withTimeZone != null) {
              ((TimeStampType)dt).setWithTimeZone();
          }
          {if (true) return dt;}
          break;
        case K_INTEGER:
          jj_consume_token(K_INTEGER);
                     {if (true) return INTEGER_TYPE;}
          break;
        case K_INT:
          jj_consume_token(K_INT);
                     {if (true) return INTEGER_TYPE;}
          break;
        case K_SMALLINT:
          jj_consume_token(K_SMALLINT);
                     {if (true) return SMALLINT_TYPE;}
          break;
        case K_FLOAT:
          jj_consume_token(K_FLOAT);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (precision == null) {
              {if (true) return new FloatType();}
          }
          else {
              pl = Long.decode(precision.image);
              FloatType ft = new FloatType(pl);
              {if (true) return ft;}
          }
          break;
        case K_REAL:
          jj_consume_token(K_REAL);
                 {if (true) return new RealType();}
          break;
        case K_MLSLABEL:
          jj_consume_token(K_MLSLABEL);
                     {if (true) return MLSLABEL_TYPE;}
          break;
        case K_PLS_INTEGER:
          jj_consume_token(K_PLS_INTEGER);
                        {if (true) return PLS_INTEGER_TYPE;}
          break;
        case K_SIMPLE_INTEGER:
          jj_consume_token(K_SIMPLE_INTEGER);
                           {if (true) return SIMPLE_INTEGER_TYPE;}
          break;
        case K_SIMPLE_FLOAT:
          jj_consume_token(K_SIMPLE_FLOAT);
                         {if (true) return SIMPLE_FLOAT_TYPE;}
          break;
        case K_SIMPLE_DOUBLE:
          jj_consume_token(K_SIMPLE_DOUBLE);
                          {if (true) return SIMPLE_DOUBLE_TYPE;}
          break;
        case K_SYS_REFCURSOR:
          jj_consume_token(K_SYS_REFCURSOR);
                           {if (true) return SYS_REFCURSOR_TYPE;}
          break;
        case K_BLOB:
          jj_consume_token(K_BLOB);
                  {if (true) return new BlobType();}
          break;
        case K_NCLOB:
          jj_consume_token(K_NCLOB);
                  {if (true) return new NClobType();}
          break;
        case K_BFILE:
          jj_consume_token(K_BFILE);
                   {if (true) return BFILE_TYPE;}
          break;
        case K_ROWID:
          jj_consume_token(K_ROWID);
                  {if (true) return ROWID_TYPE;}
          break;
        case K_UROWID:
          jj_consume_token(K_UROWID);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (precision == null) {
              {if (true) return new URowIdType();}
          }
          else {
              pl = Long.decode(precision.image);
              {if (true) return new URowIdType(pl);}
          }
          break;
        case K_DOUBLE:
          jj_consume_token(K_DOUBLE);
          jj_consume_token(K_PRECISION);
                                 {if (true) return new DoubleType();}
          break;
        case K_CHAR:
          jj_consume_token(K_CHAR);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_VARYING:
            t = jj_consume_token(K_VARYING);
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case K_BYTE:
            case K_CHAR:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case K_BYTE:
                jj_consume_token(K_BYTE);
                break;
              case K_CHAR:
                jj_consume_token(K_CHAR);
                break;
              default:
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              ;
            }
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (jj_2_10(2)) {
            jj_consume_token(K_CHARACTER);
            jj_consume_token(K_SET);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:
              if (jj_2_9(2)) {
                jj_consume_token(S_IDENTIFIER);
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case S_IDENTIFIER:
                case S_QUOTED_IDENTIFIER:
                  columnSpec();
                  jj_consume_token(K_CHARSET);
                  break;
                default:
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
              break;
            default:
              ;
            }
          } else {
            ;
          }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new CharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new CharType(pl);}
              }
          }
          else {
              // ANSI syntax for VARCHAR2
              if (precision == null) {
                  {if (true) return new VarChar2Type();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new VarChar2Type(pl);}
              }
          }
          break;
        case K_VARCHAR:
          jj_consume_token(K_VARCHAR);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_VARYING:
            jj_consume_token(K_VARYING);
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case K_BYTE:
            case K_CHAR:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case K_BYTE:
                jj_consume_token(K_BYTE);
                break;
              case K_CHAR:
                jj_consume_token(K_CHAR);
                break;
              default:
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              ;
            }
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (jj_2_12(2)) {
            jj_consume_token(K_CHARACTER);
            jj_consume_token(K_SET);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:
              if (jj_2_11(2)) {
                jj_consume_token(S_IDENTIFIER);
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case S_IDENTIFIER:
                case S_QUOTED_IDENTIFIER:
                  columnSpec();
                  jj_consume_token(K_CHARSET);
                  break;
                default:
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
              break;
            default:
              ;
            }
          } else {
            ;
          }
          if (precision == null) {
              {if (true) return new VarCharType();}
          }
          else {
              pl = Long.decode(precision.image);
              {if (true) return new VarCharType(pl);}
          }
          break;
        case K_VARCHAR2:
          jj_consume_token(K_VARCHAR2);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_VARYING:
            jj_consume_token(K_VARYING);
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case K_BYTE:
            case K_CHAR:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case K_BYTE:
                jj_consume_token(K_BYTE);
                break;
              case K_CHAR:
                jj_consume_token(K_CHAR);
                break;
              default:
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              ;
            }
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (jj_2_14(2)) {
            jj_consume_token(K_CHARACTER);
            jj_consume_token(K_SET);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:
              if (jj_2_13(2)) {
                jj_consume_token(S_IDENTIFIER);
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case S_IDENTIFIER:
                case S_QUOTED_IDENTIFIER:
                  columnSpec();
                  jj_consume_token(K_CHARSET);
                  break;
                default:
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
              break;
            default:
              ;
            }
          } else {
            ;
          }
            if (precision == null) {
                {if (true) return new VarChar2Type();}
            }
            else {
                pl = Long.decode(precision.image);
                {if (true) return new VarChar2Type(pl);}
            }
          break;
        case K_CHARACTER:
          jj_consume_token(K_CHARACTER);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_VARYING:
            t = jj_consume_token(K_VARYING);
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new CharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new CharType(pl);}
              }
          }
          else {
              // ANSI syntax for VARCHAR
              if (precision == null) {
                  {if (true) return new VarCharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new VarCharType(pl);}
              }
          }
          break;
        case K_NCHAR:
          jj_consume_token(K_NCHAR);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_VARYING:
            t = jj_consume_token(K_VARYING);
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new NCharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NCharType(pl);}
              }
          }
          else {
              // ANSI syntax for NVARCHAR2
              if (precision == null) {
                  {if (true) return new NVarChar2Type();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NVarChar2Type(pl);}
              }
          }
          break;
        case K_NVARCHAR:
          jj_consume_token(K_NVARCHAR);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
            if (precision == null) {
                {if (true) return new NVarChar2Type();}
            }
            else {
                pl = Long.decode(precision.image);
                {if (true) return new NVarChar2Type(pl);}
            }
          break;
        case K_NVARCHAR2:
          jj_consume_token(K_NVARCHAR2);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
            if (precision == null) {
                {if (true) return new NVarChar2Type();}
            }
            else {
                pl = Long.decode(precision.image);
                {if (true) return new NVarChar2Type(pl);}
            }
          break;
        case K_NATIONAL:
          jj_consume_token(K_NATIONAL);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_CHARACTER:
            jj_consume_token(K_CHARACTER);
            break;
          case K_CHAR:
            jj_consume_token(K_CHAR);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_VARYING:
            t = jj_consume_token(K_VARYING);
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            precision = jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          default:
            ;
          }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new NCharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NCharType(pl);}
              }
          }
          else {
              // ANSI syntax for NVARCHAR2
              if (precision == null) {
                  {if (true) return new NVarChar2Type();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NVarChar2Type(pl);}
              }
          }
          break;
        case K_CLOB:
          jj_consume_token(K_CLOB);
          if (jj_2_16(2)) {
            jj_consume_token(K_CHARACTER);
            jj_consume_token(K_SET);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:
              if (jj_2_15(2)) {
                jj_consume_token(S_IDENTIFIER);
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case S_IDENTIFIER:
                case S_QUOTED_IDENTIFIER:
                  columnSpec();
                  jj_consume_token(K_CHARSET);
                  break;
                default:
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
              break;
            default:
              ;
            }
          } else {
            ;
          }
                                                                                                                   {if (true) return new ClobType();}
          break;
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public DatabaseType typeSpec() throws ParseException {
 DatabaseType dataType = null;
 String s = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_BFILE:
    case K_BINARY_DOUBLE:
    case K_BINARY_FLOAT:
    case K_BINARY_INTEGER:
    case K_BLOB:
    case K_BOOLEAN:
    case K_CHAR:
    case K_CHARACTER:
    case K_CLOB:
    case K_DATE:
    case K_DEC:
    case K_DECIMAL:
    case K_DOUBLE:
    case K_FLOAT:
    case K_INT:
    case K_INTEGER:
    case K_INTERVAL:
    case K_LONG:
    case K_MLSLABEL:
    case K_NATIONAL:
    case K_NATURAL:
    case K_NCHAR:
    case K_NCLOB:
    case K_NUMBER:
    case K_NUMERIC:
    case K_NVARCHAR2:
    case K_NVARCHAR:
    case K_PLS_INTEGER:
    case K_POSITIVE:
    case K_RAW:
    case K_REAL:
    case K_ROWID:
    case K_SIGNTYPE:
    case K_SIMPLE_INTEGER:
    case K_SIMPLE_DOUBLE:
    case K_SIMPLE_FLOAT:
    case K_SMALLINT:
    case K_SYS_REFCURSOR:
    case K_TIME:
    case K_TIMESTAMP:
    case K_UROWID:
    case K_VARCHAR2:
    case K_VARCHAR:
      dataType = datatype();
      break;
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
      s = columnSpec();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ROWTYPE:
      case K_TYPE2:
      case O_OPENPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
          jj_consume_token(O_OPENPAREN);
          jj_consume_token(S_NUMBER);
          jj_consume_token(O_CLOSEPAREN);
          break;
        case K_TYPE2:
          jj_consume_token(K_TYPE2);
                    s += tokenImage[K_TYPE2].substring(1, tokenImage[K_TYPE2].length() - 1);
          break;
        case K_ROWTYPE:
          jj_consume_token(K_ROWTYPE);
                      s += tokenImage[K_ROWTYPE].substring(1, tokenImage[K_ROWTYPE].length() - 1);
          break;
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        ;
      }
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      if (dataType == null && localTypes != null) {
          for (String typeName : localTypes.keySet()) {
              if (typeName.equals(s)) {
                  dataType = localTypes.get(s);
                  break;
              }
          }
      }
      if (dataType == null) {
          dataType = new UnresolvedType(s);
      }
      {if (true) return dataType;}
    throw new Error("Missing return statement in function");
  }

  final public String columnSpec() throws ParseException {
 String s1 = null;
 String s2 = null;
 String s3 = null;
    s1 = OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_DOT:
      jj_consume_token(O_DOT);
      s2 = OracleObjectName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_DOT:
        jj_consume_token(O_DOT);
        s3 = OracleObjectName();
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
      StringBuilder sb = new StringBuilder(s1);
      if (s2 != null) {
          sb.append('.');
          sb.append(s2);
          if (s3 != null) {
              sb.append('.');
              sb.append(s3);
          }
      }
      {if (true) return sb.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tableSpec() throws ParseException {
    OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_DOT:
      jj_consume_token(O_DOT);
      OracleObjectName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_ATSIGN:
        jj_consume_token(O_ATSIGN);
        jj_consume_token(S_IDENTIFIER);
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
     {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public String typeName() throws ParseException {
    OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_DOT:
      jj_consume_token(O_DOT);
      OracleObjectName();
      break;
    default:
      ;
    }
     {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public void typeDeclaration(PLSQLPackageType packageType) throws ParseException {
 String s = null;
    jj_consume_token(K_TYPE);
    s = typeName();
    jj_consume_token(K_IS);
    aTypeDeclaration(packageType, s);
    jj_consume_token(O_SEMICOLON);
  }

  final public void aTypeDeclaration(PLSQLPackageType packageType, String typeName) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_RECORD:
      recordDeclaration(packageType, typeName);
      break;
    case K_SUBTYPE:
      subtypeDeclaration(packageType);
      break;
    case K_TABLE:
      plsqlTableDeclaration(packageType, typeName);
      break;
    case K_VARRAY:
    case K_VARYING:
      varrayDeclaration(packageType);
      break;
    case K_REF:
      refCursorDeclaration(packageType);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void recordDeclaration(PLSQLPackageType packageType, String typeName) throws ParseException {
  PLSQLRecordType plsqlRecordType = new PLSQLRecordType(typeName);
  plsqlRecordType.setParentType(packageType);
    jj_consume_token(K_RECORD);
    jj_consume_token(O_OPENPAREN);
    fieldDeclarations(plsqlRecordType);
    jj_consume_token(O_CLOSEPAREN);
      packageType.addType(plsqlRecordType);
      localTypes.put(typeName, plsqlRecordType);
  }

  final public void fieldDeclarations(PLSQLRecordType plsqlRecordType) throws ParseException {
    fieldDeclaration(plsqlRecordType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      fieldDeclarations(plsqlRecordType);
      break;
    default:
      ;
    }
  }

  final public void fieldDeclaration(PLSQLRecordType plsqlRecordType) throws ParseException {
  String s = null;
  DatabaseType dataType = null;
  FieldType fieldType = null;
    s = typeName();
    dataType = typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
      jj_consume_token(K_NULL);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_DEFAULT:
    case O_ASSIGN:
      fieldDefaultAssignment();
      break;
    default:
      ;
    }
      fieldType = new FieldType(s);
      fieldType.setDataType(dataType);
      plsqlRecordType.addCompositeType(fieldType);
      if (dataType instanceof UnresolvedType) {
          ((UnresolvedType)dataType).setOwningType(plsqlRecordType);
      }
  }

  final public void fieldDefaultAssignment() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
      jj_consume_token(O_ASSIGN);
      break;
    case K_DEFAULT:
      jj_consume_token(K_DEFAULT);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    skipToNextArg();
  }

  final public void subtypeDeclaration(PLSQLPackageType packageType) throws ParseException {
    jj_consume_token(K_SUBTYPE);
    OracleObjectName();
    jj_consume_token(K_IS);
    datatype();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_RANGE:
      jj_consume_token(K_RANGE);
      jj_consume_token(S_NUMBER);
      jj_consume_token(O_DOUBLEDOT);
      jj_consume_token(S_NUMBER);
      break;
    case S_NUMBER:
      jj_consume_token(S_NUMBER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_COMMA:
        jj_consume_token(O_COMMA);
        jj_consume_token(S_NUMBER);
        break;
      default:
        ;
      }
      break;
    case K_CHARACTER:
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      jj_consume_token(S_IDENTIFIER);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
      jj_consume_token(K_NULL);
      break;
    default:
      ;
    }
  }

  final public void plsqlTableDeclaration(PLSQLPackageType packageType, String typeName) throws ParseException {
  PLSQLCollectionType plsqlTable = new PLSQLCollectionType(typeName);
  plsqlTable.setParentType(packageType);
  DatabaseType nestedType;
    jj_consume_token(K_TABLE);
    jj_consume_token(K_OF);
    nestedType = typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
      jj_consume_token(K_NULL);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_INDEX:
      jj_consume_token(K_INDEX);
      jj_consume_token(K_BY);
      plsqlTableIndexByDeclaration(plsqlTable);
      break;
    default:
      ;
    }
      if (nestedType instanceof UnresolvedType) {
        ((UnresolvedType)nestedType).setOwningType(plsqlTable);
      }
      plsqlTable.addCompositeType(nestedType);
      packageType.addType(plsqlTable);
      // TODO - TBD typesRepository.setDatabaseType(typeName, plsqlTable);
      localTypes.put(typeName, plsqlTable);
  }

  final public void plsqlTableIndexByDeclaration(PLSQLCollectionType plsqlTable) throws ParseException {
  DatabaseType indexType = null;
  Token precision = null;
  Token otherIndexByType = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_PLS_INTEGER:
      jj_consume_token(K_PLS_INTEGER);
                       indexType = PLS_INTEGER_TYPE;
      break;
    case K_BINARY_INTEGER:
      jj_consume_token(K_BINARY_INTEGER);
                           indexType = BINARY_INTEGER_TYPE;
      break;
    case K_VARCHAR2:
      jj_consume_token(K_VARCHAR2);
      jj_consume_token(O_OPENPAREN);
      precision = jj_consume_token(S_NUMBER);
      jj_consume_token(O_CLOSEPAREN);
        if (precision == null) {
            indexType = new VarChar2Type();
        }
        else {
            Long pl = Long.decode(precision.image);
            indexType = new VarChar2Type(pl);
        }
      break;
    case K_STRING:
      otherIndexByType = jj_consume_token(K_STRING);
      jj_consume_token(O_OPENPAREN);
      jj_consume_token(S_NUMBER);
      jj_consume_token(O_CLOSEPAREN);
        String indexTypename = otherIndexByType.image;
        for (String typeName : localTypes.keySet()) {
            if (typeName.equals(indexTypename)) {
                indexType = localTypes.get(indexTypename);
                break;
            }
        }
        //what else can INDEX BY be? Unresolved for now ...
        if (indexType == null) {
            indexType = new UnresolvedType(indexTypename);
            ((UnresolvedType)indexType).setOwningType(plsqlTable);
        }
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      plsqlTable.setIndexed(true);
      plsqlTable.setIndexType(indexType);
  }

  final public void varrayDeclaration(PLSQLPackageType packageType) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_VARRAY:
      jj_consume_token(K_VARRAY);
      break;
    case K_VARYING:
      jj_consume_token(K_VARYING);
      jj_consume_token(K_ARRAY);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(S_NUMBER);
    jj_consume_token(O_CLOSEPAREN);
    jj_consume_token(K_OF);
    datatype();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOT:
      jj_consume_token(K_NOT);
      jj_consume_token(K_NULL);
      break;
    default:
      ;
    }
  }

  final public void refCursorDeclaration(PLSQLPackageType packageType) throws ParseException {
 String s = null;
    jj_consume_token(K_REF);
    jj_consume_token(K_CURSOR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_RETURN:
      refCursorTypeSpec(packageType);
      break;
    default:
      ;
    }
  }

  final public void refCursorTypeSpec(PLSQLPackageType packageType) throws ParseException {
 String s = null;
    jj_consume_token(K_RETURN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
      if (jj_2_18(3)) {
        s = columnSpec();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_TYPE2:
          jj_consume_token(K_TYPE2);
          break;
        default:
          ;
        }
      } else if (jj_2_19(3)) {
        s = tableSpec();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_ROWTYPE:
          jj_consume_token(K_ROWTYPE);
          break;
        default:
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
  }

  final public void cursorDeclaration(PLSQLPackageType packageType) throws ParseException {
 Token t = null;
    jj_consume_token(K_CURSOR);
    t = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(O_SEMICOLON);
  }

// Procedure Specification
  final public void procedureSpec(PLSQLPackageType packageType) throws ParseException {
 Token t = null;
 ProcedureType procedureType = null;
    jj_consume_token(K_PROCEDURE);
    t = jj_consume_token(S_IDENTIFIER);
            procedureType = new ProcedureType(t.image);
            procedureType.setCatalogName(packageType.getPackageName());
            procedureType.setSchema(packageType.getSchema());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(procedureType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
      packageType.addProcedure(procedureType);
  }

  final public void argumentList(ProcedureType procedureType) throws ParseException {
    argument(procedureType);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_COMMA:
        ;
        break;
      default:
        break label_4;
      }
      jj_consume_token(O_COMMA);
      argument(procedureType);
    }
  }

// Function Specification
  final public void functionSpec(PLSQLPackageType packageType) throws ParseException {
 Token t = null;
 FunctionType functionType = null;
 ArgumentType returnDataType = null;
    jj_consume_token(K_FUNCTION);
    t = jj_consume_token(S_IDENTIFIER);
            functionType = new FunctionType(t.image);
            functionType.setCatalogName(packageType.getPackageName());
            functionType.setSchema(packageType.getSchema());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(functionType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    returnDataType = functionReturnSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_DETERMINISTIC:
    case K_PARALLEL_ENABLE:
    case K_PIPELINED:
    case K_RESULT_CACHE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_DETERMINISTIC:
        jj_consume_token(K_DETERMINISTIC);
        break;
      case K_PIPELINED:
        jj_consume_token(K_PIPELINED);
        break;
      case K_PARALLEL_ENABLE:
        jj_consume_token(K_PARALLEL_ENABLE);
        break;
      case K_RESULT_CACHE:
        jj_consume_token(K_RESULT_CACHE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
      functionType.setReturnArgument(returnDataType);
      packageType.addProcedure(functionType);
  }

  final public ArgumentType functionReturnSpec() throws ParseException {
 DatabaseType dataType = null;
    jj_consume_token(K_RETURN);
    dataType = typeSpec();
      ArgumentType returnType = new ArgumentType(null);
      returnType.setDirection(ArgumentTypeDirection.RETURN);
      returnType.setDataType(dataType);
      if (dataType instanceof UnresolvedType) {
          ((UnresolvedType)dataType).setOwningType(returnType);
      }
      {if (true) return returnType;}
    throw new Error("Missing return statement in function");
  }

  final public void argument(ProcedureType procedureType) throws ParseException {
 Token t = null;
 ArgumentType argumentType = null;
 DatabaseType argumentDataType = null;
 ArgumentTypeDirection argDirection = ArgumentTypeDirection.IN; // by default, arguments are IN
 String direction = null;
 boolean defaultAssignment = false;
    t = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_IN:
    case K_OUT:
      direction = direction();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_NOCOPY:
      jj_consume_token(K_NOCOPY);
      break;
    default:
      ;
    }
    argumentDataType = typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_DEFAULT:
    case O_ASSIGN:
      defaultAssignment = argumentDefaultAssignment();
      break;
    default:
      ;
    }
      argumentType = new ArgumentType(t.image);
      argumentType.setDataType(argumentDataType);
      if (argumentDataType instanceof UnresolvedType) {
          ((UnresolvedType)argumentDataType).setOwningType(argumentType);
      }
      if (direction != null) {
          if ("OUT".equals(direction)) {
              argDirection = ArgumentTypeDirection.OUT;
          }
          else if ("IN OUT".equals(direction)) {
              argDirection = ArgumentTypeDirection.INOUT;
          }
          argumentType.setDirection(argDirection);
      }
      if (defaultAssignment) {
          argumentType.setOptional();
      }
      procedureType.addCompositeType(argumentType);
  }

  final public String direction() throws ParseException {
    if (jj_2_20(2)) {
      jj_consume_token(K_IN);
      jj_consume_token(K_OUT);
                                  {if (true) return "IN OUT";}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_IN:
        jj_consume_token(K_IN);
               {if (true) return "IN";}
        break;
      case K_OUT:
        jj_consume_token(K_OUT);
                 {if (true) return "OUT";}
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public boolean argumentDefaultAssignment() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
      jj_consume_token(O_ASSIGN);
      break;
    case K_DEFAULT:
      jj_consume_token(K_DEFAULT);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    skipToNextArg();
      {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

  final public void exceptionDeclaration(PLSQLPackageType packageType) throws ParseException {
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(K_EXCEPTION);
    jj_consume_token(O_SEMICOLON);
  }

  final public void pragmaDeclaration(PLSQLPackageType packageType) throws ParseException {
    jj_consume_token(K_PRAGMA);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AUTONOMOUS_TRANSACTION:
    case K_EXCEPTION_INIT:
    case K_INLINE:
    case K_RESTRICT_REFERENCES:
    case K_SERIALLY_REUSABLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_AUTONOMOUS_TRANSACTION:
        jj_consume_token(K_AUTONOMOUS_TRANSACTION);
        break;
      case K_EXCEPTION_INIT:
        jj_consume_token(K_EXCEPTION_INIT);
        jj_consume_token(O_OPENPAREN);
        jj_consume_token(S_IDENTIFIER);
        jj_consume_token(O_COMMA);
        jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      case K_SERIALLY_REUSABLE:
        jj_consume_token(K_SERIALLY_REUSABLE);
        break;
      case K_INLINE:
        jj_consume_token(K_INLINE);
        jj_consume_token(O_OPENPAREN);
        jj_consume_token(S_IDENTIFIER);
        jj_consume_token(O_COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_NO:
        case K_YES:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_YES:
            jj_consume_token(K_YES);
            break;
          case K_NO:
            jj_consume_token(K_NO);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        jj_consume_token(O_CLOSEPAREN);
        break;
      case K_RESTRICT_REFERENCES:
        jj_consume_token(K_RESTRICT_REFERENCES);
        jj_consume_token(O_OPENPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_DEFAULT:
        case S_IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S_IDENTIFIER:
            jj_consume_token(S_IDENTIFIER);
            break;
          case K_DEFAULT:
            jj_consume_token(K_DEFAULT);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        label_5:
        while (true) {
          jj_consume_token(O_COMMA);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_RNDS:
          case K_RNPS:
          case K_TRUST:
          case K_WNDS:
          case K_WNPS:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case K_RNDS:
              jj_consume_token(K_RNDS);
              break;
            case K_WNDS:
              jj_consume_token(K_WNDS);
              break;
            case K_RNPS:
              jj_consume_token(K_RNPS);
              break;
            case K_WNPS:
              jj_consume_token(K_WNPS);
              break;
            case K_TRUST:
              jj_consume_token(K_TRUST);
              break;
            default:
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_COMMA:
            ;
            break;
          default:
            break label_5;
          }
        }
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
  }

  final public String OracleObjectName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S_IDENTIFIER:
      jj_consume_token(S_IDENTIFIER);
     {if (true) return token.image;}
      break;
    case S_QUOTED_IDENTIFIER:
      jj_consume_token(S_QUOTED_IDENTIFIER);
      String s = token.image;
      {if (true) return s.substring(1, s.length() - 1);} // strip-off quotes

      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void skipToSemiColon() throws ParseException {
        Token t = getNextToken();
        while (t.kind != O_SEMICOLON) {
                t = getNextToken();
        }
        token_source.input_stream.backup(1);
  }

  final public void skipToNextArg() throws ParseException {
        Token t = getNextToken();
        while (t.kind != O_COMMA && t.kind != O_CLOSEPAREN) {
            t = getNextToken();
        }
        token_source.input_stream.backup(1);
  }

  final public void skipToEnd() throws ParseException {
      /** skip through all the tokens. */
      Token t = getNextToken();
      while (t.kind != EOF) {
          t = getNextToken();
      }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(K_NCHAR)) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(K_CHARACTER)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(K_VARCHAR2)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(O_DOT)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(K_VARCHAR)) return true;
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(K_SIGNTYPE)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(K_POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(K_BINARY_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_scan_token(K_BINARY_FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(O_DOT)) return true;
    if (jj_3R_6()) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(K_BINARY_INTEGER)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(O_DOT)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(K_CHAR)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_scan_token(O_DOT)) return true;
    if (jj_3R_6()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(K_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_11() {
    if (jj_3R_6()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_9() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(35)) jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(K_UROWID)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(K_ROWID)) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(K_BFILE)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(K_NCLOB)) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(K_BLOB)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(K_SYS_REFCURSOR)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(K_SIMPLE_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(K_SIMPLE_FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(K_SIMPLE_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(K_PLS_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(K_MLSLABEL)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(K_REAL)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_10()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(199)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_10() {
    if (jj_3R_6()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(O_DOT)) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_11()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(169)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_scan_token(K_FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(K_SMALLINT)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(K_INT)) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_scan_token(K_INTEGER)) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(O_DOT)) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(K_TIMESTAMP)) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_scan_token(K_TIME)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) return true;
    }
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(K_CLOB)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(K_INTERVAL)) return true;
    return false;
  }

  private boolean jj_3R_8() {
    if (jj_3R_6()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(O_DOT)) return true;
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) return true;
    }
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_scan_token(S_QUOTED_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_12() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_12()) {
    jj_scanpos = xsp;
    if (jj_3R_13()) return true;
    }
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(K_NATIONAL)) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_scan_token(K_INTERVAL)) return true;
    if (jj_scan_token(K_DAY)) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_scan_token(K_DATE)) return true;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_scan_token(K_BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(K_NVARCHAR2)) return true;
    return false;
  }

  private boolean jj_3_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(36)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_8()) jj_scanpos = xsp;
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(K_RAW)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(K_NVARCHAR)) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_6()) return true;
    if (jj_3R_7()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(K_OUT)) return true;
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_scan_token(K_LONG)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public DDLParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;

  /** Constructor with InputStream. */
  public DDLParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public DDLParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new DDLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
  }

  /** Constructor. */
  public DDLParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new DDLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
  }

  /** Constructor with generated Token Manager. */
  public DDLParser(DDLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(DDLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      return token;
    }
    token = oldToken;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    Token errortok = token.next;
    int line = errortok.beginLine, column = errortok.beginColumn;
    String mess = (errortok.kind == 0) ? tokenImage[0] : errortok.image;
    return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
