/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.schedules;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleManager;
import org.eclipse.gyrex.jobs.schedules.manager.IScheduleWorkingCopy;
import org.osgi.service.prefs.BackingStoreException;

public class ScheduleManagerImpl
implements IScheduleManager {
    public static final String SEPARATOR = "_";
    private final IRuntimeContext context;
    private final String internalIdPrefix;

    public static String getExternalId(String internalId) {
        int i = internalId.indexOf(SEPARATOR);
        if (i < 0) {
            return internalId;
        }
        return internalId.substring(i + 1);
    }

    @Inject
    public ScheduleManagerImpl(IRuntimeContext context) {
        this.context = context;
        try {
            this.internalIdPrefix = String.valueOf(DigestUtils.shaHex((byte[])context.getContextPath().toString().getBytes("UTF-8"))) + SEPARATOR;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Please use a JVM that supports UTF-8.");
        }
    }

    @Override
    public IScheduleWorkingCopy createSchedule(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id: " + id);
        }
        String internalId = this.toInternalId(id);
        try {
            return ScheduleStore.create(internalId, id, this.context);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Unable to access schedule store. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public IScheduleWorkingCopy createWorkingCopy(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id: " + id);
        }
        String internalId = this.toInternalId(id);
        try {
            return ScheduleStore.load(internalId, id, true);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Unable to access schedule store. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public ISchedule getSchedule(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id: " + id);
        }
        String internalId = this.toInternalId(id);
        try {
            return ScheduleStore.load(internalId, id, false);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Unable to access schedule store. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public Collection<String> getSchedules() {
        try {
            String[] storageIds = ScheduleStore.getSchedules();
            ArrayList<String> schedules = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (internalId.startsWith(this.internalIdPrefix)) {
                    schedules.add(this.toExternalId(internalId));
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(schedules);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Unable to access schedule store. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public void removeSchedule(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id: " + id);
        }
        ISchedule schedule = this.getSchedule(id);
        if (schedule == null) {
            throw new IllegalStateException(String.format("schedule '%s' does not exist", id));
        }
        IJobManager jobManager = (IJobManager)this.context.get(IJobManager.class);
        for (IScheduleEntry entry : schedule.getEntries()) {
            if (jobManager.getJob(entry.getJobId()) == null) continue;
            jobManager.removeJob(entry.getJobId());
        }
        String internalId = this.toInternalId(id);
        try {
            ScheduleStore.remove(internalId, id);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Unable to access schedule store. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    private String toExternalId(String internalId) {
        return StringUtils.removeStart((String)internalId, (String)this.internalIdPrefix);
    }

    private String toInternalId(String id) {
        return this.internalIdPrefix.concat(id);
    }

    @Override
    public void updateSchedule(IScheduleWorkingCopy copy) {
        if (!(copy instanceof ScheduleImpl)) {
            throw new IllegalArgumentException("invalid working copy, must be obtained from this manager");
        }
        ScheduleImpl scheduleImpl = (ScheduleImpl)copy;
        String internalId = this.toInternalId(scheduleImpl.getId());
        try {
            ScheduleStore.flush(internalId, scheduleImpl);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Unable to access schedule store. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }
}

