/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.boot.internal.BootActivator;
import org.eclipse.gyrex.boot.internal.BootDebug;
import org.eclipse.gyrex.boot.internal.jmx.JettyJmxConnector;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.gyrex.server.internal.roles.LocalRolesManager;
import org.eclipse.gyrex.server.internal.roles.ServerRoleDefaultStartOption;
import org.eclipse.gyrex.server.internal.roles.ServerRolesRegistry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerApplication
extends BaseApplication {
    private static final String BSN_EQUINOX_CONSOLE_SSH = "org.eclipse.equinox.console.ssh";
    private static final String BSN_EQUINOX_DS = "org.eclipse.equinox.ds";
    private static final Logger LOG = LoggerFactory.getLogger(ServerApplication.class);
    private static final Thread shutdownHook = new Thread("Shutdown Hook"){

        @Override
        public void run() {
            try {
                LOG.info("Shutting down...");
                ServerApplication.shutdown(null);
            }
            catch (Exception exception) {}
        }
    };
    private static final AtomicReference<ServerApplication> singletonInstance = new AtomicReference();
    private volatile boolean running;
    private volatile boolean restart;
    private volatile Throwable shutdownReason;
    private Location instanceLocation;

    public static boolean isRunning() {
        ServerApplication application = singletonInstance.get();
        return application != null && application.running;
    }

    private static void printError(String message, Throwable cause) {
        System.err.println();
        System.err.println();
        System.err.println(StringUtils.leftPad((String)"", (int)72, (char)'*'));
        System.err.println(StringUtils.center((String)" Server Startup Error ", (int)72));
        System.err.println(StringUtils.leftPad((String)"", (int)72, (char)'*'));
        System.err.println();
        System.err.println(WordUtils.wrap((String)message, (int)72));
        System.err.println();
        if (cause != null) {
            System.err.println("Reported error:");
            System.err.print("  ");
            System.err.println(WordUtils.wrap((String)cause.getMessage(), (int)70, (String)String.format("%n  ", new Object[0]), (boolean)false));
            List throwables = ExceptionUtils.getThrowableList((Throwable)cause);
            if (throwables.size() > 1) {
                System.err.println();
                System.err.println("Caused by:");
                int i = 1;
                while (i < throwables.size()) {
                    System.err.print("  ");
                    System.err.println(WordUtils.wrap((String)ExceptionUtils.getMessage((Throwable)((Throwable)throwables.get(i))), (int)70, (String)String.format("%n  ", new Object[0]), (boolean)false));
                    ++i;
                }
            }
            System.err.println();
        }
        System.err.println(StringUtils.leftPad((String)"", (int)72, (char)'*'));
        System.err.println();
        System.err.println();
    }

    public static void restart() {
        ServerApplication application = singletonInstance.get();
        if (application == null) {
            throw new IllegalStateException("Platform not started.");
        }
        if (BootDebug.debug) {
            LOG.debug("Relaunch request received!");
        }
        application.restart = true;
        application.shutdownReason = null;
        application.stop();
    }

    public static void shutdown(Throwable cause) {
        ServerApplication application = singletonInstance.get();
        if (application == null) {
            throw new IllegalStateException("Platform not started.");
        }
        application.restart = false;
        application.shutdownReason = cause;
        application.stop();
    }

    public ServerApplication() {
        this.debug = BootDebug.debug;
    }

    private void bootstrap() throws Exception {
        if (BootDebug.debug) {
            LOG.debug("Bootstrapping platform.");
        }
        this.startBundle(BSN_EQUINOX_DS, true);
    }

    private void checkInstanceLocation(Location instanceLocation) {
        if (instanceLocation == null || instanceLocation.getURL() == null || !instanceLocation.getURL().toExternalForm().startsWith("file:") || instanceLocation.isReadOnly()) {
            ServerApplication.printError("Gyrex needs a valid local instance location (aka. 'workspace'). Please start with the -data option pointing to a valid, writable file system path.", null);
            throw new BaseApplication.StartAbortedException();
        }
        try {
            if (instanceLocation.lock()) {
                return;
            }
            File workspaceDirectory = new File(instanceLocation.getURL().getFile());
            if (workspaceDirectory.exists()) {
                ServerApplication.printError("Could not launch the server because the associated workspace '" + workspaceDirectory.getAbsolutePath() + "' is currently in use by another Eclipse application.", null);
            } else {
                ServerApplication.printError("Could not launch the server because the specified workspace cannot be created. The specified workspace directory '" + workspaceDirectory.getAbsolutePath() + "' is either invalid or read-only.", null);
            }
        }
        catch (IOException e) {
            ServerApplication.printError("Unable to verify the specified workspace directory " + instanceLocation.getURL().toExternalForm() + ".", e);
        }
        throw new BaseApplication.StartAbortedException();
    }

    protected void doCleanup() {
        this.running = false;
        if (this.instanceLocation != null) {
            this.instanceLocation.release();
            this.instanceLocation = null;
        }
        this.shutdownReason = null;
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (Exception exception) {}
    }

    protected void doStart(Map arguments) throws Exception {
        String[] args = ServerApplication.getApplicationArguments((Map)arguments);
        if (!singletonInstance.compareAndSet(null, this)) {
            throw new IllegalStateException("server application already running");
        }
        try {
            this.instanceLocation = BootActivator.getInstance().getInstanceLocation();
        }
        catch (Exception e) {
            ServerApplication.printError("An error occurred reading the instance location (aka. 'workspace'). Please verify that the installation is correct and all required components are available.", e);
            throw new BaseApplication.StartAbortedException();
        }
        this.checkInstanceLocation(this.instanceLocation);
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            this.bootstrap();
            this.jmxOn();
            if (this.isConsoleEnabled()) {
                this.startConsole();
            }
            this.running = true;
            List<String> roles = this.getEnabledServerRoles(args);
            LocalRolesManager.activateRoles(roles, true);
        }
        catch (Exception e) {
            if (BootDebug.debug) {
                LOG.debug("Platform start failed!", (Throwable)e);
            }
            ServerApplication.printError("Unable to start server. Please verify the installation is correct and all required components are available.", e);
            throw new BaseApplication.StartAbortedException();
        }
    }

    protected Object doStop() {
        this.running = false;
        try {
            LocalRolesManager.deactivateAllRoles();
        }
        catch (Exception exception) {}
        this.jmxOff();
        Throwable reason = this.shutdownReason;
        if (reason != null) {
            ServerApplication.printError("Server shutdown forced due to error in underlying system. Please verify the installation is correct and all required components are available. ", reason);
            return EXIT_ERROR;
        }
        return this.restart ? EXIT_RESTART : EXIT_OK;
    }

    private List<String> getEnabledServerRoles(String[] arguments) {
        boolean ignoreDefaultRoles = false;
        ArrayList<String> roleIds = new ArrayList<String>();
        int i = 0;
        while (i < arguments.length) {
            String arg = arguments[i];
            if ("-skipDefaultRolesAtBoot".equalsIgnoreCase(arg)) {
                ignoreDefaultRoles = true;
            } else if ("-roles".equalsIgnoreCase(arg)) {
                if (++i >= arguments.length) {
                    throw new IllegalArgumentException("The argument '-roles' requires a following argument with the server roles to start.");
                }
                String[] specifiedRoles = StringUtils.split((String)arguments[i], (char)',');
                if (specifiedRoles == null || specifiedRoles.length == 0) {
                    throw new IllegalArgumentException("The specified server roles could not be identified. Please specify at least one role. You may specify multiple rows using a comma separated list.");
                }
                String[] stringArray = specifiedRoles;
                int n = specifiedRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    String role = stringArray[n2];
                    if (StringUtils.isNotBlank((String)role) && !roleIds.contains(role)) {
                        if (BootDebug.roles) {
                            LOG.debug("Role submitted via command line: " + role);
                        }
                        roleIds.add(role);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (!ignoreDefaultRoles) {
            Collection<String> defaultRoles = ServerRolesRegistry.getDefault().getRolesToStartByDefault(ServerRoleDefaultStartOption.Trigger.ON_BOOT);
            for (String role : defaultRoles) {
                if (roleIds.contains(role)) continue;
                if (BootDebug.roles) {
                    LOG.debug("Default start boot role: " + role);
                }
                roleIds.add(role);
            }
        }
        return roleIds;
    }

    protected Logger getLogger() {
        return LOG;
    }

    private boolean isConsoleEnabled() {
        String[] args = BootActivator.getEnvironmentInfo().getFrameworkArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-console")) {
                return i + 1 >= args.length || !args[i + 1].equals("none");
            }
            ++i;
        }
        return false;
    }

    private void jmxOff() {
        try {
            JettyJmxConnector.stop();
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Jetty JMX is not available. Ignoring error during shutdown. ({})", (Object)e.getMessage());
        }
        catch (LinkageError e) {
            LOG.debug("Jetty JMX is not available. Ignoring error during shutdown. ({})", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Error while stopping Jetty JMX. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
        }
    }

    private void jmxOn() {
        try {
            JettyJmxConnector.start();
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Jetty JMX is not available. Please configure JMX support manually. ({})", (Object)e.getMessage());
        }
        catch (LinkageError e) {
            LOG.warn("Jetty JMX is not available. Please configure JMX support manually. ({})", (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new UnhandledException("An error occured while starting the embedded JMX server. Please verify the port/host configuration is correct and no other server is running. JMX can also be disabled by setting system property 'gyrex.jmxrmi.skip'.", (Throwable)e);
        }
    }

    private boolean startBundle(String symbolicName, boolean required) throws BundleException {
        Bundle bundle = BootActivator.getInstance().getBundle(symbolicName);
        if (bundle != null) {
            bundle.start(1);
            return true;
        }
        if (required) {
            ServerApplication.printError(String.format("Required bundle '%s' not available. Your system will not function properly.", symbolicName), null);
            throw new BaseApplication.StartAbortedException();
        }
        return false;
    }

    private void startConsole() throws BundleException {
        EnvironmentInfo environmentInfo = BootActivator.getEnvironmentInfo();
        if (environmentInfo.getProperty("osgi.console.ssh") == null) {
            environmentInfo.setProperty("osgi.console.ssh", String.valueOf(Platform.getInstancePort(3122)));
        }
        if (environmentInfo.getProperty("ssh.custom.publickeys.auth") == null) {
            environmentInfo.setProperty("ssh.custom.publickeys.auth", "true");
        }
        if (this.startBundle(BSN_EQUINOX_CONSOLE_SSH, false)) {
            try {
                Object authenticator = BootActivator.getInstance().getBundle().loadClass("org.eclipse.gyrex.boot.internal.ssh.InstanceLocationAuthorizedKeysFileAuthenticator").newInstance();
                BootActivator.getInstance().getServiceHelper().registerService("org.apache.sshd.server.PublickeyAuthenticator", authenticator, "Eclipse Gyrex", "Equionx SSH Console authorized_keys support for Gyrex.", null, Integer.valueOf(Integer.MAX_VALUE));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {
            }
            catch (Exception e) {
                LOG.warn("Unable to register authorized_keys file support for Equinox SSH Console. ", (Throwable)e);
            }
        }
    }
}

