/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.internal.roles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.boot.internal.BootDebug;
import org.eclipse.gyrex.server.internal.roles.ActivationException;
import org.eclipse.gyrex.server.internal.roles.ServerRole;
import org.eclipse.gyrex.server.internal.roles.ServerRolesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRolesManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalRolesManager.class);
    private static final Map<String, ServerRole> activeRoles = new LinkedHashMap<String, ServerRole>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean activate(String roleId) throws ActivationException {
        ServerRole role;
        if (BootDebug.roles) {
            LOG.debug("Activating role {}...", (Object)roleId);
        }
        Map<String, ServerRole> map = activeRoles;
        synchronized (map) {
            block8: {
                block7: {
                    if (!activeRoles.containsKey(roleId)) break block7;
                    if (BootDebug.roles) {
                        LOG.debug("Role {} already active.", (Object)roleId);
                    }
                    return true;
                }
                role = ServerRolesRegistry.getDefault().getRole(roleId);
                if (role != null) break block8;
                LOG.warn("Role {} not found in registry. Please check installation that bundles contributing the role are properly installed and resolve.", (Object)roleId);
                return false;
            }
            activeRoles.put(roleId, role);
        }
        role.activate();
        return true;
    }

    public static void activateRoles(Collection<String> roleIds) {
        if (BootDebug.debug) {
            LOG.debug("Activating roles {}.", (Object)StringUtils.join(roleIds, (char)','));
        }
        for (String roleId : roleIds) {
            try {
                LocalRolesManager.activate(roleId);
            }
            catch (ActivationException e) {
                LOG.error("Failed to activate role {}. {}", new Object[]{roleId, e.getMessage(), e});
            }
        }
    }

    public static void activateRoles(Collection<String> roleIds, boolean failOnError) throws Exception {
        if (BootDebug.debug) {
            LOG.debug("Activating roles {}.", (Object)StringUtils.join(roleIds, (char)','));
        }
        for (String roleId : roleIds) {
            if (LocalRolesManager.activate(roleId)) continue;
            throw new IllegalArgumentException("Role " + roleId + " not found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deactivateAllRoles() {
        ArrayList<String> roleIds;
        Map<String, ServerRole> map = activeRoles;
        synchronized (map) {
            roleIds = new ArrayList<String>(activeRoles.keySet());
        }
        Collections.reverse(roleIds);
        LocalRolesManager.deactivateRoles(roleIds);
    }

    public static void deactivateRoles(Collection<String> roleIds) {
        if (BootDebug.debug) {
            LOG.debug("Deactivating roles {}.", (Object)StringUtils.join(roleIds, (char)','));
        }
        for (String roleId : roleIds) {
            LocalRolesManager.dectivate(roleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dectivate(String roleId) {
        ServerRole role;
        Map<String, ServerRole> map = activeRoles;
        synchronized (map) {
            role = activeRoles.remove(roleId);
        }
        if (role == null) {
            return;
        }
        role.deactivate();
    }
}

