/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.frames.SynStreamFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;
import org.eclipse.jetty.spdy.parser.HeadersBlockParser;
import org.eclipse.jetty.util.Fields;

public class SynStreamBodyParser
extends ControlFrameBodyParser {
    private final Fields headers = new Fields();
    private final ControlFrameParser controlFrameParser;
    private final HeadersBlockParser headersBlockParser;
    private State state = State.STREAM_ID;
    private int cursor;
    private int streamId;
    private int associatedStreamId;
    private byte priority;
    private short slot;

    public SynStreamBodyParser(CompressionFactory.Decompressor decompressor, ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
        this.headersBlockParser = new SynStreamHeadersBlockParser(decompressor);
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block8: while (buffer.hasRemaining()) {
            switch (this.state) {
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.ASSOCIATED_STREAM_ID;
                        continue block8;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block8;
                }
                case STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.streamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block8;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.ASSOCIATED_STREAM_ID;
                    continue block8;
                }
                case ASSOCIATED_STREAM_ID: {
                    this.checkVersion(this.controlFrameParser.getVersion(), this.streamId);
                    if (buffer.remaining() >= 4) {
                        this.associatedStreamId = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.PRIORITY;
                        continue block8;
                    }
                    this.state = State.ASSOCIATED_STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block8;
                }
                case ASSOCIATED_STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.associatedStreamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block8;
                    this.associatedStreamId &= Integer.MAX_VALUE;
                    this.state = State.PRIORITY;
                    continue block8;
                }
                case PRIORITY: {
                    byte currByte = buffer.get();
                    ++this.cursor;
                    if (this.cursor == 1) {
                        this.priority = this.readPriority(this.controlFrameParser.getVersion(), currByte);
                        continue block8;
                    }
                    this.slot = (short)(currByte & 0xFF);
                    if (this.slot < 0) {
                        throw new StreamException(this.streamId, StreamStatus.INVALID_CREDENTIALS);
                    }
                    this.cursor = 0;
                    this.state = State.HEADERS;
                    continue block8;
                }
                case HEADERS: {
                    int length;
                    short version = this.controlFrameParser.getVersion();
                    if (!this.headersBlockParser.parse(this.streamId, version, length = this.controlFrameParser.getLength() - 10, buffer)) continue block8;
                    byte flags = this.controlFrameParser.getFlags();
                    if (flags > 3) {
                        throw new IllegalArgumentException("Invalid flag " + flags + " for frame " + (Object)((Object)ControlFrameType.SYN_STREAM));
                    }
                    SynStreamFrame frame = new SynStreamFrame(version, flags, this.streamId, this.associatedStreamId, this.priority, this.slot, new Fields(this.headers, true));
                    this.controlFrameParser.onControlFrame(frame);
                    this.reset();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void checkVersion(short version, int streamId) {
        if (version != 2 && version != 3) {
            throw new StreamException(streamId, StreamStatus.UNSUPPORTED_VERSION);
        }
    }

    private byte readPriority(short version, byte currByte) {
        switch (version) {
            case 2: {
                int p2 = currByte & 0xC0;
                return (byte)(p2 >>>= 6);
            }
            case 3: {
                int p3 = currByte & 0xE0;
                return (byte)(p3 >>>= 5);
            }
        }
        throw new IllegalStateException();
    }

    private void reset() {
        this.headers.clear();
        this.state = State.STREAM_ID;
        this.cursor = 0;
        this.streamId = 0;
        this.associatedStreamId = 0;
        this.priority = 0;
    }

    private class SynStreamHeadersBlockParser
    extends HeadersBlockParser {
        public SynStreamHeadersBlockParser(CompressionFactory.Decompressor decompressor) {
            super(decompressor);
        }

        @Override
        protected void onHeader(String name, String[] values) {
            for (String value : values) {
                SynStreamBodyParser.this.headers.add(name, value);
            }
        }
    }

    private static enum State {
        STREAM_ID,
        STREAM_ID_BYTES,
        ASSOCIATED_STREAM_ID,
        ASSOCIATED_STREAM_ID_BYTES,
        PRIORITY,
        HEADERS;

    }
}

