/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.commands;

import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.commands.BaseSwCmd;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.kohsuke.args4j.Argument;

public final class RolloutCmd
extends BaseSwCmd {
    @Argument(index=0, usage="the package id", required=true, metaVar="ID")
    String id;

    public RolloutCmd() {
        super("<ID> - marks a package for rollout");
    }

    protected void doExecute() throws Exception {
        if (!IdHelper.isValidId((String)this.id)) {
            this.printf("ERROR: invalid package id", new Object[0]);
            return;
        }
        PackageDefinition packageDefinition = this.getPackageManager().getPackage(this.id);
        if (packageDefinition == null) {
            this.printf("ERROR: package not found", new Object[0]);
            return;
        }
        this.getPackageManager().markedForInstall(packageDefinition);
        this.printf("package marked for rollout", new Object[0]);
    }
}

