/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.installer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.packages.InstallableUnitReference;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.osgi.service.prefs.BackingStoreException;

public class PackageInstallState {
    public static final String IU_PROP_PACKAGE = "org.eclipse.gyrex.p2.package";
    private static final Lock installSessionIdLock = new ReentrantLock();

    public static IInstallableUnit createUnit(PackageDefinition definition) {
        MetadataFactory.InstallableUnitDescription unitDescription = new MetadataFactory.InstallableUnitDescription();
        String packageUnitId = PackageInstallState.getPackageUnitId(definition);
        unitDescription.setId(packageUnitId);
        Version packageVersion = PackageInstallState.getPackageUnitVersion(definition);
        unitDescription.setVersion(packageVersion);
        unitDescription.setSingleton(true);
        unitDescription.setProperty("org.eclipse.equinox.p2.name", "Software Package " + definition.getId());
        unitDescription.setProperty(IU_PROP_PACKAGE, Boolean.TRUE.toString());
        unitDescription.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)unitDescription.getId(), (Version)unitDescription.getVersion())));
        ArrayList<IRequirement> requires = new ArrayList<IRequirement>();
        Collection<InstallableUnitReference> componentsToInstall = definition.getComponentsToInstall();
        for (InstallableUnitReference unit : componentsToInstall) {
            VersionRange unitVersionRange = unit.getVersion() != null && Version.emptyVersion.compareTo((Object)unit.getVersion()) < 0 ? new VersionRange(unit.getVersion(), true, unit.getVersion(), true) : VersionRange.emptyRange;
            requires.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)unit.getId(), (VersionRange)unitVersionRange, null, (boolean)false, (boolean)false, (boolean)true));
        }
        unitDescription.addRequirements(requires);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)unitDescription);
    }

    public static String getActiveInstallSessionId() {
        File sessionFile = PackageInstallState.getBaseLocation().append("sessionActive").toFile();
        installSessionIdLock.lock();
        try {
            String string = FileUtils.readFileToString((File)sessionFile, (String)"UTF-8");
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read active install session id. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
        finally {
            installSessionIdLock.unlock();
        }
    }

    static IPath getBaseLocation() {
        return P2Activator.getInstance().getConfigLocation().append("org.eclipse.gyrex.p2");
    }

    public static String getPackageId(IInstallableUnit unit) {
        if (!Boolean.TRUE.toString().equals(unit.getProperty(IU_PROP_PACKAGE))) {
            throw new IllegalArgumentException("not a package IU");
        }
        return StringUtils.removeEnd((String)unit.getId(), (String)".package");
    }

    private static String getPackageUnitId(PackageDefinition definition) {
        return definition.getId().concat(".package");
    }

    private static Version getPackageUnitVersion(PackageDefinition definition) {
        return Version.createOSGi((int)1, (int)0, (int)0);
    }

    public static boolean isInstalled(IProvisioningAgent agent, PackageDefinition packageDefinition) throws BackingStoreException {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            throw new IllegalStateException("The current system has not been provisioned using p2. Unable to acquire profile registry.");
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            throw new IllegalStateException("The current system has not been provisioned using p2. Unable to get profile.");
        }
        IQueryResult result = profile.available(QueryUtil.createIUQuery((String)PackageInstallState.getPackageUnitId(packageDefinition), (Version)PackageInstallState.getPackageUnitVersion(packageDefinition)), null);
        return !result.isEmpty();
    }

    public static void removeActiveInstallSessionId() {
        File sessionFile = PackageInstallState.getBaseLocation().append("sessionActive").toFile();
        installSessionIdLock.lock();
        try {
            if (sessionFile.isFile() && !sessionFile.delete()) {
                throw new IllegalStateException("Unable to delete active install session id. " + sessionFile.getPath());
            }
        }
        finally {
            installSessionIdLock.unlock();
        }
    }

    public static void setActiveInstallSessionId(String activeSessionId) {
        File sessionFile = PackageInstallState.getBaseLocation().append("sessionActive").toFile();
        installSessionIdLock.lock();
        try {
            try {
                FileUtils.writeStringToFile((File)sessionFile, (String)activeSessionId, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to write active install session id. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            }
        }
        finally {
            installSessionIdLock.unlock();
        }
    }

    private PackageInstallState() {
    }
}

