/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.admin;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeScope
implements IScopeContext {
    private static final Logger LOG = LoggerFactory.getLogger(NodeScope.class);
    public static final String NAME = "node";
    private static volatile IEclipsePreferences scopeRootNode;
    private final String nodeId;

    private static Preferences getCloudScopeNode() {
        if (scopeRootNode == null) {
            int pass = 0;
            while (scopeRootNode == null) {
                ++pass;
                try {
                    scopeRootNode = (IEclipsePreferences)((IPreferencesService)CloudActivator.getInstance().getService(IPreferencesService.class)).getRootNode().node(NAME);
                }
                catch (IllegalStateException e) {
                    if (pass > 5) {
                        LOG.error("Unable to activating the node preferences scope. Please check the server logs and the server configuration. ", (Throwable)e);
                        throw e;
                    }
                    LOG.warn("Error while activating the node preferences scope. Will try again. (Pass {}) {}", (Object)pass, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
            }
        }
        return scopeRootNode;
    }

    public NodeScope(String nodeId) {
        if (!IdHelper.isValidId((String)nodeId)) {
            throw new IllegalArgumentException("invalid id");
        }
        this.nodeId = nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NodeScope)) {
            return false;
        }
        NodeScope other = (NodeScope)o;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.nodeId.equals(other.nodeId)) {
            return false;
        }
        IPath location = this.getLocation();
        return location == null ? other.getLocation() == null : location.equals((Object)other.getLocation());
    }

    public IPath getLocation() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public IEclipsePreferences getNode(String qualifier) throws IllegalArgumentException, IllegalStateException {
        if (qualifier == null) {
            throw new IllegalArgumentException("qualifier must not be null");
        }
        return (IEclipsePreferences)NodeScope.getCloudScopeNode().node(this.nodeId).node(qualifier);
    }

    public int hashCode() {
        return NAME.hashCode() + this.nodeId.hashCode();
    }
}

