/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.locking;

import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.cloud.internal.locking.DurableLockImpl;
import org.eclipse.gyrex.cloud.internal.locking.ExclusiveLockImpl;
import org.eclipse.gyrex.cloud.services.locking.IDurableLock;
import org.eclipse.gyrex.cloud.services.locking.IExclusiveLock;
import org.eclipse.gyrex.cloud.services.locking.ILockMonitor;
import org.eclipse.gyrex.cloud.services.locking.ILockService;

public class ZooKeeperLockService
implements ILockService {
    @Override
    public IDurableLock acquireDurableLock(String lockId, ILockMonitor<IDurableLock> callback, long timeout) throws InterruptedException, TimeoutException {
        return new DurableLockImpl(lockId, callback).acquire(timeout);
    }

    @Override
    public IExclusiveLock acquireExclusiveLock(String lockId, ILockMonitor<IExclusiveLock> callback, long timeout) throws InterruptedException, TimeoutException {
        return new ExclusiveLockImpl(lockId, callback).acquire(timeout);
    }

    @Override
    public IStatus getDurableLockStatus(String lockId) {
        return new DurableLockImpl(lockId, null).getStatus();
    }

    @Override
    public IStatus getExclusiveLockStatus(String lockId) {
        return new ExclusiveLockImpl(lockId, null).getStatus();
    }

    @Override
    public IDurableLock recoverDurableLock(String lockId, ILockMonitor<IDurableLock> callback, String recoveryKey) throws IllegalArgumentException {
        return new DurableLockImpl(lockId, callback).recover(recoveryKey);
    }
}

