/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.Collection;
import org.eclipse.gyrex.jobs.history.IJobHistory;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.manager.PagableHistoryEntryCollection;
import org.eclipse.gyrex.jobs.spi.storage.IJobHistoryStorage;

public final class StorageBackedJobHistory
implements IJobHistory {
    private final String jobId;
    private final IJobHistoryStorage storage;

    public StorageBackedJobHistory(String jobId, IJobHistoryStorage storage) {
        this.jobId = jobId;
        this.storage = storage;
    }

    @Override
    public Collection<IJobHistoryEntry> getEntries() {
        try {
            return new PagableHistoryEntryCollection(this.jobId, this.storage, 500);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading history.", e);
        }
    }

    public String toString() {
        return String.format("%s[ %s (using %s) ]", this.getClass().getSimpleName(), this.jobId, this.storage);
    }
}

