/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.cloud.services.queue.IMessage;
import org.eclipse.gyrex.common.identifiers.IdHelper;

public class JobInfo {
    private static final String PREFIX = "gyrex.jobinfo.";
    private static final String ID = "gyrex.jobinfo.jobid";
    private static final String TYPE_ID = "gyrex.jobinfo.jobtype";
    private static final String CONTEXT_PATH = "gyrex.jobinfo.jobcontext";
    private static final String QUEUE_TRIGGER = "gyrex.jobinfo.queueTrigger";
    private static final String QUEUE_TIMESTAMP = "gyrex.jobinfo.queueTimestamp";
    private static final String VERSION = "gyrex.jobinfo.version";
    private static final String VERSION_VALUE = "1";
    private static final String SCHEDULE_INFO = "gyrex.jobinfo.scheduleInfo";
    private static final String LAST_SUCCESSFUL_START = "gyrex.jobinfo.lastSuccessfulStart";
    private final String jobId;
    private final String jobTypeId;
    private final Map<String, String> jobProperties;
    private final IPath contextPath;
    private final String queueTrigger;
    private final long queueTimestamp;
    private final String scheduleInfo;
    private final long lastSuccessfulStart;

    public static byte[] asMessage(JobInfo info) throws IOException {
        Properties properties = new Properties();
        Map<String, String> jobProperties = info.getJobProperties();
        for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        try {
            properties.put(VERSION, VERSION_VALUE);
            properties.put(ID, info.getJobId());
            properties.put(TYPE_ID, info.getJobTypeId());
            properties.put(CONTEXT_PATH, info.getContextPath().toString());
            properties.put(QUEUE_TRIGGER, info.getQueueTrigger());
            properties.put(QUEUE_TIMESTAMP, String.valueOf(info.getQueueTimestamp()));
            properties.put(LAST_SUCCESSFUL_START, String.valueOf(info.getLastSuccessfulStart()));
            if (StringUtils.isNotBlank((String)info.getScheduleInfo())) {
                properties.put(SCHEDULE_INFO, info.getScheduleInfo());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException(String.format("Invalid job info: %s", info));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object object = null;
        Object var5_6 = null;
        try (DeflaterOutputStream df = new DeflaterOutputStream((OutputStream)out);){
            properties.store(df, null);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        return out.toByteArray();
    }

    public static JobInfo parse(IMessage message) throws IOException {
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(message.getBody()));){
            properties.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Object versionValue = properties.remove(VERSION);
        if (!VERSION_VALUE.equals(versionValue)) {
            throw new IOException(String.format("invalid record data: version mismatch (expected %s, found %s)", VERSION_VALUE, String.valueOf(versionValue)));
        }
        Object jobIdValue = properties.remove(ID);
        if (jobIdValue == null || !(jobIdValue instanceof String) || !IdHelper.isValidId((String)((String)jobIdValue))) {
            throw new IOException(String.format("invalid record data: missing/invalid job id %s", String.valueOf(jobIdValue)));
        }
        Object jobTypeValue = properties.remove(TYPE_ID);
        if (jobTypeValue == null || !(jobTypeValue instanceof String) || !IdHelper.isValidId((String)((String)jobTypeValue))) {
            throw new IOException(String.format("invalid record data: missing/invalid job id %s", String.valueOf(jobTypeValue)));
        }
        Object contextPathValue = properties.remove(CONTEXT_PATH);
        if (contextPathValue == null || !(contextPathValue instanceof String) || !Path.EMPTY.isValidPath((String)contextPathValue)) {
            throw new IOException(String.format("invalid record data: missing/invalid context path %s", String.valueOf(contextPathValue)));
        }
        Object queueTrigger = properties.remove(QUEUE_TRIGGER);
        if (queueTrigger != null && !(queueTrigger instanceof String)) {
            throw new IOException(String.format("invalid record data: invalid queue trigger %s", String.valueOf(queueTrigger)));
        }
        Object queueTimestamp = properties.remove(QUEUE_TIMESTAMP);
        if (queueTimestamp == null || !(queueTimestamp instanceof String)) {
            throw new IOException(String.format("invalid record data: missing/invalid queue timestamp %s", String.valueOf(queueTimestamp)));
        }
        Object scheduleInfo = properties.remove(SCHEDULE_INFO);
        if (scheduleInfo != null && !(scheduleInfo instanceof String)) {
            throw new IOException(String.format("invalid record data: invalid schedule info %s", String.valueOf(scheduleInfo)));
        }
        Object lastSuccessfulStart = properties.remove(LAST_SUCCESSFUL_START);
        if (lastSuccessfulStart == null || !(lastSuccessfulStart instanceof String)) {
            throw new IOException(String.format("invalid record data: missing/invalid last successful finish timestamp %s", String.valueOf(lastSuccessfulStart)));
        }
        HashMap<String, String> jobProperties = new HashMap<String, String>();
        for (String string : properties.keySet()) {
            if (string.startsWith(PREFIX)) continue;
            jobProperties.put(string, properties.getProperty(string));
        }
        return new JobInfo((String)jobTypeValue, (String)jobIdValue, (IPath)new Path((String)contextPathValue), jobProperties, (String)queueTrigger, NumberUtils.toLong((String)((String)queueTimestamp)), (String)scheduleInfo, NumberUtils.toLong((String)((String)lastSuccessfulStart)));
    }

    public JobInfo(String jobTypeId, String jobId, IPath contextPath, Map<String, String> jobProperties, String queueTrigger, long queueTimestamp, String scheduleInfo, long lastSuccessfulStart) {
        this.jobId = jobId;
        this.jobTypeId = jobTypeId;
        this.contextPath = contextPath;
        this.jobProperties = jobProperties;
        this.queueTrigger = queueTrigger;
        this.queueTimestamp = queueTimestamp;
        this.scheduleInfo = scheduleInfo;
        this.lastSuccessfulStart = lastSuccessfulStart;
    }

    public IPath getContextPath() {
        return this.contextPath;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    public String getJobTypeId() {
        return this.jobTypeId;
    }

    public long getLastSuccessfulStart() {
        return this.lastSuccessfulStart;
    }

    public long getQueueTimestamp() {
        return this.queueTimestamp;
    }

    public String getQueueTrigger() {
        return this.queueTrigger;
    }

    public String getScheduleInfo() {
        return this.scheduleInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JobInfo [jobId=").append(this.jobId).append(", jobTypeId=").append(this.jobTypeId).append(", contextPath=").append(this.contextPath).append(", queueTrigger=").append(this.queueTrigger).append(", queueTimestamp=").append(this.queueTimestamp).append(", scheduleInfo=").append(this.scheduleInfo).append(", lastSuccessfulStart=").append(this.lastSuccessfulStart).append(", jobProperties=").append(this.jobProperties).append("]");
        return builder.toString();
    }
}

