/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.commands.BaseSwCmd;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.kohsuke.args4j.Argument;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public final class AddPkgCmd
extends BaseSwCmd {
    @Argument(index=0, usage="the package id", required=true, metaVar="ID")
    String id;
    @Argument(index=1, usage="an optional node filter", required=false, metaVar="FILTER")
    String filter;

    public AddPkgCmd() {
        super("<id> - adds a package");
    }

    protected void doExecute() throws Exception {
        if (!IdHelper.isValidId((String)this.id)) {
            this.printf("invalid package id", new Object[0]);
            return;
        }
        PackageDefinition packageDefinition = new PackageDefinition();
        packageDefinition.setId(this.id);
        if (StringUtils.isNotBlank((String)this.filter)) {
            try {
                FrameworkUtil.createFilter((String)this.filter);
            }
            catch (InvalidSyntaxException e) {
                this.printf("ERROR: invalid filter: %s", new Object[]{e.getMessage()});
            }
            packageDefinition.setNodeFilter(this.filter);
        }
        this.getPackageManager().savePackage(packageDefinition);
        this.printf("Package added. You should now add installation artifacts to it.", new Object[0]);
    }
}

