/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.gyrex.common.internal.applications.BaseApplication;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.scheduler.Scheduler;
import org.eclipse.gyrex.jobs.internal.scheduler.SchedulerApplicationMetrics;
import org.eclipse.gyrex.jobs.internal.util.WaitForJobToFinishJob;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerApplication
extends BaseApplication {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerApplication.class);
    private Scheduler scheduler;
    private SchedulerApplicationMetrics metrics;
    private ServiceRegistration<MetricSet> metricsRegistration;

    protected void doCleanup() {
        Scheduler scheduler = this.scheduler;
        if (scheduler != null) {
            this.scheduler = null;
            scheduler.cancel();
        }
    }

    protected void doStart(Map arguments) throws Exception {
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Starting scheduler engine application.");
        }
        this.metrics = new SchedulerApplicationMetrics();
        this.metricsRegistration = JobsActivator.registerMetrics(this.metrics);
        this.metrics.setApplicationStatus("STARTING", "application started");
        this.scheduler = new Scheduler(this.metrics);
        this.scheduler.schedule();
        this.metrics.setApplicationStatus("STARTED", "scheduler activated");
    }

    /*
     * Loose catch block
     */
    protected Object doStop() {
        ServiceRegistration<MetricSet> metricsRegistration;
        block16: {
            Integer n;
            block17: {
                Scheduler scheduler = this.scheduler;
                if (scheduler == null) {
                    return EXIT_OK;
                }
                if (JobsDebug.schedulerEngine) {
                    LOG.debug("Stopping scheduler engine application...");
                }
                metricsRegistration = this.metricsRegistration;
                SchedulerApplicationMetrics metrics = this.metrics;
                metrics.setApplicationStatus("STOPPING", "application shutdown");
                this.scheduler = null;
                this.metricsRegistration = null;
                this.metrics = null;
                if (scheduler.cancel()) break block16;
                LOG.info("Waiting up to {}s for scheduler engine to finish...", (Object)60);
                CountDownLatch wait = new CountDownLatch(1);
                WaitForJobToFinishJob job = new WaitForJobToFinishJob("Scheduler Engine Shutdown Job", scheduler, wait);
                job.schedule();
                if (wait.await(60L, TimeUnit.SECONDS)) break block16;
                LOG.warn("Time out waiting for scheduler engine to shutdown. A complete restart (or shutdown) of the current process is recommended.");
                n = EXIT_ERROR;
                if (metricsRegistration == null) break block17;
                try {
                    metricsRegistration.unregister();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            return n;
            {
                catch (InterruptedException interruptedException) {
                    try {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable throwable) {
                        if (metricsRegistration != null) {
                            try {
                                metricsRegistration.unregister();
                            }
                            catch (IllegalStateException illegalStateException) {}
                        }
                        throw throwable;
                    }
                }
            }
        }
        if (metricsRegistration != null) {
            try {
                metricsRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Scheduler engine application engine stopped.");
        }
        return EXIT_OK;
    }

    protected Logger getLogger() {
        return LOG;
    }
}

