/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal.zookeeper;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;

public class ZooKeeperData {
    private static final Object PROP_PATH = new Object();
    private static final Object PROP_VERSION = new Object();
    private static final Object PROP_CVERSION = new Object();
    private static final Object PROP_DATA_LENGTH = new Object();
    private static final Object PROP_EPHEMERAL_OWNER = new Object();
    private static final Object PROP_DATA = new Object();
    private final IPath path;
    private Stat stat;
    private Object[] children;
    private final ZooKeeperData parent;

    public ZooKeeperData(IPath path, ZooKeeperData parent) {
        this.path = path;
        this.parent = parent;
    }

    private String asString(byte[] data) {
        if (data == null) {
            return "";
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
    }

    public Object[] getChildren() {
        if (this.children == null) {
            this.load();
        }
        return this.children;
    }

    private Object getData() {
        byte[] data;
        block5: {
            if (this.stat == null) {
                this.load();
            }
            try {
                data = ZooKeeperGate.get().readRecord(this.path, this.stat);
                if (data != null) break block5;
                return null;
            }
            catch (Exception e) {
                return ExceptionUtils.getRootCauseMessage((Throwable)e);
            }
        }
        if (this.isPropertiesBased()) {
            Properties prop = new Properties();
            prop.load(new ByteArrayInputStream(data));
            return prop;
        }
        return WordUtils.wrap((String)this.asString(data), (int)80);
    }

    public String getLabel() {
        Stat stat = this.getStat();
        if (stat.getDataLength() > 0 && this.isStringBased()) {
            String data = StringUtils.left((String)String.valueOf(this.getData()), (int)70);
            if (stat.getEphemeralOwner() != 0L) {
                return String.format("%s (ephemeral, v%d) [%s]", this.path.segmentCount() > 0 ? this.path.lastSegment() : "/", stat.getVersion(), data);
            }
            return String.format("%s (v%d) [%s]", this.path.segmentCount() > 0 ? this.path.lastSegment() : "/", stat.getVersion(), data);
        }
        if (stat.getEphemeralOwner() != 0L) {
            return String.format("%s (ephemeral, v%d)", this.path.segmentCount() > 0 ? this.path.lastSegment() : "/", stat.getVersion());
        }
        if (stat.getDataLength() > 0) {
            return String.format("%s (v%d, c%d, %d bytes)", this.path.segmentCount() > 0 ? this.path.lastSegment() : "/", stat.getVersion(), stat.getCversion(), stat.getDataLength());
        }
        return String.format("%s (v%d, c%d)", this.path.segmentCount() > 0 ? this.path.lastSegment() : "/", stat.getVersion(), stat.getCversion());
    }

    public ZooKeeperData getParent() {
        return this.parent;
    }

    public Object getPropertyValue(Object id) {
        if (id == PROP_PATH) {
            return this.path;
        }
        if (id == PROP_VERSION) {
            return this.getStat().getVersion();
        }
        if (id == PROP_CVERSION) {
            return this.getStat().getCversion();
        }
        if (id == PROP_EPHEMERAL_OWNER) {
            return "0x" + Long.toHexString(this.getStat().getEphemeralOwner());
        }
        if (id == PROP_DATA_LENGTH) {
            return this.getStat().getDataLength();
        }
        if (id == PROP_DATA) {
            return this.getData();
        }
        return null;
    }

    public Stat getStat() {
        if (this.stat == null) {
            this.load();
        }
        return this.stat;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    private boolean isPropertiesBased() {
        return IZooKeeperLayout.PATH_PREFERENCES_ROOT.isPrefixOf(this.path) || IZooKeeperLayout.PATH_NODES_APPROVED.isPrefixOf(this.path) || IZooKeeperLayout.PATH_NODES_PENDING.isPrefixOf(this.path);
    }

    private boolean isStringBased() {
        return IZooKeeperLayout.PATH_LOCKS_ROOT.isPrefixOf(this.path) || IZooKeeperLayout.PATH_NODES_ALL.isPrefixOf(this.path) || IZooKeeperLayout.PATH_NODES_ONLINE.isPrefixOf(this.path) || IZooKeeperLayout.PATH_JOBS_ROOT.isPrefixOf(this.path);
    }

    private void load() {
        this.stat = new Stat();
        try {
            byte[] data;
            List names = ZooKeeperGate.get().readChildrenNames(this.path, this.stat);
            ArrayList<Object> children = new ArrayList<Object>();
            if (names.size() > 0) {
                for (String name : names) {
                    children.add(new ZooKeeperData(this.path.append(name), this));
                }
            }
            if (this.isPropertiesBased() && (data = ZooKeeperGate.get().readRecord(this.path, this.stat)) != null) {
                Properties prop = new Properties();
                prop.load(new ByteArrayInputStream(data));
                Set<Map.Entry<Object, Object>> entrySet = prop.entrySet();
                for (Map.Entry<Object, Object> e : entrySet) {
                    children.add(String.format("%s=%s", e.getKey(), e.getValue()));
                }
            }
            this.children = children.toArray();
        }
        catch (Exception e) {
            this.children = new String[]{ExceptionUtils.getRootCauseMessage((Throwable)e)};
        }
    }
}

