/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.context.definitions.IRuntimeContextDefinitionManager;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.manager.ContextManagerImpl;
import org.eclipse.gyrex.context.internal.provider.ObjectProviderRegistry;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.manager.IRuntimeContextManager;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ContextActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.context";
    private static final AtomicReference<ContextActivator> instanceRef = new AtomicReference();
    private volatile ContextRegistryImpl contextRegistry;
    private volatile ObjectProviderRegistry objectProviderRegistry;

    public static ContextActivator getInstance() {
        ContextActivator contextActivator = instanceRef.get();
        if (contextActivator == null) {
            throw new IllegalStateException(NLS.bind((String)"The Gyrex contextual runtime bundle {0} is inactive.", (Object)SYMBOLIC_NAME));
        }
        return contextActivator;
    }

    public ContextActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instanceRef.set(this);
        this.contextRegistry = new ContextRegistryImpl();
        this.getServiceHelper().registerService(new String[]{IRuntimeContextRegistry.class.getName(), IRuntimeContextDefinitionManager.class.getName()}, (Object)this.contextRegistry, "Eclipse.org Gyrex", "Eclipse Gyrex Contextual Runtime Registry & Definition Manager", null, null);
        ContextManagerImpl contextManager = new ContextManagerImpl(this.contextRegistry);
        this.getServiceHelper().registerService(IRuntimeContextManager.class.getName(), (Object)contextManager, "Eclipse.org Gyrex", "Eclipse Gyrex Contextual Runtime Manager", null, null);
        this.addShutdownParticipant(contextManager);
    }

    protected synchronized void doStop(BundleContext context) throws Exception {
        instanceRef.set(null);
        if (this.contextRegistry != null) {
            this.contextRegistry.close();
            this.contextRegistry = null;
        }
        if (this.objectProviderRegistry != null) {
            this.objectProviderRegistry.close();
            this.objectProviderRegistry = null;
        }
    }

    public ContextRegistryImpl getContextRegistryImpl() {
        ContextRegistryImpl registry = this.contextRegistry;
        if (registry == null) {
            throw this.createBundleInactiveException();
        }
        return registry;
    }

    protected Class getDebugOptions() {
        return ContextDebug.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectProviderRegistry getObjectProviderRegistry() {
        ObjectProviderRegistry registry = this.objectProviderRegistry;
        if (registry == null) {
            ContextActivator contextActivator = this;
            synchronized (contextActivator) {
                if (this.objectProviderRegistry != null) {
                    return this.objectProviderRegistry;
                }
                if (!this.isActive()) {
                    throw this.createBundleInactiveException();
                }
                registry = this.objectProviderRegistry = new ObjectProviderRegistry();
                registry.start(this.getBundle().getBundleContext());
            }
        }
        return registry;
    }

    public IPreferencesService getPreferencesService() {
        return (IPreferencesService)this.getServiceHelper().trackService(IPreferencesService.class).getService();
    }
}

