/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk.console;

import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.gyrex.cloud.internal.zk.GateDownException;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.common.console.Command;

public class GateStatusCmd
extends Command {
    public GateStatusCmd() {
        super("prints the ZooKeeper gate status");
    }

    protected void doExecute() throws Exception {
        try {
            ZooKeeperGate gate = ZooKeeperGate.get();
            ZooKeeper zk = gate.getZooKeeper();
            this.printf("Connect String: %s", new Object[]{gate.getConnectString()});
            this.printf("       Timeout: %dms", new Object[]{gate.getSessionTimeout()});
            if (gate.getLastStateChangeTimestamp() > 0L) {
                this.printf("         State: %s (since %s)", new Object[]{zk.getState(), DateFormatUtils.SMTP_DATETIME_FORMAT.format(gate.getLastStateChangeTimestamp())});
            } else {
                this.printf("         State: %s (initial state)", new Object[]{zk.getState()});
            }
            this.printf("       Session: 0x%s", new Object[]{Long.toHexString(zk.getSessionId())});
            this.printf("    Connection: %s", new Object[]{gate.getConnectedServerInfo()});
        }
        catch (GateDownException gateDownException) {
            this.printf("Gate is down.", new Object[0]);
        }
    }
}

