/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.pages;

import java.util.Collections;
import java.util.List;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.DropDownItem;
import org.eclipse.gyrex.admin.ui.pages.AdminPage;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class FilteredAdminPage
extends AdminPage {
    private Composite filterPanel;
    private List<String> filters;

    protected Control createFilterControl(String filter, Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(parent, 0);
        label.setText(filter);
        return composite;
    }

    public final void createFilterControls(Composite parent) {
        this.filterPanel = new Composite(parent, 0);
        this.filterPanel.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(5, false));
        for (final String filter : this.getFilters()) {
            new DropDownItem(this.filterPanel, this.getFilterText(filter), "filter"){
                private static final long serialVersionUID = 1L;

                @Override
                protected void openDropDown(Point location) {
                    this.setOpen(true);
                    FilteredAdminPage.this.openFilterPopUp(filter, location, new Runnable(){

                        @Override
                        public void run() {
                            this.setOpen(false);
                        }
                    });
                }
            };
        }
        this.updateFilterPanel();
    }

    protected List<String> getFilters() {
        if (this.filters == null) {
            return Collections.emptyList();
        }
        return this.filters;
    }

    protected String getFilterText(String filter) {
        return filter;
    }

    void openFilterPopUp(final String filter, final Point location, final Runnable closeCallback) {
        PopupDialog dialog = new PopupDialog(SwtUtil.getShell((Widget)this.filterPanel), 24, false, false, false, false, false, null, null){
            private static final long serialVersionUID = 1L;

            protected void adjustBounds() {
                this.getShell().pack(true);
                this.getShell().setLocation(location);
            }

            public boolean close() {
                boolean closed = super.close();
                if (!closed) {
                    return closed;
                }
                if (closeCallback != null) {
                    closeCallback.run();
                }
                return closed;
            }

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setLayout((Layout)new FillLayout());
                shell.setData("org.eclipse.rap.rwt.customVariant", (Object)"filter-popup");
            }

            protected Control createContents(Composite parent) {
                Control control = FilteredAdminPage.this.createFilterControl(filter, parent);
                if (parent.getLayout() instanceof FillLayout) {
                    Control[] children;
                    Control[] controlArray = children = parent.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        if (child.getLayoutData() != null) {
                            throw new IllegalStateException(String.format("%s#createFilterControl not allowed to set layout data on children!", FilteredAdminPage.this.getClass()));
                        }
                        ++n2;
                    }
                }
                return control;
            }

            public int open() {
                int result = super.open();
                Listener closeListener = new Listener(){
                    private static final long serialVersionUID = 1L;

                    public void handleEvent(Event event) {
                        this.close();
                    }
                };
                this.getShell().addListener(27, closeListener);
                this.getShell().addListener(21, closeListener);
                this.getShell().setActive();
                return result;
            }
        };
        dialog.open();
    }

    protected void setFilters(List<String> filters) {
        this.filters = filters;
    }

    void updateFilterPanel() {
        this.filterPanel.setVisible(!this.getFilters().isEmpty());
    }
}

