/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;

final class Operation {
    private final String action;
    private final String target;
    private final String detail;
    private final JsonObject properties;

    Operation(String target, String action, String detail, JsonObject properties) {
        this.target = target;
        this.action = action;
        this.detail = detail;
        this.properties = properties == null ? new JsonObject() : properties;
    }

    String getTarget() {
        return this.target;
    }

    String getAction() {
        return this.action;
    }

    void putProperty(String key, JsonValue value) {
        this.properties.remove(key);
        this.properties.add(key, value);
    }

    JsonValue toJson() {
        JsonArray json = new JsonArray();
        json.add(this.action);
        json.add(this.target);
        if (this.detail != null) {
            json.add(this.detail);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            json.add(this.properties);
        }
        return json;
    }
}

