/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.kohsuke.args4j.Argument;
import org.osgi.service.prefs.Preferences;

public class DumpCmd
extends Command {
    @Argument(index=0, required=true, usage="path to a preference node")
    protected String path;

    public DumpCmd() {
        super("[<path>] - dumps preferences");
    }

    protected void doExecute() throws Exception {
        IPreferencesService preferencesService = EclipsePreferencesUtil.getPreferencesService();
        IEclipsePreferences node = preferencesService.getRootNode();
        String[] decodedPath = EclipsePreferencesUtil.decodePath(StringUtils.trimToEmpty((String)this.path));
        Preferences preferencesNode = node.node(StringUtils.trimToEmpty((String)decodedPath[0]));
        this.dumpTree(0, preferencesNode);
    }

    private void dumpTree(int indent, Preferences node) throws Exception {
        String[] children;
        this.printNodeInfo(indent, node);
        String[] stringArray = children = node.childrenNames();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            this.dumpTree(indent + 1, node.node(child));
            ++n2;
        }
    }

    private void printNodeInfo(int indent, Preferences node) throws Exception {
        StrBuilder spaces = new StrBuilder();
        int i = 0;
        while (i < indent) {
            spaces.append(" ");
            ++i;
        }
        this.printf(spaces.append(node.name()).append(" (").append(node.toString()).append(")").toString(), new Object[0]);
    }
}

