/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import java.util.concurrent.TimeUnit;
import org.eclipse.gyrex.preferences.internal.console.PathBasedCmd;
import org.osgi.service.prefs.Preferences;

public class SyncCmd
extends PathBasedCmd {
    public SyncCmd() {
        super(" - syncs a preference hierarchy");
    }

    @Override
    protected void doExecute(Preferences node) throws Exception {
        long start = System.nanoTime();
        node.sync();
        long duration = System.nanoTime() - start;
        if (TimeUnit.NANOSECONDS.toMillis(duration) > 1000L) {
            this.printf("Sync finished in %d seconds.", new Object[]{TimeUnit.NANOSECONDS.toSeconds(duration)});
        } else if (TimeUnit.NANOSECONDS.toMillis(duration) > 10L) {
            this.printf("Sync finished in %d milli seconds.", new Object[]{TimeUnit.NANOSECONDS.toMillis(duration)});
        } else {
            this.printf("Sync finished in %d nano seconds.", new Object[]{duration});
        }
    }
}

